/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.cli;

import com.datical.liquibase.ext.checks.config.cli.AbstractCommandLineValueGetter;
import java.util.Arrays;

public class EnumGetter<E extends Enum>
extends AbstractCommandLineValueGetter<E> {
    private final Class<E> e;
    private final boolean ignoreCase;

    public EnumGetter(Class<E> clazz) {
        this(clazz, false);
    }

    public EnumGetter(Class<E> clazz, boolean bl2) {
        super(clazz);
        this.e = clazz;
        this.ignoreCase = bl2;
    }

    @Override
    public boolean validate(E e2) {
        return true;
    }

    @Override
    public E convert(String string) {
        if (this.ignoreCase) {
            return (E)Arrays.stream(this.e.getEnumConstants()).filter(enum_ -> enum_.name().equalsIgnoreCase(string)).findAny().orElseThrow(() -> new IllegalArgumentException("No enum constant " + this.e.getCanonicalName() + "." + string));
        }
        return Enum.valueOf(this.e, string);
    }
}

