/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;

public final class Checksum {
    public static final Algorithm CRC8_EGTS = new Algorithm(8, 49, 255, false, false, 0);
    public static final Algorithm CRC8_ROHC = new Algorithm(8, 7, 255, true, true, 0);
    public static final Algorithm CRC16_IBM = new Algorithm(16, 32773, 0, true, true, 0);
    public static final Algorithm CRC16_X25 = new Algorithm(16, 4129, 65535, true, true, 65535);
    public static final Algorithm CRC16_MODBUS = new Algorithm(16, 32773, 65535, true, true, 0);
    public static final Algorithm CRC16_CCITT_FALSE = new Algorithm(16, 4129, 65535, false, false, 0);
    public static final Algorithm CRC16_KERMIT = new Algorithm(16, 4129, 0, true, true, 0);
    public static final Algorithm CRC16_XMODEM = new Algorithm(16, 4129, 0, false, false, 0);

    private Checksum() {
    }

    private static int reverse(int value, int bits) {
        int result = 0;
        for (int i = 0; i < bits; ++i) {
            result = result << 1 | value & 1;
            value >>= 1;
        }
        return result;
    }

    public static int crc8(Algorithm algorithm, ByteBuffer buf) {
        int crc = algorithm.init;
        while (buf.hasRemaining()) {
            int b = buf.get() & 0xFF;
            if (algorithm.refIn) {
                b = Checksum.reverse(b, 8);
            }
            crc = algorithm.table[crc & 0xFF ^ b];
        }
        if (algorithm.refOut) {
            crc = Checksum.reverse(crc, 8);
        }
        return (crc ^ algorithm.xorOut) & 0xFF;
    }

    public static int crc16(Algorithm algorithm, ByteBuffer buf) {
        int crc = algorithm.init;
        while (buf.hasRemaining()) {
            int b = buf.get() & 0xFF;
            if (algorithm.refIn) {
                b = Checksum.reverse(b, 8);
            }
            crc = crc << 8 ^ algorithm.table[crc >> 8 & 0xFF ^ b];
        }
        if (algorithm.refOut) {
            crc = Checksum.reverse(crc, 16);
        }
        return (crc ^ algorithm.xorOut) & 0xFFFF;
    }

    public static int crc32(ByteBuffer buf) {
        CRC32 checksum = new CRC32();
        while (buf.hasRemaining()) {
            checksum.update(buf.get());
        }
        return (int)checksum.getValue();
    }

    public static int xor(ByteBuffer buf) {
        int checksum = 0;
        while (buf.hasRemaining()) {
            checksum ^= buf.get();
        }
        return checksum;
    }

    public static int xor(String string) {
        int checksum = 0;
        for (byte b : string.getBytes(StandardCharsets.US_ASCII)) {
            checksum = (byte)(checksum ^ b);
        }
        return checksum;
    }

    public static String nmea(String string) {
        return String.format("*%02X", Checksum.xor(string));
    }

    public static int sum(ByteBuffer buf) {
        int checksum = 0;
        while (buf.hasRemaining()) {
            checksum = (byte)(checksum + buf.get());
        }
        return checksum;
    }

    public static int modulo256(ByteBuffer buf) {
        int checksum = 0;
        while (buf.hasRemaining()) {
            checksum = checksum + buf.get() & 0xFF;
        }
        return checksum;
    }

    public static String sum(String msg) {
        byte checksum = 0;
        for (byte b : msg.getBytes(StandardCharsets.US_ASCII)) {
            checksum = (byte)(checksum + b);
        }
        return String.format("%02X", checksum).toUpperCase();
    }

    public static long luhn(long imei) {
        long checksum = 0L;
        long remain = imei;
        int i = 0;
        while (remain != 0L) {
            long digit = remain % 10L;
            if (i % 2 == 0 && (digit *= 2L) >= 10L) {
                digit = 1L + digit % 10L;
            }
            checksum += digit;
            remain /= 10L;
            ++i;
        }
        return (10L - checksum % 10L) % 10L;
    }

    public static class Algorithm {
        private final int poly;
        private final int init;
        private final boolean refIn;
        private final boolean refOut;
        private final int xorOut;
        private final int[] table;

        public Algorithm(int bits, int poly, int init, boolean refIn, boolean refOut, int xorOut) {
            this.poly = poly;
            this.init = init;
            this.refIn = refIn;
            this.refOut = refOut;
            this.xorOut = xorOut;
            this.table = bits == 8 ? this.initTable8() : this.initTable16();
        }

        private int[] initTable8() {
            int[] table = new int[256];
            for (int i = 0; i < 256; ++i) {
                int crc = i;
                for (int j = 0; j < 8; ++j) {
                    boolean bit = (crc & 0x80) != 0;
                    crc <<= 1;
                    if (!bit) continue;
                    crc ^= this.poly;
                }
                table[i] = crc & 0xFF;
            }
            return table;
        }

        private int[] initTable16() {
            int[] table = new int[256];
            for (int i = 0; i < 256; ++i) {
                int crc = i << 8;
                for (int j = 0; j < 8; ++j) {
                    boolean bit = (crc & 0x8000) != 0;
                    crc <<= 1;
                    if (!bit) continue;
                    crc ^= this.poly;
                }
                table[i] = crc & 0xFFFF;
            }
            return table;
        }
    }
}

