/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicProgressBarUI;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.ZapTextArea;
import org.zaproxy.zap.view.LayoutHelper;

public class SplashScreen
extends JFrame {
    private static final String TIPS_PREFIX = "tips";
    private static final String TIPS_TIP_PREFIX = "tips.tip.";
    private static final Logger LOGGER = LogManager.getLogger(SplashScreen.class);
    private static final long serialVersionUID = 1L;
    private JScrollPane logScrollPane = null;
    private JScrollPane tipsScrollPane = null;
    private JProgressBar loadProgressBar = null;
    private ZapTextArea logPanel = null;
    private ZapTextArea tipsPanel = null;
    private List<String> tipsAndTricks = null;
    private final Random random = new Random();
    private boolean tipsLoaded = false;
    private double currentPerc;
    private SplashScreenAppender splashScreenAppender;

    public SplashScreen() {
        this.setSize(DisplayUtils.getScaledDimension(420, 430));
        this.setLocationRelativeTo(null);
        this.setTitle("OWASP ZAP");
        this.setIconImages(DisplayUtils.getZapIconImages());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setPreferredSize(DisplayUtils.getScaledDimension(420, 430));
        if (!DisplayUtils.isDarkLookAndFeel()) {
            panel.setBackground(Color.decode("#F4FAFF"));
        }
        Border margin = BorderFactory.createEtchedBorder(0);
        Border padding = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        panel.setBorder(BorderFactory.createCompoundBorder(margin, padding));
        JLabel lblVersion = new JLabel();
        JLabel lblProgramName = new JLabel();
        lblProgramName.setText("OWASP ZAP");
        lblProgramName.setFont(FontUtils.getFont(FontUtils.getQuicksandBoldFont(), FontUtils.Size.much_larger));
        lblProgramName.setVisible(true);
        lblProgramName.setName("lblProgramName");
        lblVersion.setText(Constant.PROGRAM_VERSION);
        lblVersion.setFont(FontUtils.getFont(FontUtils.getQuicksandBoldFont(), FontUtils.Size.larger));
        lblVersion.setName("lblVersion");
        panel.add((Component)lblProgramName, LayoutHelper.getGBC(0, 0, 1, 1.0, DisplayUtils.getScaledInsets(40, 30, 0, 1)));
        panel.add((Component)lblVersion, LayoutHelper.getGBC(0, 1, 1, 1.0, DisplayUtils.getScaledInsets(0, 30, 0, 1)));
        panel.add((Component)this.getLoadingJProgressBar(), LayoutHelper.getGBC(0, 2, 1, 1.0, 0.0, 2, DisplayUtils.getScaledInsets(20, 30, 64, 0)));
        panel.add((Component)new JLabel(SplashScreen.createSplashScreenImage()), LayoutHelper.getGBC(1, 0, 1, 3, 0.0, DisplayUtils.getScaledInsets(0, 0, 0, 15)));
        panel.add((Component)this.getTipsJScrollPane(), LayoutHelper.getGBC(0, 3, 2, 1.0, 1.0));
        panel.add((Component)this.getLogJScrollPane(), LayoutHelper.getGBC(0, 4, 2, 1.0, 0.5));
        this.setContentPane(panel);
        this.pack();
        this.splashScreenAppender = new SplashScreenAppender(this::appendMsg);
        LoggerContext.getContext().getConfiguration().getRootLogger().addAppender(this.splashScreenAppender, null, null);
        this.setVisible(true);
    }

    private static ImageIcon createSplashScreenImage() {
        ImageIcon image = new ImageIcon(SplashScreen.class.getResource("/resource/zap-splash-screen.png"));
        int width = DisplayUtils.getScaledSize((int)((double)image.getIconWidth() * 0.5));
        int height = DisplayUtils.getScaledSize((int)((double)image.getIconHeight() * 0.5));
        return new ImageIcon(image.getImage().getScaledInstance(width, height, 4));
    }

    public void setLoadingCompletion(double percentage) {
        this.currentPerc = percentage;
        this.updateLoadingJProgressBar();
    }

    public void addLoadingCompletion(double value) {
        this.currentPerc += value;
        this.updateLoadingJProgressBar();
    }

    private void updateLoadingJProgressBar() {
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SplashScreen.this.updateLoadingJProgressBar();
                    }
                });
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Failed to update progress bar: ", (Throwable)e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
        if (this.currentPerc > 100.0) {
            this.currentPerc = 100.0;
        } else if (this.currentPerc < 0.0) {
            this.currentPerc = 0.0;
        }
        this.getLoadingJProgressBar().setValue((int)this.currentPerc);
    }

    private JProgressBar getLoadingJProgressBar() {
        if (this.loadProgressBar == null) {
            this.loadProgressBar = new JProgressBar();
            this.loadProgressBar.setPreferredSize(DisplayUtils.getScaledDimension(100, 12));
            this.loadProgressBar.setMinimum(0);
            this.loadProgressBar.setMaximum(100);
            this.loadProgressBar.setValue(50);
            this.loadProgressBar.setBorder(BorderFactory.createLineBorder(Color.black));
            this.loadProgressBar.setUI(new CustomProgressBarUI());
            this.loadProgressBar.setForeground(Color.decode("#4389FF"));
            this.setLoadingCompletion(0.0);
        }
        return this.loadProgressBar;
    }

    private JScrollPane getLogJScrollPane() {
        if (this.logScrollPane == null) {
            this.logScrollPane = new JScrollPane();
            this.logScrollPane.setViewportView(this.getLogPanel());
        }
        return this.logScrollPane;
    }

    private JScrollPane getTipsJScrollPane() {
        if (this.tipsScrollPane == null) {
            this.tipsScrollPane = new JScrollPane();
            this.tipsScrollPane.setViewportView(this.getTipsPanel());
        }
        return this.tipsScrollPane;
    }

    private ZapTextArea getLogPanel() {
        if (this.logPanel == null) {
            this.logPanel = new ZapTextArea();
            this.logPanel.setEditable(false);
            this.logPanel.setLineWrap(true);
            this.logPanel.setName("");
            this.logPanel.append(Constant.messages.getString("start.splash.start"));
        }
        return this.logPanel;
    }

    private ZapTextArea getTipsPanel() {
        if (this.tipsPanel == null) {
            this.tipsPanel = new ZapTextArea();
            this.tipsPanel.setEditable(false);
            this.tipsPanel.setLineWrap(true);
            this.tipsPanel.setWrapStyleWord(true);
            this.tipsPanel.setName("");
            this.tipsPanel.append(Constant.messages.getString("start.splash.tips.loading"));
            this.displayRandomTip();
        }
        return this.tipsPanel;
    }

    private void displayRandomTip() {
        if (this.tipsLoaded || this.getTipsAndTricks() == null) {
            return;
        }
        if (this.getTipsAndTricks().isEmpty()) {
            this.getTipsPanel().setText(Constant.messages.getString("start.splash.tips.none"));
            this.tipsLoaded = true;
            return;
        }
        this.getTipsPanel().setText(Constant.messages.getString("start.splash.tips.title"));
        this.getTipsPanel().append(this.getRandomTip());
        this.tipsLoaded = true;
    }

    public void close() {
        this.splashScreenAppender.stop();
        LoggerContext.getContext().getConfiguration().getRootLogger().removeAppender(this.splashScreenAppender.getName());
        this.dispose();
    }

    public void appendMsg(final String msg) {
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SplashScreen.this.appendMsg(msg);
                    }
                });
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Failed to append message: ", (Throwable)e);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return;
        }
        this.displayRandomTip();
        this.getLogPanel().append(msg);
        JScrollBar vertical = this.getLogJScrollPane().getVerticalScrollBar();
        vertical.setValue(vertical.getMaximum());
    }

    private List<String> getTipsAndTricks() {
        if (this.tipsAndTricks == null) {
            ResourceBundle rb = Constant.messages.getMessageBundle(TIPS_PREFIX);
            if (rb == null) {
                return null;
            }
            this.tipsAndTricks = new ArrayList<String>();
            Enumeration<String> enm = rb.getKeys();
            while (enm.hasMoreElements()) {
                String key = enm.nextElement();
                if (!key.startsWith(TIPS_TIP_PREFIX)) continue;
                this.tipsAndTricks.add(rb.getString(key));
            }
        }
        return this.tipsAndTricks;
    }

    private String getRandomTip() {
        return this.getTipsAndTricks().get(this.random.nextInt(this.getTipsAndTricks().size()));
    }

    public class CustomProgressBarUI
    extends BasicProgressBarUI {
        @Override
        public void paintDeterminate(Graphics g, JComponent c) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            Insets b = this.progressBar.getInsets();
            int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
            int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
            if (barRectWidth <= 0 || barRectHeight <= 0) {
                return;
            }
            int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
            if (this.progressBar.getOrientation() == 0) {
                g.setColor(this.progressBar.getForeground());
                g.fillRect(b.left, b.top, amountFull, barRectHeight);
            }
            if (this.progressBar.isStringPainted()) {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
            }
        }
    }

    static class SplashScreenAppender
    extends AbstractAppender {
        private static final Property[] NO_PROPERTIES = new Property[0];
        private final Consumer<String> logConsumer;

        SplashScreenAppender(Consumer<String> logConsumer) {
            super("ZAP-SplashScreenAppender", new LevelFilter(), PatternLayout.newBuilder().withPattern("%p: %m%n").build(), true, NO_PROPERTIES);
            this.logConsumer = logConsumer;
            this.start();
        }

        @Override
        public void append(LogEvent event) {
            this.logConsumer.accept((String)((StringLayout)this.getLayout()).toSerializable(event));
        }

        private static class LevelFilter
        extends AbstractFilter {
            private LevelFilter() {
            }

            @Override
            public Filter.Result filter(LogEvent event) {
                Level level = event.getLevel();
                return level == Level.INFO || level == Level.ERROR ? Filter.Result.ACCEPT : Filter.Result.DENY;
            }
        }
    }
}

