/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao;

import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.dao.SPUpgradePersister;
import java.util.HashMap;

public abstract class AbstractSPUpgradePersister
implements SPUpgradePersister {
    private SPPersister defaultNextPersister;
    private ThreadLocal<SPPersister> nextPersister = new ThreadLocal();
    private ThreadLocal<HashMap<String, String>> typeMap = new ThreadLocal();
    private final String topLevelObjectName;

    public AbstractSPUpgradePersister(String topLevelObjectName) {
        this.topLevelObjectName = topLevelObjectName;
    }

    @Override
    public void setNextPersister(SPPersister nextPersister, boolean isDefault) {
        if (isDefault) {
            this.defaultNextPersister = nextPersister;
        } else {
            this.nextPersister.set(nextPersister);
        }
    }

    @Override
    public SPPersister getNextPersister() {
        if (this.nextPersister.get() == null) {
            return this.defaultNextPersister;
        }
        return this.nextPersister.get();
    }

    @Override
    public void begin() throws SPPersistenceException {
        this.getNextPersister().begin();
    }

    @Override
    public void commit() throws SPPersistenceException {
        this.getNextPersister().commit();
    }

    @Override
    public void persistObject(String parentUUID, String type, String uuid, int index) throws SPPersistenceException {
        HashMap<String, String> localTypeMap = this.typeMap.get();
        if (localTypeMap == null) {
            localTypeMap = new HashMap();
            this.typeMap.set(localTypeMap);
        }
        localTypeMap.put(uuid, type);
        this.getNextPersister().persistObject(parentUUID, type, uuid, index);
    }

    @Override
    public void persistProperty(String uuid, String propertyName, SPPersister.DataType propertyType, Object oldValue, Object newValue) throws SPPersistenceException {
        this.getNextPersister().persistProperty(uuid, propertyName, propertyType, oldValue, newValue);
    }

    @Override
    public void persistProperty(String uuid, String propertyName, SPPersister.DataType propertyType, Object newValue) throws SPPersistenceException {
        this.getNextPersister().persistProperty(uuid, propertyName, propertyType, newValue);
    }

    @Override
    public void removeObject(String parentUUID, String uuid) throws SPPersistenceException {
        this.getNextPersister().removeObject(parentUUID, uuid);
    }

    @Override
    public void rollback() {
        this.getNextPersister().rollback();
    }

    @Override
    public String getNewTopLevelObjectName() {
        return this.topLevelObjectName;
    }

    @Override
    public String getOldTopLevelObjectName() {
        return this.topLevelObjectName;
    }

    public String getType(String uuid) {
        HashMap<String, String> localTypeMap = this.typeMap.get();
        if (localTypeMap == null) {
            return null;
        }
        return localTypeMap.get(uuid);
    }
}

