/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.metadata;

import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.metadata.Datatype;
import org.olap4j.metadata.DictionaryImpl;
import org.olap4j.metadata.MetadataElement;
import org.olap4j.metadata.XmlaConstant;
import org.olap4j.metadata.XmlaConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Property
extends MetadataElement {
    public Datatype getDatatype();

    public Set<TypeFlag> getType();

    public ContentType getContentType();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentType implements XmlaConstant
    {
        REGULAR(0),
        ID(1),
        RELATION_TO_PARENT(2),
        ROLLUP_OPERATOR(3),
        ORG_TITLE(17),
        CAPTION(33),
        CAPTION_SHORT(34),
        CAPTION_DESCRIPTION(35),
        CAPTION_ABREVIATION(36),
        WEB_URL(49),
        WEB_HTML(50),
        WEB_XML_OR_XSL(51),
        WEB_MAIL_ALIAS(52),
        ADDRESS(65),
        ADDRESS_STREET(66),
        ADDRESS_HOUSE(67),
        ADDRESS_CITY(68),
        ADDRESS_STATE_OR_PROVINCE(69),
        ADDRESS_ZIP(70),
        ADDRESS_QUARTER(71),
        ADDRESS_COUNTRY(72),
        ADDRESS_BUILDING(73),
        ADDRESS_ROOM(74),
        ADDRESS_FLOOR(75),
        ADDRESS_FAX(76),
        ADDRESS_PHONE(77),
        GEO_CENTROID_X(97),
        GEO_CENTROID_Y(98),
        GEO_CENTROID_Z(99),
        GEO_BOUNDARY_TOP(100),
        GEO_BOUNDARY_LEFT(101),
        GEO_BOUNDARY_BOTTOM(102),
        GEO_BOUNDARY_RIGHT(103),
        GEO_BOUNDARY_FRONT(104),
        GEO_BOUNDARY_REAR(105),
        GEO_BOUNDARY_POLYGON(106),
        PHYSICAL_SIZE(113),
        PHYSICAL_COLOR(114),
        PHYSICAL_WEIGHT(115),
        PHYSICAL_HEIGHT(116),
        PHYSICAL_WIDTH(117),
        PHYSICAL_DEPTH(118),
        PHYSICAL_VOLUME(119),
        PHYSICAL_DENSITY(120),
        PERSON_FULL_NAME(130),
        PERSON_FIRST_NAME(131),
        PERSON_LAST_NAME(132),
        PERSON_MIDDLE_NAME(133),
        PERSON_DEMOGRAPHIC(134),
        PERSON_CONTACT(135),
        QTY_RANGE_LOW(145),
        QTY_RANGE_HIGH(146),
        FORMATTING_COLOR(161),
        FORMATTING_ORDER(162),
        FORMATTING_FONT(163),
        FORMATTING_FONT_EFFECTS(164),
        FORMATTING_FONT_SIZE(165),
        FORMATTING_SUB_TOTAL(166),
        DATE(177),
        DATE_START(178),
        DATE_ENDED(179),
        DATE_CANCELED(180),
        DATE_MODIFIED(181),
        DATE_DURATION(182),
        VERSION(193);

        private final int xmlaOrdinal;
        private static final DictionaryImpl<ContentType> DICTIONARY;

        private ContentType(int xmlaOrdinal) {
            this.xmlaOrdinal = xmlaOrdinal;
        }

        @Override
        public String xmlaName() {
            return "MD_PROPTYPE_" + this.name();
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public int xmlaOrdinal() {
            return this.xmlaOrdinal;
        }

        public static XmlaConstant.Dictionary<ContentType> getDictionary() {
            return DICTIONARY;
        }

        static {
            DICTIONARY = DictionaryImpl.forClass(ContentType.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StandardCellProperty implements Property
    {
        BACK_COLOR(Datatype.STRING, 30, false, null, "The background color for displaying the VALUE or FORMATTED_VALUE property. For more information, see FORE_COLOR and BACK_COLOR Contents."),
        CELL_EVALUATION_LIST(Datatype.STRING, 31, false, null, "The semicolon-delimited list of evaluated formulas applicable to the cell, in order from lowest to highest solve order. For more information about solve order, see Understanding Pass Order and Solve Order"),
        CELL_ORDINAL(Datatype.UNSIGNED_INTEGER, 32, false, null, "The ordinal number of the cell in the dataset."),
        FORE_COLOR(Datatype.STRING, 33, false, null, "The foreground color for displaying the VALUE or FORMATTED_VALUE property. For more information, see FORE_COLOR and BACK_COLOR Contents."),
        FONT_NAME(Datatype.STRING, 34, false, null, "The font to be used to display the VALUE or FORMATTED_VALUE property."),
        FONT_SIZE(Datatype.STRING, 35, false, null, "Font size to be used to display the VALUE or FORMATTED_VALUE property."),
        FONT_FLAGS(Datatype.UNSIGNED_INTEGER, 36, false, XmlaConstants.FontFlag.class, "The bitmask detailing effects on the font. The value is the result of a bitwise OR operation of one or more of the following constants: MDFF_BOLD  = 1, MDFF_ITALIC = 2, MDFF_UNDERLINE = 4, MDFF_STRIKEOUT = 8. For example, the value 5 represents the combination of bold (MDFF_BOLD) and underline (MDFF_UNDERLINE) font effects."),
        FORMATTED_VALUE(Datatype.STRING, 37, false, null, "The character string that represents a formatted display of the VALUE property."),
        FORMAT_STRING(Datatype.STRING, 38, false, null, "The format string used to create the FORMATTED_VALUE property value. For more information, see FORMAT_STRING Contents."),
        NON_EMPTY_BEHAVIOR(Datatype.STRING, 39, false, null, "The measure used to determine the behavior of calculated members when resolving empty cells."),
        SOLVE_ORDER(Datatype.INTEGER, 40, false, null, "The solve order of the cell."),
        VALUE(Datatype.VARIANT, 41, false, null, "The unformatted value of the cell."),
        DATATYPE(Datatype.STRING, 42, false, null, "The datatype of the cell."),
        LANGUAGE(Datatype.UNSIGNED_INTEGER, 0, false, null, "The locale where the FORMAT_STRING will be applied. LANGUAGE is usually used for currency conversion."),
        ACTION_TYPE(Datatype.UNSIGNED_INTEGER, 0, false, null, "A bitmask that indicates which types of actions exist on the cell."),
        UPDATEABLE(Datatype.UNSIGNED_INTEGER, 0, false, XmlaConstants.Updateable.class, "A value that indicates whether the cell can be updated.");

        private final Datatype type;
        private final String description;
        private final boolean internal;

        private StandardCellProperty(Datatype type, int ordinal, boolean internal, Class<? extends Enum> enumClazz, String description) {
            this.type = type;
            this.internal = internal;
            this.description = description;
        }

        @Override
        public Datatype getDatatype() {
            return this.type;
        }

        @Override
        public Set<TypeFlag> getType() {
            return TypeFlag.CELL_TYPE_FLAG;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String getUniqueName() {
            return this.name();
        }

        @Override
        public String getCaption(Locale locale) {
            return this.name();
        }

        @Override
        public String getDescription(Locale locale) {
            return this.description;
        }

        public boolean isInternal() {
            return this.internal;
        }

        @Override
        public ContentType getContentType() {
            return ContentType.REGULAR;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StandardMemberProperty implements Property
    {
        CATALOG_NAME(Datatype.STRING, 10, false, null, "Optional. The name of the catalog to which this member belongs. NULL if the provider does not support catalogs."),
        SCHEMA_NAME(Datatype.STRING, 11, false, null, "Optional. The name of the schema to which this member belongs. NULL if the provider does not support schemas."),
        CUBE_NAME(Datatype.STRING, 12, false, null, "Required. Name of the cube to which this member belongs."),
        DIMENSION_UNIQUE_NAME(Datatype.STRING, 13, false, null, "Required. Unique name of the dimension to which this member belongs. For providers that generate unique names by qualification, each component of this name is delimited."),
        HIERARCHY_UNIQUE_NAME(Datatype.STRING, 14, false, null, "Required. Unique name of the hierarchy. If the member belongs to more than one hierarchy, there is one row for each hierarchy to which it belongs. For providers that generate unique names by qualification, each component of this name is delimited."),
        LEVEL_UNIQUE_NAME(Datatype.STRING, 15, false, null, "Required. Unique name of the level to which the member belongs. For providers that generate unique names by qualification, each component of this name is delimited."),
        LEVEL_NUMBER(Datatype.UNSIGNED_INTEGER, 16, false, null, "Required. The distance of the member from the root of the hierarchy. The root level is zero."),
        MEMBER_ORDINAL(Datatype.UNSIGNED_INTEGER, 17, false, null, "Required. Ordinal number of the member. Sort rank of the member when members of this dimension are sorted in their natural sort order. If providers do not have the concept of natural ordering, this should be the rank when sorted by MEMBER_NAME."),
        MEMBER_NAME(Datatype.STRING, 18, false, null, "Required. Name of the member."),
        MEMBER_UNIQUE_NAME(Datatype.STRING, 19, false, null, "Required. Unique name of the member. For providers that generate unique names by qualification, each component of this name is delimited."),
        MEMBER_TYPE(Datatype.STRING, 20, false, null, "Required. Type of the member. Can be one of the following values: MDMEMBER_Datatype.TYPE_REGULAR, MDMEMBER_Datatype.TYPE_ALL, MDMEMBER_Datatype.TYPE_FORMULA, MDMEMBER_Datatype.TYPE_MEASURE, MDMEMBER_Datatype.TYPE_UNKNOWN. MDMEMBER_Datatype.TYPE_FORMULA takes precedence over MDMEMBER_Datatype.TYPE_MEASURE. Therefore, if there is a formula (calculated) member on the Measures dimension, it is listed as MDMEMBER_Datatype.TYPE_FORMULA."),
        MEMBER_GUID(Datatype.STRING, 21, false, null, "Optional. Member GUID. NULL if no GUID exists."),
        MEMBER_CAPTION(Datatype.STRING, 22, false, null, "Required. A label or caption associated with the member. Used primarily for display purposes. If a caption does not exist, MEMBER_NAME is returned."),
        CHILDREN_CARDINALITY(Datatype.UNSIGNED_INTEGER, 23, false, null, "Required. Number of children that the member has. This can be an estimate, so consumers should not rely on this to be the exact count. Providers should return the best estimate possible."),
        PARENT_LEVEL(Datatype.UNSIGNED_INTEGER, 24, false, null, "Required. The distance of the member's parent from the root level of the hierarchy. The root level is zero."),
        PARENT_UNIQUE_NAME(Datatype.STRING, 25, false, null, "Required. Unique name of the member's parent. NULL is returned for any members at the root level. For providers that generate unique names by qualification, each component of this name is delimited."),
        PARENT_COUNT(Datatype.UNSIGNED_INTEGER, 26, false, null, "Required. Number of parents that this member has."),
        DESCRIPTION(Datatype.STRING, 27, false, null, "Optional. A human-readable description of the member."),
        $visible(Datatype.BOOLEAN, 28, true, null, null),
        MEMBER_KEY(Datatype.VARIANT, 29, true, null, "Optional. The value of the member key. Null for composite keys."),
        IS_PLACEHOLDERMEMBER(Datatype.BOOLEAN, 30, false, null, "Required. Whether the member is a placeholder member for an empty position in a dimension hierarchy."),
        IS_DATAMEMBER(Datatype.BOOLEAN, 31, false, null, "Required. whether the member is a data member"),
        DEPTH(Datatype.UNSIGNED_INTEGER, 43, true, null, "The level depth of a member"),
        DISPLAY_INFO(Datatype.UNSIGNED_INTEGER, 44, false, null, "Display instruction of a member for XML/A"),
        VALUE(Datatype.VARIANT, 41, false, null, "The unformatted value of the cell.");

        private final Datatype type;
        private final String description;
        private final boolean internal;

        private StandardMemberProperty(Datatype type, int ordinal, boolean internal, Class<? extends Enum> enumClazz, String description) {
            this.internal = internal;
            this.type = type;
            this.description = description;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String getUniqueName() {
            return this.name();
        }

        @Override
        public String getDescription(Locale locale) {
            return this.description;
        }

        @Override
        public String getCaption(Locale locale) {
            return this.name();
        }

        @Override
        public Datatype getDatatype() {
            return this.type;
        }

        @Override
        public Set<TypeFlag> getType() {
            return TypeFlag.MEMBER_TYPE_FLAG;
        }

        @Override
        public ContentType getContentType() {
            return ContentType.REGULAR;
        }

        public boolean isInternal() {
            return this.internal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeFlag implements XmlaConstant
    {
        MEMBER(1),
        CELL(2),
        SYSTEM(4),
        BLOB(8);

        private final int xmlaOrdinal;
        public static final Set<TypeFlag> CELL_TYPE_FLAG;
        public static final Set<TypeFlag> MEMBER_TYPE_FLAG;
        private static final DictionaryImpl<TypeFlag> DICTIONARY;

        private TypeFlag(int xmlaOrdinal) {
            this.xmlaOrdinal = xmlaOrdinal;
        }

        @Override
        public String xmlaName() {
            return "MDPROP_" + this.name();
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public int xmlaOrdinal() {
            return this.xmlaOrdinal;
        }

        public static XmlaConstant.Dictionary<TypeFlag> getDictionary() {
            return DICTIONARY;
        }

        static {
            CELL_TYPE_FLAG = Collections.unmodifiableSet(Olap4jUtil.enumSetOf((Enum)CELL, (Enum[])new TypeFlag[0]));
            MEMBER_TYPE_FLAG = Collections.unmodifiableSet(Olap4jUtil.enumSetOf((Enum)MEMBER, (Enum[])new TypeFlag[0]));
            DICTIONARY = DictionaryImpl.forClass(TypeFlag.class);
        }
    }
}

