/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.valuemapper;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.valuemapper.Messages;
import org.pentaho.di.trans.steps.valuemapper.ValueMapper;
import org.pentaho.di.trans.steps.valuemapper.ValueMapperData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Step(name={"ValueMapper"}, image="ui/images/VMP.png", tooltip="BaseStep.TypeTooltipDesc.MapValues", description="BaseStep.TypeLongDesc.ValueMapper", category=2)
public class ValueMapperMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String fieldToUse;
    private String targetField;
    private String nonMatchDefault;
    private String[] sourceValue;
    private String[] targetValue;

    public String[] getSourceValue() {
        return this.sourceValue;
    }

    public void setSourceValue(String[] fieldName) {
        this.sourceValue = fieldName;
    }

    public String[] getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(String[] fieldValue) {
        this.targetValue = fieldValue;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int count) {
        this.sourceValue = new String[count];
        this.targetValue = new String[count];
    }

    @Override
    public Object clone() {
        ValueMapperMeta retval = (ValueMapperMeta)super.clone();
        int count = this.sourceValue.length;
        retval.allocate(count);
        for (int i = 0; i < count; ++i) {
            retval.sourceValue[i] = this.sourceValue[i];
            retval.targetValue[i] = this.targetValue[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.fieldToUse = XMLHandler.getTagValue((Node)stepnode, (String)"field_to_use");
            this.targetField = XMLHandler.getTagValue((Node)stepnode, (String)"target_field");
            this.nonMatchDefault = XMLHandler.getTagValue((Node)stepnode, (String)"non_match_default");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int count = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.sourceValue[i] = XMLHandler.getTagValue((Node)fnode, (String)"source_value");
                this.targetValue[i] = XMLHandler.getTagValue((Node)fnode, (String)"target_value");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("ValueMapperMeta.RuntimeError.UnableToReadXML.VALUEMAPPER0004"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.sourceValue[i] = "field" + i;
            this.targetValue[i] = "";
        }
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) {
        ValueMeta extra = null;
        if (!Const.isEmpty((String)this.getTargetField())) {
            extra = new ValueMeta(this.getTargetField(), 2);
            int maxlen = -1;
            for (int i = 0; i < this.targetValue.length; ++i) {
                if (this.targetValue[i] == null || this.targetValue[i].length() <= maxlen) continue;
                maxlen = this.targetValue[i].length();
            }
            if (this.nonMatchDefault != null && this.nonMatchDefault.length() > maxlen) {
                maxlen = this.nonMatchDefault.length();
            }
            extra.setLength(maxlen);
            extra.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)extra);
        } else if (!Const.isEmpty((String)this.getFieldToUse())) {
            extra = r.searchValueMeta(this.getFieldToUse());
        }
        if (extra != null) {
            extra.setStorageType(0);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    ").append(XMLHandler.addTagValue((String)"field_to_use", (String)this.fieldToUse));
        retval.append("    ").append(XMLHandler.addTagValue((String)"target_field", (String)this.targetField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"non_match_default", (String)this.nonMatchDefault));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.sourceValue.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"source_value", (String)this.sourceValue[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"target_value", (String)this.targetValue[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.fieldToUse = rep.getStepAttributeString(id_step, "field_to_use");
            this.targetField = rep.getStepAttributeString(id_step, "target_field");
            this.nonMatchDefault = rep.getStepAttributeString(id_step, "non_match_default");
            int nrfields = rep.countNrStepAttributes(id_step, "source_value");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.sourceValue[i] = rep.getStepAttributeString(id_step, i, "source_value");
                this.targetValue[i] = rep.getStepAttributeString(id_step, i, "target_value");
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("ValueMapperMeta.RuntimeError.UnableToReadRepository.VALUEMAPPER0005"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "field_to_use", this.fieldToUse);
            rep.saveStepAttribute(id_transformation, id_step, "target_field", this.targetField);
            rep.saveStepAttribute(id_transformation, id_step, "non_match_default", this.nonMatchDefault);
            for (int i = 0; i < this.sourceValue.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "source_value", this.sourceValue[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "target_value", this.targetValue[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("ValueMapperMeta.RuntimeError.UnableToSaveRepository.VALUEMAPPER0006", "" + id_step), (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transmeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, Messages.getString("ValueMapperMeta.CheckResult.NotReceivingFieldsFromPreviousSteps"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("ValueMapperMeta.CheckResult.ReceivingFieldsFromPreviousSteps", "" + prev.size()), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("ValueMapperMeta.CheckResult.ReceivingInfoFromOtherSteps"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("ValueMapperMeta.CheckResult.NotReceivingInfoFromOtherSteps"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ValueMapper(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ValueMapperData();
    }

    public String getFieldToUse() {
        return this.fieldToUse;
    }

    public void setFieldToUse(String fieldToUse) {
        this.fieldToUse = fieldToUse;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public void setTargetField(String targetField) {
        this.targetField = targetField;
    }

    public String getNonMatchDefault() {
        return this.nonMatchDefault;
    }

    public void setNonMatchDefault(String nonMatchDefault) {
        this.nonMatchDefault = nonMatchDefault;
    }
}

