/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.lib.DelegatingErrorListener;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.query.QueryLibrary;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.QueryReader;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryParser;
import net.sf.saxon.trace.TraceCodeInjector;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticQueryContext {
    private Configuration config;
    private NamePool namePool;
    private String baseURI;
    private HashMap<String, String> userDeclaredNamespaces;
    private Set<GlobalVariable> userDeclaredVariables;
    private boolean inheritNamespaces = true;
    private boolean preserveNamespaces = true;
    private int constructionMode = 3;
    private NamespaceResolver externalNamespaceResolver = null;
    private String defaultFunctionNamespace;
    private String defaultElementNamespace = "";
    private ItemType requiredContextItemType = AnyItemType.getInstance();
    private boolean preserveSpace = false;
    private boolean defaultEmptyLeast = true;
    private ModuleURIResolver moduleURIResolver;
    private UnfailingErrorListener errorListener;
    private CodeInjector codeInjector;
    private boolean isUpdating = false;
    private int languageVersion = 30;
    private String defaultCollationName;
    private Location moduleLocation;

    protected StaticQueryContext() {
    }

    public StaticQueryContext(Configuration config) {
        this.config = config;
        this.namePool = config.getNamePool();
        this.errorListener = config.getErrorListener();
        if (this.errorListener instanceof StandardErrorListener) {
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(51);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(2);
        }
        this.defaultCollationName = config.getDefaultCollationName();
        this.reset();
    }

    public StaticQueryContext(StaticQueryContext c) {
        this.copyFrom(c);
    }

    public void copyFrom(StaticQueryContext c) {
        this.config = c.config;
        this.namePool = c.namePool;
        this.baseURI = c.baseURI;
        this.moduleURIResolver = c.moduleURIResolver;
        if (c.userDeclaredNamespaces != null) {
            this.userDeclaredNamespaces = new HashMap<String, String>(c.userDeclaredNamespaces);
        }
        if (c.userDeclaredVariables != null) {
            this.userDeclaredVariables = new HashSet<GlobalVariable>(c.userDeclaredVariables);
        }
        this.inheritNamespaces = c.inheritNamespaces;
        this.preserveNamespaces = c.preserveNamespaces;
        this.constructionMode = c.constructionMode;
        this.externalNamespaceResolver = c.externalNamespaceResolver;
        this.defaultElementNamespace = c.defaultElementNamespace;
        this.defaultFunctionNamespace = c.defaultFunctionNamespace;
        this.requiredContextItemType = c.requiredContextItemType;
        this.preserveSpace = c.preserveSpace;
        this.defaultEmptyLeast = c.defaultEmptyLeast;
        this.moduleURIResolver = c.moduleURIResolver;
        this.errorListener = c.errorListener;
        this.codeInjector = c.codeInjector;
        this.isUpdating = c.isUpdating;
    }

    public void reset() {
        this.userDeclaredNamespaces = new HashMap(10);
        this.externalNamespaceResolver = null;
        this.errorListener = this.config.getErrorListener();
        if (this.errorListener instanceof StandardErrorListener) {
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(51);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(2);
        }
        this.constructionMode = this.getConfiguration().isLicensedFeature(4) ? 3 : 4;
        this.preserveSpace = false;
        this.defaultEmptyLeast = true;
        this.requiredContextItemType = AnyItemType.getInstance();
        this.defaultFunctionNamespace = "http://www.w3.org/2005/xpath-functions";
        this.defaultElementNamespace = "";
        this.moduleURIResolver = null;
        this.clearNamespaces();
        this.isUpdating = false;
    }

    public void setConfiguration(Configuration config) {
        if (this.config != null && this.config != config) {
            throw new IllegalArgumentException("Configuration cannot be changed dynamically");
        }
        this.config = config;
        this.namePool = config.getNamePool();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public Executable makeExecutable() {
        Executable executable = new Executable(this.config);
        executable.setSchemaAware(this.isSchemaAware());
        executable.setHostLanguage(51);
        return executable;
    }

    public void setSchemaAware(boolean aware) {
        if (aware) {
            throw new UnsupportedOperationException("Schema-awareness requires Saxon-EE");
        }
    }

    public boolean isSchemaAware() {
        return false;
    }

    public void setStreaming(boolean option) {
        if (option) {
            throw new UnsupportedOperationException("Streaming requires Saxon-EE");
        }
    }

    public boolean isStreaming() {
        return false;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public TreeInfo buildDocument(Source source) throws XPathException {
        return this.config.buildDocumentTree(source);
    }

    public void setLanguageVersion(int version) {
        if (version != 10 && version != 30 && version != 31) {
            throw new IllegalArgumentException("languageVersion = " + version);
        }
    }

    public int getLanguageVersion() {
        return 31;
    }

    public FunctionLibrary getExtensionFunctionLibrary() {
        return null;
    }

    public boolean isCompileWithTracing() {
        return this.codeInjector instanceof TraceCodeInjector;
    }

    public void setCompileWithTracing(boolean trace) {
        this.codeInjector = trace ? new TraceCodeInjector() : null;
    }

    public void setCodeInjector(CodeInjector injector) {
        this.codeInjector = injector;
    }

    public CodeInjector getCodeInjector() {
        return this.codeInjector;
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    public void setInheritNamespaces(boolean inherit) {
        this.inheritNamespaces = inherit;
    }

    public boolean isInheritNamespaces() {
        return this.inheritNamespaces;
    }

    public void setPreserveNamespaces(boolean inherit) {
        this.preserveNamespaces = inherit;
    }

    public boolean isPreserveNamespaces() {
        return this.preserveNamespaces;
    }

    public void setConstructionMode(int mode) {
        this.constructionMode = mode;
    }

    public int getConstructionMode() {
        return this.constructionMode;
    }

    public void setModuleLocation(Location location) {
        this.moduleLocation = location;
    }

    public Location getModuleLocation() {
        return this.moduleLocation;
    }

    public XQueryExpression compileQuery(String query) throws XPathException {
        XQueryParser qp = (XQueryParser)this.config.newExpressionParser("XQ", this.isUpdating, 31);
        if (this.codeInjector != null) {
            qp.setCodeInjector(this.codeInjector);
        } else if (this.config.isCompileWithTracing()) {
            qp.setCodeInjector(new TraceCodeInjector());
        }
        qp.setStreaming(this.isStreaming());
        QueryModule mainModule = new QueryModule(this);
        qp.setDisableCycleChecks(true);
        return qp.makeXQueryExpression(query, mainModule, this.config);
    }

    public XQueryExpression compileQuery(Reader source) throws XPathException, IOException {
        int n;
        char[] buffer = new char[4096];
        StringBuilder sb = new StringBuilder(4096);
        while ((n = source.read(buffer)) > 0) {
            sb.append(buffer, 0, n);
        }
        return this.compileQuery(sb.toString());
    }

    public XQueryExpression compileQuery(InputStream source, String encoding) throws XPathException, IOException {
        String query = QueryReader.readInputStream(source, encoding, this.config.getValidCharacterChecker());
        return this.compileQuery(query);
    }

    public void compileLibrary(String query) throws XPathException {
        throw new XPathException("Separate compilation of query libraries requires Saxon-EE");
    }

    public void compileLibrary(Reader source) throws XPathException, IOException {
        throw new XPathException("Separate compilation of query libraries requires Saxon-EE");
    }

    public void compileLibrary(InputStream source, String encoding) throws XPathException, IOException {
        throw new UnsupportedOperationException("Separate compilation of query libraries requires Saxon-EE");
    }

    public QueryLibrary getCompiledLibrary(String namespace) {
        return null;
    }

    public Collection<QueryLibrary> getCompiledLibraries() {
        return Collections.emptySet();
    }

    public void declareNamespace(String prefix, String uri) {
        if (prefix == null) {
            throw new NullPointerException("Null prefix supplied to declareNamespace()");
        }
        if (uri == null) {
            throw new NullPointerException("Null namespace URI supplied to declareNamespace()");
        }
        if (prefix.equals("xml") != uri.equals("http://www.w3.org/XML/1998/namespace")) {
            throw new IllegalArgumentException("Misdeclaration of XML namespace");
        }
        if (prefix.equals("xmlns") || uri.equals("http://www.w3.org/2000/xmlns/")) {
            throw new IllegalArgumentException("Misdeclaration of xmlns namespace");
        }
        if (prefix.isEmpty()) {
            this.defaultElementNamespace = uri;
        }
        if (uri.isEmpty()) {
            this.userDeclaredNamespaces.remove(prefix);
        } else {
            this.userDeclaredNamespaces.put(prefix, uri);
        }
    }

    public void clearNamespaces() {
        this.userDeclaredNamespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        this.declareNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.declareNamespace("fn", "http://www.w3.org/2005/xpath-functions");
        this.declareNamespace("local", "http://www.w3.org/2005/xquery-local-functions");
        this.declareNamespace("err", "http://www.w3.org/2005/xqt-errors");
        this.declareNamespace("saxon", "http://saxon.sf.net/");
        this.declareNamespace("", "");
    }

    protected HashMap<String, String> getUserDeclaredNamespaces() {
        return this.userDeclaredNamespaces;
    }

    public Iterator<String> iterateDeclaredPrefixes() {
        return this.userDeclaredNamespaces.keySet().iterator();
    }

    public String getNamespaceForPrefix(String prefix) {
        return this.userDeclaredNamespaces.get(prefix);
    }

    public void setExternalNamespaceResolver(NamespaceResolver resolver) {
        this.externalNamespaceResolver = resolver;
    }

    public NamespaceResolver getExternalNamespaceResolver() {
        return this.externalNamespaceResolver;
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setDefaultFunctionNamespace(String defaultFunctionNamespace) {
        this.defaultFunctionNamespace = defaultFunctionNamespace;
    }

    public void setDefaultElementNamespace(String uri) {
        this.defaultElementNamespace = uri;
        this.declareNamespace("", uri);
    }

    public String getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public void declareGlobalVariable(StructuredQName qName, SequenceType type, Sequence value, boolean external) throws XPathException {
        if (value == null && !external) {
            throw new NullPointerException("No initial value for declared variable");
        }
        if (value != null && !type.matches(value, this.getConfiguration().getTypeHierarchy())) {
            throw new XPathException("Value of declared variable does not match its type");
        }
        GlobalVariable var = external ? new GlobalParam() : new GlobalVariable();
        var.setVariableQName(qName);
        var.setRequiredType(type);
        if (value != null) {
            var.setSelectExpression(Literal.makeLiteral(SequenceTool.toGroundedValue(value)));
        }
        if (this.userDeclaredVariables == null) {
            this.userDeclaredVariables = new HashSet<GlobalVariable>();
        }
        this.userDeclaredVariables.add(var);
    }

    public Iterator<GlobalVariable> iterateDeclaredGlobalVariables() {
        if (this.userDeclaredVariables == null) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        return this.userDeclaredVariables.iterator();
    }

    public void clearDeclaredGlobalVariables() {
        this.userDeclaredVariables = null;
    }

    public void setModuleURIResolver(ModuleURIResolver resolver) {
        this.moduleURIResolver = resolver;
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.moduleURIResolver;
    }

    public void declareCollation(String name, Comparator comparator) {
        this.getConfiguration().registerCollation(name, new SimpleCollation(name, comparator));
    }

    public void declareCollation(String name, StringCollator collation) {
        this.getConfiguration().registerCollation(name, collation);
    }

    public void declareDefaultCollation(String name) {
        StringCollator c;
        if (name == null) {
            throw new NullPointerException();
        }
        try {
            c = this.getConfiguration().getCollation(name);
        }
        catch (XPathException e) {
            c = null;
        }
        if (c == null) {
            throw new IllegalStateException("Unknown collation " + name);
        }
        this.defaultCollationName = name;
    }

    public StringCollator getCollation(String name) {
        try {
            return this.getConfiguration().getCollation(name);
        }
        catch (XPathException e) {
            this.getErrorListener().warning(e);
            return null;
        }
    }

    public String getDefaultCollationName() {
        return this.defaultCollationName;
    }

    public void setRequiredContextItemType(ItemType type) {
        this.requiredContextItemType = type;
    }

    public ItemType getRequiredContextItemType() {
        return this.requiredContextItemType;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public String getSystemId() {
        return this.baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setPreserveBoundarySpace(boolean preserve) {
        this.preserveSpace = preserve;
    }

    public boolean isPreserveBoundarySpace() {
        return this.preserveSpace;
    }

    public void setEmptyLeast(boolean least) {
        this.defaultEmptyLeast = least;
    }

    public boolean isEmptyLeast() {
        return this.defaultEmptyLeast;
    }

    public void setErrorListener(ErrorListener listener) {
        if (listener instanceof StandardErrorListener) {
            this.errorListener = ((StandardErrorListener)listener).makeAnother(51);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(2);
        } else {
            this.errorListener = listener instanceof UnfailingErrorListener ? (UnfailingErrorListener)listener : new DelegatingErrorListener(listener);
        }
    }

    public UnfailingErrorListener getErrorListener() {
        if (this.errorListener == null) {
            this.errorListener = this.config.getErrorListener();
        }
        return this.errorListener;
    }

    public void setUpdatingEnabled(boolean updating) {
        this.isUpdating = updating;
    }

    public boolean isUpdatingEnabled() {
        return this.isUpdating;
    }
}

