/*
 * Decompiled with CFR 0.152.
 */
package circlet.completion.mentions;

import circlet.client.api.TD_MemberProfile;
import circlet.client.api.TeamDirectoryKt;
import circlet.common.mentions.MentionData;
import circlet.completion.mentions.MentionProvider;
import circlet.completion.mentions.MentionProvidersKt;
import circlet.completion.mentions.ProfileMentionTrieNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u00062\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0012*\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcirclet/completion/mentions/ProfileMentionTrie;", "", "()V", "root", "Lcirclet/completion/mentions/ProfileMentionTrieNode;", "findAll", "", "Lkotlin/Pair;", "", "Lkotlin/ranges/IntRange;", "text", "put", "", "profile", "Lcirclet/client/api/TD_MemberProfile;", "putName", "name", "mention", "Lcirclet/common/mentions/MentionData;", "remove", "removeName", "", "resolve", "clientView", "data", "Companion", "app-state"})
public final class ProfileMentionTrie {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProfileMentionTrieNode root = new ProfileMentionTrieNode(null);
    @NotNull
    private static final KLogger log = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(ProfileMentionTrie.class));

    public final void put(@NotNull TD_MemberProfile profile2) {
        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
        MentionData mention = this.data(profile2);
        if (mention != null) {
            this.putName(profile2.getUsername(), mention);
            this.putName(TeamDirectoryKt.englishFullName(profile2), mention);
        }
    }

    public final void remove(@NotNull TD_MemberProfile profile2) {
        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
        MentionData mention = this.data(profile2);
        if (mention != null) {
            this.removeName(profile2.getUsername(), mention);
            this.removeName(TeamDirectoryKt.englishFullName(profile2), mention);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void putName(String name2, MentionData mention) {
        void $this$forEach$iv;
        ProfileMentionTrieNode node = null;
        node = this.root;
        CharSequence charSequence = name2;
        boolean bl = false;
        String string2 = charSequence;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        charSequence = string3;
        boolean $i$f$forEach = false;
        void var6_6 = $this$forEach$iv;
        for (int i = 0; i < var6_6.length(); ++i) {
            ProfileMentionTrieNode profileMentionTrieNode;
            char element$iv;
            char ch = element$iv = var6_6.charAt(i);
            boolean bl2 = false;
            ProfileMentionTrieNode profileMentionTrieNode2 = node.getChildren().get(Character.valueOf(ch));
            if (profileMentionTrieNode2 == null) {
                ProfileMentionTrieNode profileMentionTrieNode3 = new ProfileMentionTrieNode(node);
                boolean bl3 = false;
                boolean bl4 = false;
                ProfileMentionTrieNode it = profileMentionTrieNode3;
                boolean bl5 = false;
                Map<Character, ProfileMentionTrieNode> map2 = node.getChildren();
                Character c = Character.valueOf(ch);
                boolean bl6 = false;
                map2.put(c, it);
                Unit unit = Unit.INSTANCE;
                profileMentionTrieNode = profileMentionTrieNode3;
            } else {
                profileMentionTrieNode = profileMentionTrieNode2;
            }
            node = profileMentionTrieNode;
        }
        node.getMentions().add(mention);
    }

    private final boolean removeName(String name2, MentionData mention) {
        String string2 = name2;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        String key2 = string4;
        ProfileMentionTrieNode node = null;
        node = this.root;
        CharSequence $this$forEach$iv = key2;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv;
        for (int i = 0; i < object.length(); ++i) {
            char element$iv;
            char ch = element$iv = object.charAt(i);
            boolean bl2 = false;
            ProfileMentionTrieNode profileMentionTrieNode = node.getChildren().get(Character.valueOf(ch));
            if (profileMentionTrieNode == null) {
                return false;
            }
            node = profileMentionTrieNode;
        }
        node.getMentions().remove(mention);
        int index = StringsKt.getLastIndex((CharSequence)name2);
        while (index >= 0 && node.getChildren().isEmpty() && node.getMentions().isEmpty()) {
            ProfileMentionTrieNode profileMentionTrieNode = node.getParent();
            if (profileMentionTrieNode != null) {
                object = profileMentionTrieNode.getChildren();
                ProfileMentionTrieNode cfr_ignored_0 = (ProfileMentionTrieNode)object.remove(Character.valueOf(key2.charAt(index)));
            }
            profileMentionTrieNode = node.getParent();
            if (profileMentionTrieNode == null) {
                return true;
            }
            node = profileMentionTrieNode;
            int n = index;
            index = n + -1;
        }
        return true;
    }

    private final MentionData data(TD_MemberProfile $this$data) {
        return ((MentionProvider)MapsKt.getValue(MentionProvidersKt.getMention_providers(), (Object)"p")).data($this$data.getId(), $this$data.getUsername(), TeamDirectoryKt.englishFullName($this$data));
    }

    @NotNull
    public final List<Pair<String, IntRange>> findAll(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        boolean bl = false;
        List mentions2 = new ArrayList();
        boolean bl2 = false;
        List duplicatedMentions = new ArrayList();
        int n = text2.length();
        int n2 = 8192;
        boolean bl3 = false;
        int maxTextLength = Math.min(n, n2);
        Ref.IntRef index = new Ref.IntRef();
        while (index.element < maxTextLength) {
            if (text2.charAt(index.element) != '@' || ProfileMentionTrie.findAll$isEscaped(index, text2)) {
                n2 = index.element;
                index.element = n2 + 1;
                continue;
            }
            Pair<String, IntRange> pair = ProfileMentionTrie.findAll$searchMentionByMaxPrefix(index, maxTextLength, text2, this, duplicatedMentions, index.element);
            if (pair == null) continue;
            Pair<String, IntRange> pair2 = pair;
            boolean bl4 = false;
            boolean bl5 = false;
            Pair<String, IntRange> it = pair2;
            boolean bl6 = false;
            Collection collection = mentions2;
            boolean bl7 = false;
            collection.add(it);
        }
        Collection collection = duplicatedMentions;
        bl3 = false;
        if (!collection.isEmpty()) {
            KLogger this_$iv = log;
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl8 = false;
                String string2 = "For " + text2 + " found duplicates " + CollectionsKt.joinToString$default((Iterable)duplicatedMentions, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                kLogger.warn(string2);
            }
        }
        return mentions2;
    }

    @Nullable
    public final MentionData resolve(@NotNull String clientView2) {
        Intrinsics.checkNotNullParameter((Object)clientView2, (String)"clientView");
        ProfileMentionTrieNode node = null;
        node = this.root;
        String string2 = clientView2;
        boolean bl = false;
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        CharSequence $this$forEach$iv = string3;
        boolean $i$f$forEach = false;
        CharSequence charSequence = $this$forEach$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv;
            char ch = element$iv = charSequence.charAt(i);
            boolean bl2 = false;
            ProfileMentionTrieNode profileMentionTrieNode = node.getChildren().get(Character.valueOf(ch));
            if (profileMentionTrieNode == null) {
                return null;
            }
            node = profileMentionTrieNode;
        }
        return (MentionData)CollectionsKt.singleOrNull(node.getMentions());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean findAll$isEscaped(Ref.IntRef index, String $text) {
        if (index.element - 1 < 0) return false;
        Character c = Character.valueOf($text.charAt(index.element - 1));
        Character prev = c;
        if (prev == null) return false;
        char c2 = '\\';
        if (prev.charValue() != c2) return false;
        return true;
    }

    private static final Pair<String, IntRange> findAll$searchMentionByMaxPrefix(Ref.IntRef index, int maxTextLength, String $text, ProfileMentionTrie this$0, List<String> duplicatedMentions, int startPosition) {
        Pair pair;
        Integer n;
        boolean bl;
        if (index.element >= maxTextLength) {
            return null;
        }
        int n2 = $text.charAt(startPosition) == '@' ? 1 : 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (n2 == 0) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        n2 = index.element;
        index.element = n2 + 1;
        Integer endPosition = null;
        char[] clientView2 = null;
        char[] cArray = new char[]{'@'};
        clientView2 = cArray;
        boolean duplicated = false;
        ProfileMentionTrieNode node = this$0.root;
        while (index.element < maxTextLength && $text.charAt(index.element) != '@') {
            char c = $text.charAt(index.element);
            bl = false;
            Object object = node.getChildren().get(Character.valueOf(Character.toLowerCase(c)));
            if (object == null) break;
            node = object;
            object = node.getMentions();
            c = '\u0000';
            if (!object.isEmpty()) {
                duplicated = node.getMentions().size() > 1;
                endPosition = index.element;
            }
            clientView2 = ArraysKt.plus((char[])clientView2, (char)$text.charAt(index.element));
            int n3 = index.element;
            index.element = n3 + 1;
        }
        if ((n = endPosition) == null) {
            pair = null;
        } else {
            Integer n4 = n;
            bl = false;
            boolean bl6 = false;
            int it = ((Number)n4).intValue();
            boolean bl7 = false;
            String clientViewStr = StringsKt.concatToString((char[])clientView2, (int)0, (int)(((Number)endPosition).intValue() - startPosition + 1));
            if (duplicated) {
                Collection collection = duplicatedMentions;
                boolean bl8 = false;
                collection.add(clientViewStr);
                pair = null;
            } else {
                pair = TuplesKt.to((Object)clientViewStr, (Object)new IntRange(startPosition, ((Number)endPosition).intValue()));
            }
        }
        return pair;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcirclet/completion/mentions/ProfileMentionTrie$Companion;", "", "()V", "log", "Llibraries/klogging/KLogger;", "getLog", "()Llibraries/klogging/KLogger;", "app-state"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

