/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public final class GrInspectionUtil {
    public static boolean isNull(@NotNull GrExpression expression) {
        if (expression == null) {
            GrInspectionUtil.$$$reportNull$$$0(0);
        }
        return "null".equals(expression.getText());
    }

    public static boolean isEquality(@NotNull GrBinaryExpression binaryCondition) {
        IElementType tokenType;
        if (binaryCondition == null) {
            GrInspectionUtil.$$$reportNull$$$0(1);
        }
        return GroovyTokenTypes.mEQUAL == (tokenType = binaryCondition.getOperationTokenType());
    }

    public static boolean isInequality(@NotNull GrBinaryExpression binaryCondition) {
        IElementType tokenType;
        if (binaryCondition == null) {
            GrInspectionUtil.$$$reportNull$$$0(2);
        }
        return GroovyTokenTypes.mNOT_EQUAL == (tokenType = binaryCondition.getOperationTokenType());
    }

    public static HighlightInfo createAnnotationForRef(@NotNull GrReferenceElement ref, @NotNull HighlightDisplayLevel displayLevel, @NotNull @NlsContexts.DetailedDescription String message) {
        if (ref == null) {
            GrInspectionUtil.$$$reportNull$$$0(3);
        }
        if (displayLevel == null) {
            GrInspectionUtil.$$$reportNull$$$0(4);
        }
        if (message == null) {
            GrInspectionUtil.$$$reportNull$$$0(5);
        }
        PsiElement refNameElement = ref.getReferenceNameElement();
        assert (refNameElement != null);
        if (displayLevel == HighlightDisplayLevel.ERROR) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range(refNameElement).descriptionAndTooltip(message).create();
        }
        if (displayLevel == HighlightDisplayLevel.WEAK_WARNING) {
            boolean isTestMode = ApplicationManager.getApplication().isUnitTestMode();
            HighlightInfoType infotype = isTestMode ? HighlightInfoType.WARNING : HighlightInfoType.INFORMATION;
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)infotype).range(refNameElement);
            builder.descriptionAndTooltip(message);
            return builder.needsUpdateOnTyping(false).textAttributes(GroovySyntaxHighlighter.UNRESOLVED_ACCESS).create();
        }
        HighlightInfoType highlightInfoType = HighlightInfo.convertSeverity((HighlightSeverity)displayLevel.getSeverity());
        return HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(refNameElement).descriptionAndTooltip(message).create();
    }

    public static void replaceExpression(GrExpression expression, @NlsSafe String newExpression) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(expression.getProject());
        GrExpression newCall = factory.createExpressionFromText(newExpression, expression.getContext());
        expression.replaceWithExpression(newCall, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryCondition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayLevel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/GrInspectionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isNull";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEquality";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isInequality";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createAnnotationForRef";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

