/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GrDeprecatedAPIUsageInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression ref) {
                if (ref == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(ref);
                this.checkRef(ref.resolve(), ref.getReferenceNameElement(), ref.getReferenceName());
            }

            @Override
            public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement ref) {
                if (ref == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitCodeReferenceElement(ref);
                this.checkRef(ref.resolve(), ref.getReferenceNameElement(), ref.getReferenceName());
            }

            @Override
            public void visitNewExpression(@NotNull GrNewExpression ref) {
                if (ref == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitNewExpression(ref);
                PsiMethod resolvedCall = ref.resolveMethod();
                if (resolvedCall == null || this.isDeprecated((PsiElement)resolvedCall.getContainingClass())) {
                    return;
                }
                GrCodeReferenceElement referenceElement = ref.getReferenceElement();
                if (referenceElement != null) {
                    this.checkRef((PsiElement)resolvedCall, ref.getReferenceElement(), referenceElement.getReferenceName());
                } else {
                    this.checkRef((PsiElement)resolvedCall, ref, resolvedCall.getName());
                }
            }

            private void checkRef(PsiElement resolved, PsiElement elementToHighlight, String elementName) {
                if (this.isDeprecated(resolved)) {
                    this.registerError(elementToHighlight, GroovyBundle.message("0.is.deprecated", elementName), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.LIKE_DEPRECATED);
                }
            }

            private boolean isDeprecated(PsiElement resolved) {
                if (resolved instanceof PsiDocCommentOwner) {
                    return ((PsiDocCommentOwner)resolved).isDeprecated();
                }
                return resolved instanceof PsiModifierListOwner && PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)((PsiModifierListOwner)resolved));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "ref";
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GrDeprecatedAPIUsageInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCodeReferenceElement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNewExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }
}

