/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.annotator.GroovyFrameworkConfigNotification;

public final class ConfigureGroovyLibraryNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"configure.groovy.library");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            ConfigureGroovyLibraryNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file == null) {
            ConfigureGroovyLibraryNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            ConfigureGroovyLibraryNotificationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ConfigureGroovyLibraryNotificationProvider.$$$reportNull$$$0(3);
        }
        try {
            if (!file.getFileType().equals((Object)GroovyFileType.GROOVY_FILE_TYPE)) {
                return null;
            }
            if (StringUtil.endsWith((CharSequence)file.getName(), (CharSequence)".gradle")) {
                return null;
            }
            if (CompilerManager.getInstance((Project)project).isExcludedFromCompilation(file)) {
                return null;
            }
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
            if (module == null) {
                return null;
            }
            if (ConfigureGroovyLibraryNotificationProvider.isMavenModule(module)) {
                return null;
            }
            for (GroovyFrameworkConfigNotification configNotification : (GroovyFrameworkConfigNotification[])GroovyFrameworkConfigNotification.EP_NAME.getExtensions()) {
                if (!configNotification.hasFrameworkStructure(module)) continue;
                if (!configNotification.hasFrameworkLibrary(module)) {
                    return (EditorNotificationPanel)configNotification.createConfigureNotificationPanel(module, fileEditor);
                }
                return null;
            }
        }
        catch (ProcessCanceledException | IndexNotReadyException throwable) {
            // empty catch block
        }
        return null;
    }

    private static boolean isMavenModule(@NotNull Module module) {
        if (module == null) {
            ConfigureGroovyLibraryNotificationProvider.$$$reportNull$$$0(4);
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (root.findChild("pom.xml") == null) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/config/ConfigureGroovyLibraryNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/config/ConfigureGroovyLibraryNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMavenModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

