/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger;

import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\f\u0010\u0013\u001a\u00020\u0005*\u00020\u000fH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/groovy/debugger/GroovyStackFrame;", "Lcom/intellij/debugger/engine/JavaStackFrame;", "descriptor", "Lcom/intellij/debugger/ui/impl/watch/StackFrameDescriptorImpl;", "update", "", "(Lcom/intellij/debugger/ui/impl/watch/StackFrameDescriptorImpl;Z)V", "addClosureFields", "", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "children", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "collectClosureFields", "", "Lcom/sun/jdi/Field;", "objectReference", "Lcom/sun/jdi/ObjectReference;", "superBuildVariables", "isInternal", "intellij.groovy"})
public final class GroovyStackFrame
extends JavaStackFrame {
    protected void superBuildVariables(@NotNull EvaluationContextImpl evaluationContext, @NotNull XValueChildrenList children) {
        Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
        Intrinsics.checkNotNullParameter((Object)children, (String)"children");
        this.addClosureFields(evaluationContext, children);
        super.superBuildVariables(evaluationContext, children);
    }

    /*
     * WARNING - void declaration
     */
    private final void addClosureFields(EvaluationContextImpl evaluationContext, XValueChildrenList children) {
        void $this$mapTo$iv$iv;
        DebugProcessImpl debugProcessImpl = evaluationContext.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"evaluationContext.debugProcess");
        JavaDebugProcess javaDebugProcess = debugProcessImpl.getXdebugProcess();
        if (javaDebugProcess == null || (javaDebugProcess = javaDebugProcess.getNodeManager()) == null) {
            return;
        }
        JavaDebugProcess nodeManager = javaDebugProcess;
        Object object = evaluationContext.getFrameProxy();
        if (object == null || (object = object.thisObject()) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"evaluationContext.frameP\u2026y?.thisObject() ?: return");
        Object objectReference = object;
        List<Field> fields = this.collectClosureFields((ObjectReference)objectReference);
        Iterable $this$map$iv = fields;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Field field = (Field)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FieldDescriptorImpl fieldDescriptorImpl = nodeManager.getFieldDescriptor(null, (ObjectReference)objectReference, (Field)it);
            collection.add(fieldDescriptorImpl);
        }
        List xFields = (List)destination$iv$iv;
        for (FieldDescriptorImpl xField : xFields) {
            children.add(ContextUtil.createValue((EvaluationContextImpl)evaluationContext, (NodeManagerImpl)nodeManager, (ValueDescriptorImpl)((ValueDescriptorImpl)xField)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Field> collectClosureFields(ObjectReference objectReference) {
        void $this$filterTo$iv$iv;
        ReferenceType referenceType = objectReference.referenceType();
        if (!(referenceType instanceof ClassType)) {
            referenceType = null;
        }
        ClassType classType = (ClassType)referenceType;
        if (classType == null) {
            return CollectionsKt.emptyList();
        }
        ClassType refType = classType;
        ClassType classType2 = refType.superclass();
        if (Intrinsics.areEqual((Object)(classType2 != null ? classType2.name() : null), (Object)"groovy.lang.Closure") ^ true) {
            return CollectionsKt.emptyList();
        }
        List<Field> list = refType.fields();
        Intrinsics.checkNotNullExpressionValue(list, (String)"refType.fields()");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Field it = (Field)element$iv$iv;
            boolean bl = false;
            Field field = it;
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"it");
            if (!(!this.isInternal(field))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isInternal(Field $this$isInternal) {
        String string = $this$isInternal.name();
        return string != null && StringsKt.contains$default((CharSequence)string, (CharSequence)"$", (boolean)false, (int)2, null);
    }

    public GroovyStackFrame(@NotNull StackFrameDescriptorImpl descriptor, boolean update) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        super(descriptor, update);
    }
}

