/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style.inference.graph;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariablesOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessUtilKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.graph.InferenceUnit;
import org.jetbrains.plugins.groovy.intentions.style.inference.graph.InferenceUnitGraph;
import org.jetbrains.plugins.groovy.intentions.style.inference.graph.InferenceUnitGraphBuilder;
import org.jetbrains.plugins.groovy.intentions.style.inference.graph.InferenceUnitNode;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0000\u001a,\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a,\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0005\u001a;\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0015H\u0082\u0010\u001a\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0002\u001a,\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00022\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\"H\u0002\u00a8\u0006#"}, d2={"collectParents", "", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/graph/InferenceUnitNode;", "unit", "parentMap", "", "condense", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/graph/InferenceUnitGraph;", "graph", "determineDependencies", "getRepresentative", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/graph/InferenceUnit;", "anchor", "target", "representativeMap", "merge", "", "anchorUnit", "mergingUnit", "commonUnits", "", "", "mergeTypes", "Lcom/intellij/psi/PsiType;", "firstType", "secondType", "propagateTypeInstantiations", "unitGraph", "setTreeStructure", "order", "topologicalOrder", "traverseGraph", "node", "visited", "", "intellij.groovy"})
public final class InferenceUnitGraphKt {
    @NotNull
    public static final InferenceUnitGraph determineDependencies(@NotNull InferenceUnitGraph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        InferenceUnitGraph condensedGraph = InferenceUnitGraphKt.condense(graph);
        InferenceUnitGraph sortedGraph = InferenceUnitGraphKt.topologicalOrder(condensedGraph);
        InferenceUnitGraph tree = InferenceUnitGraphKt.setTreeStructure(sortedGraph);
        InferenceUnitGraph assembledTree = InferenceUnitGraphKt.propagateTypeInstantiations(tree);
        return assembledTree;
    }

    /*
     * WARNING - void declaration
     */
    private static final InferenceUnitGraph condense(InferenceUnitGraph graph) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Object representative;
        Iterator $this$mapTo$iv$iv;
        Iterator element$iv3;
        Iterable $this$forEach$iv2;
        List list;
        Collection collection;
        LinkedHashMap nodeMap = new LinkedHashMap();
        boolean bl = false;
        Map representativeMap = new LinkedHashMap();
        boolean bl2 = false;
        Map typeMap = new LinkedHashMap();
        Iterable $this$forEach$iv3 = graph.getUnits();
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv3) {
            InferenceUnitNode it = (InferenceUnitNode)element$iv2;
            boolean bl3 = false;
            ((Map)nodeMap).put(it, new InferenceVariablesOrder.InferenceGraphNode((Object)it));
        }
        for (InferenceUnitNode unit : graph.getUnits()) {
            InferenceUnitNode it;
            Object item$iv$iv;
            Iterator $this$mapTo$iv$iv2;
            Object v = nodeMap.get(unit);
            Intrinsics.checkNotNull(v);
            Intrinsics.checkNotNullExpressionValue(v, (String)"nodeMap[unit]!!");
            InferenceVariablesOrder.InferenceGraphNode node = (InferenceVariablesOrder.InferenceGraphNode)v;
            Iterable $this$map$iv = unit.getSupertypes();
            boolean $i$f$map = false;
            Iterable bl3 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                item$iv$iv = iterator2.next();
                InferenceUnitNode inferenceUnitNode = (InferenceUnitNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                Object v2 = nodeMap.get(it);
                Intrinsics.checkNotNull(v2);
                list = (InferenceVariablesOrder.InferenceGraphNode)v2;
                collection.add(list);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Iterator element$iv3 : $this$forEach$iv2) {
                InferenceVariablesOrder.InferenceGraphNode it2 = (InferenceVariablesOrder.InferenceGraphNode)element$iv3;
                boolean bl5 = false;
                node.addDependency(it2);
            }
            $this$map$iv = unit.getSubtypes();
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            Iterator bl5 = $this$mapTo$iv$iv2.iterator();
            while (bl5.hasNext()) {
                item$iv$iv = bl5.next();
                it = (InferenceUnitNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                Object v3 = nodeMap.get(it);
                Intrinsics.checkNotNull(v3);
                list = (InferenceVariablesOrder.InferenceGraphNode)v3;
                collection.add(list);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$forEach2 = false;
            $this$mapTo$iv$iv2 = $this$forEach$iv2.iterator();
            while ($this$mapTo$iv$iv2.hasNext()) {
                element$iv3 = $this$mapTo$iv$iv2.next();
                InferenceVariablesOrder.InferenceGraphNode it3 = (InferenceVariablesOrder.InferenceGraphNode)element$iv3;
                boolean bl7 = false;
                it3.addDependency(node);
            }
        }
        ArrayList arrayList = InferenceVariablesOrder.initNodes(nodeMap.values());
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"InferenceVariablesOrder.initNodes(nodeMap.values)");
        Iterable $this$map$iv = arrayList;
        boolean $i$f$map = false;
        $this$forEach$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        element$iv3 = $this$mapTo$iv$iv.iterator();
        while (element$iv3.hasNext()) {
            void it;
            Object item$iv$iv = element$iv3.next();
            InferenceVariablesOrder.InferenceGraphNode bl7 = (InferenceVariablesOrder.InferenceGraphNode)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl8 = false;
            void v4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
            Intrinsics.checkNotNull((Object)v4.getValue());
            collection.add(list);
        }
        List components = (List)destination$iv$iv;
        InferenceUnitGraphBuilder builder = new InferenceUnitGraphBuilder();
        for (List component : components) {
            Object v5;
            Iterable $this$minByOrNull$iv = component;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v5 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v5 = minElem$iv;
                } else {
                    InferenceUnitNode p1 = (InferenceUnitNode)minElem$iv;
                    boolean bl9 = false;
                    Comparable minValue$iv = (Comparable)((Object)p1.toString());
                    do {
                        Object e$iv = iterator$iv.next();
                        InferenceUnitNode p12 = (InferenceUnitNode)e$iv;
                        bl16 = false;
                        Comparable v$iv = (Comparable)((Object)p12.toString());
                        if (minValue$iv.compareTo(v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v5 = minElem$iv;
                }
            }
            Intrinsics.checkNotNull(v5);
            representative = v5;
            Iterable $this$forEach$iv4 = component;
            boolean $i$f$forEach3 = false;
            for (Object element$iv4 : $this$forEach$iv4) {
                InferenceUnitNode it = (InferenceUnitNode)element$iv4;
                boolean bl10 = false;
                representativeMap.put(it.getCore(), ((InferenceUnitNode)representative).getCore());
                if (!(Intrinsics.areEqual((Object)it, (Object)representative) ^ true)) continue;
                PsiType psiType = (PsiType)typeMap.get(((InferenceUnitNode)representative).getCore());
                if (psiType == null) {
                    psiType = ((InferenceUnitNode)representative).getTypeInstantiation();
                }
                PsiType representativeType = psiType;
                typeMap.put(((InferenceUnitNode)representative).getCore(), InferenceUnitGraphKt.mergeTypes(representativeType, it.getTypeInstantiation()));
                builder.setType(it.getCore(), (PsiType)((InferenceUnitNode)representative).getCore().getType()).setDirect(it.getCore());
            }
        }
        Iterable $this$filter$iv = graph.getUnits();
        boolean $i$f$filter = false;
        representative = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
            InferenceUnitNode it4 = (InferenceUnitNode)element$iv$iv2;
            boolean $i$a$-filter-InferenceUnitGraphKt$condense$82 = false;
            if (!Intrinsics.areEqual((Object)((InferenceUnit)representativeMap.get(it4.getCore())), (Object)it4.getCore())) continue;
            destination$iv$iv2.add(element$iv$iv2);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach4 = false;
        for (Object element$iv5 : $this$forEach$iv) {
            void $this$forEach$iv5;
            boolean bl11;
            InferenceUnit it$iv$iv;
            InferenceUnit inferenceUnit;
            boolean bl12;
            boolean bl13;
            InferenceUnitNode it;
            boolean bl14;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Object element$iv$iv2;
            InferenceUnitNode unit = (InferenceUnitNode)element$iv5;
            boolean bl15 = false;
            builder.register(unit);
            element$iv$iv2 = typeMap;
            InferenceUnit it4 = unit.getCore();
            boolean $i$a$-filter-InferenceUnitGraphKt$condense$82 = false;
            Object representativeType = element$iv$iv2;
            boolean bl16 = false;
            if (representativeType.containsKey(it4)) {
                InferenceUnit inferenceUnit2 = unit.getCore();
                Object v = typeMap.get(unit.getCore());
                Intrinsics.checkNotNull(v);
                builder.setType(inferenceUnit2, (PsiType)v);
            }
            Iterable $this$mapNotNull$iv = unit.getSupertypes();
            boolean $i$f$mapNotNull = false;
            Iterable $i$a$-filter-InferenceUnitGraphKt$condense$82 = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach5 = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator3.next();
                bl14 = false;
                it = (InferenceUnitNode)element$iv$iv;
                boolean bl17 = false;
                if (InferenceUnitGraphKt.getRepresentative(unit, it, representativeMap) == null) continue;
                bl13 = false;
                bl12 = false;
                it$iv$iv = inferenceUnit;
                bl11 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv3;
            boolean $i$f$forEach6 = false;
            for (Object element$iv6 : $this$forEach$iv5) {
                InferenceUnit it5 = (InferenceUnit)element$iv6;
                boolean bl18 = false;
                builder.addRelation(it5, unit.getCore());
            }
            $this$mapNotNull$iv = unit.getSubtypes();
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv3 = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach5 = false;
            iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator3.next();
                bl14 = false;
                it = (InferenceUnitNode)element$iv$iv;
                boolean bl19 = false;
                if (InferenceUnitGraphKt.getRepresentative(unit, it, representativeMap) == null) continue;
                bl13 = false;
                bl12 = false;
                it$iv$iv = inferenceUnit;
                bl11 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv3;
            $i$f$forEach6 = false;
            for (Object element$iv6 : $this$forEach$iv5) {
                InferenceUnit it6 = (InferenceUnit)element$iv6;
                boolean bl20 = false;
                builder.addRelation(unit.getCore(), it6);
            }
        }
        return builder.build();
    }

    @Nullable
    public static final InferenceUnit getRepresentative(@NotNull InferenceUnitNode anchor, @NotNull InferenceUnitNode target, @NotNull Map<InferenceUnit, InferenceUnit> representativeMap) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(representativeMap, (String)"representativeMap");
        Object object = MapsKt.getValue(representativeMap, (Object)target.getCore());
        boolean bl = false;
        boolean bl2 = false;
        InferenceUnit $this$run = (InferenceUnit)object;
        boolean bl3 = false;
        return Intrinsics.areEqual((Object)$this$run, (Object)((InferenceUnit)MapsKt.getValue(representativeMap, (Object)anchor.getCore()))) ? null : $this$run;
    }

    private static final InferenceUnitGraph topologicalOrder(InferenceUnitGraph unitGraph) {
        boolean bl = false;
        Set visited = new LinkedHashSet();
        boolean bl2 = false;
        List order = new ArrayList();
        for (InferenceUnitNode node : unitGraph.getUnits()) {
            if (visited.contains(node)) continue;
            InferenceUnitGraphKt.traverseGraph(node, visited, order);
        }
        return new InferenceUnitGraph(CollectionsKt.reversed((Iterable)order));
    }

    private static final void traverseGraph(InferenceUnitNode node, Set<InferenceUnitNode> visited, List<InferenceUnitNode> order) {
        visited.add(node);
        for (InferenceUnitNode dependentNode : node.getSubtypes()) {
            if (visited.contains(dependentNode)) continue;
            InferenceUnitGraphKt.traverseGraph(dependentNode, visited, order);
        }
        order.add(node);
    }

    /*
     * WARNING - void declaration
     */
    private static final InferenceUnitGraph setTreeStructure(InferenceUnitGraph order) {
        void $this$filterTo$iv$iv;
        Object node;
        boolean bl = false;
        Map parentMap = new LinkedHashMap();
        Iterable $this$forEach$iv = order.getUnits();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            node = (InferenceUnitNode)element$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = ((InferenceUnitNode)node).getSubtypes();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                InferenceUnitNode it = (InferenceUnitNode)element$iv2;
                boolean bl3 = false;
                parentMap.put(it, node);
            }
        }
        Iterable $this$filter$iv = order.getUnits();
        boolean $i$f$filter = false;
        node = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            InferenceUnitNode it = (InferenceUnitNode)element$iv$iv;
            boolean bl4 = false;
            if (!(it.getSupertypes().size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (InferenceUnitNode unit : (List)destination$iv$iv) {
            List branches = CollectionsKt.toList((Iterable)unit.getSupertypes());
            InferenceUnitNode rootBranch = (InferenceUnitNode)CollectionsKt.first((List)branches);
            Set processedUnits = CollectionsKt.toMutableSet((Iterable)InferenceUnitGraphKt.collectParents(rootBranch, parentMap));
            for (InferenceUnitNode currentBranch : CollectionsKt.minus((Iterable)branches, (Object)rootBranch)) {
                if (processedUnits.contains(currentBranch)) continue;
                InferenceUnitGraphKt.merge(rootBranch, currentBranch, processedUnits, parentMap);
                rootBranch = currentBranch;
                processedUnits.addAll((Collection)InferenceUnitGraphKt.collectParents(rootBranch, parentMap));
            }
            parentMap.put(unit, rootBranch);
        }
        InferenceUnitGraphBuilder builder = new InferenceUnitGraphBuilder();
        for (InferenceUnitNode unit : order.getUnits()) {
            InferenceUnitNode inferenceUnitNode;
            builder.register(unit);
            if ((InferenceUnitNode)parentMap.get(unit) == null) continue;
            boolean bl5 = false;
            boolean bl6 = false;
            InferenceUnitNode $this$run = inferenceUnitNode;
            boolean bl7 = false;
            builder.addRelation($this$run.getCore(), unit.getCore());
        }
        return builder.build();
    }

    private static final Set<InferenceUnitNode> collectParents(InferenceUnitNode unit, Map<InferenceUnitNode, InferenceUnitNode> parentMap) {
        Set<InferenceUnitNode> set;
        if (unit == null) {
            boolean bl = false;
            set = new LinkedHashSet();
        } else {
            Set<InferenceUnitNode> set2 = InferenceUnitGraphKt.collectParents(parentMap.get(unit), parentMap);
            boolean bl = false;
            boolean bl2 = false;
            Set<InferenceUnitNode> $this$apply = set2;
            boolean bl3 = false;
            $this$apply.add(unit);
            set = set2;
        }
        return set;
    }

    private static final void merge(InferenceUnitNode anchorUnit, InferenceUnitNode mergingUnit, Set<InferenceUnitNode> commonUnits, Map<InferenceUnitNode, InferenceUnitNode> parentMap) {
        while (true) {
            if (CollectionsKt.contains((Iterable)commonUnits, (Object)parentMap.get(mergingUnit)) || parentMap.get(mergingUnit) == null) break;
            mergingUnit = (InferenceUnitNode)MapsKt.getValue(parentMap, (Object)mergingUnit);
        }
        parentMap.put(mergingUnit, anchorUnit);
    }

    private static final InferenceUnitGraph propagateTypeInstantiations(InferenceUnitGraph unitGraph) {
        InferenceUnitGraphBuilder builder = new InferenceUnitGraphBuilder();
        boolean bl = false;
        Map instantiations = new LinkedHashMap();
        for (InferenceUnitNode unit : unitGraph.getUnits()) {
            if (!(Intrinsics.areEqual((Object)unit.getTypeInstantiation(), (Object)PsiType.NULL) ^ true) || unitGraph.dependsOnNode(unit.getTypeInstantiation())) continue;
            InferenceUnitNode currentUnit = unit;
            while (currentUnit.getParent() != null) {
                Intrinsics.checkNotNull((Object)currentUnit.getParent());
            }
            if (Intrinsics.areEqual((Object)currentUnit, (Object)unit) ^ true) {
                instantiations.put(unit.getCore(), currentUnit.getType());
            }
            Map map2 = instantiations;
            InferenceUnit inferenceUnit = currentUnit.getCore();
            boolean bl2 = false;
            Map map3 = map2;
            boolean bl3 = false;
            if (map3.containsKey(inferenceUnit)) {
                InferenceUnit inferenceUnit2 = currentUnit.getCore();
                Object v = instantiations.get(currentUnit.getCore());
                Intrinsics.checkNotNull(v);
                instantiations.put(inferenceUnit2, InferenceUnitGraphKt.mergeTypes((PsiType)v, unit.getTypeInstantiation()));
                continue;
            }
            instantiations.put(currentUnit.getCore(), unit.getTypeInstantiation());
        }
        for (InferenceUnitNode unit : unitGraph.getUnits()) {
            builder.register(unit);
            Iterable $this$forEach$iv = unit.getSupertypes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                InferenceUnitNode it = (InferenceUnitNode)element$iv;
                boolean bl4 = false;
                builder.addRelation(it.getCore(), unit.getCore());
            }
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            PsiType psiType = (PsiType)instantiations.get(unit.getCore());
            if (psiType == null) {
                continue;
            }
            builder.setType(unit.getCore(), psiType);
        }
        return builder.build();
    }

    private static final PsiType mergeTypes(PsiType firstType, PsiType secondType) {
        if (Intrinsics.areEqual((Object)firstType, (Object)PsiType.NULL)) {
            return secondType;
        }
        if (Intrinsics.areEqual((Object)secondType, (Object)PsiType.NULL)) {
            return firstType;
        }
        PsiClass psiClass = InferenceProcessUtilKt.resolve(firstType);
        if (psiClass == null) {
            return firstType;
        }
        PsiClass context = psiClass;
        if (firstType instanceof PsiWildcardType && secondType instanceof PsiWildcardType) {
            if (((PsiWildcardType)firstType).isExtends() && ((PsiWildcardType)secondType).isExtends()) {
                PsiType psiType = ((PsiWildcardType)firstType).getBound();
                Intrinsics.checkNotNull((Object)psiType);
                PsiType psiType2 = ((PsiWildcardType)secondType).getBound();
                Intrinsics.checkNotNull((Object)psiType2);
                return TypesUtil.canAssign(psiType, psiType2, (PsiElement)context, GrTypeConverter.Position.METHOD_PARAMETER) == ConversionResult.OK ? firstType : secondType;
            }
            if (((PsiWildcardType)firstType).isExtends()) {
                return firstType;
            }
            if (((PsiWildcardType)secondType).isExtends()) {
                return secondType;
            }
            PsiType psiType = ((PsiWildcardType)firstType).getBound();
            Intrinsics.checkNotNull((Object)psiType);
            PsiType psiType3 = ((PsiWildcardType)secondType).getBound();
            Intrinsics.checkNotNull((Object)psiType3);
            return TypesUtil.canAssign(psiType, psiType3, (PsiElement)context, GrTypeConverter.Position.METHOD_PARAMETER) == ConversionResult.OK ? secondType : firstType;
        }
        if (!(firstType instanceof PsiWildcardType)) {
            return firstType;
        }
        return secondType;
    }
}

