/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.NegatingGotoInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ConditionInstruction;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public final class DFAType {
    private final PsiType primary;
    @NotNull
    private final PsiType flushingType;
    private final List<Mixin> mixins = new ArrayList<Mixin>();

    private DFAType(@Nullable PsiType primary) {
        this.primary = primary;
        this.flushingType = PsiType.NULL;
    }

    private DFAType(@Nullable PsiType primary, @Nullable PsiType flushingType) {
        this.primary = primary;
        this.flushingType = flushingType == null ? PsiType.NULL : flushingType;
    }

    public void addMixin(@Nullable PsiType mixin, @Nullable ConditionInstruction instruction) {
        if (mixin == null) {
            return;
        }
        this.mixins.add(new Mixin(mixin, instruction, instruction != null && instruction.isNegated()));
    }

    public DFAType addFlushingType(@Nullable PsiType flushingType, @NotNull PsiManager manager) {
        if (manager == null) {
            DFAType.$$$reportNull$$$0(0);
        }
        PsiType newFlushingType = GenericsUtil.getLeastUpperBound((PsiType)this.flushingType, (PsiType)flushingType, (PsiManager)manager);
        DFAType newDFAType = new DFAType(this.primary, newFlushingType);
        newDFAType.mixins.addAll(this.mixins);
        return newDFAType;
    }

    @NotNull
    public PsiType getFlushingType() {
        PsiType psiType = this.flushingType;
        if (psiType == null) {
            DFAType.$$$reportNull$$$0(1);
        }
        return psiType;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DFAType)) {
            return false;
        }
        DFAType other = (DFAType)obj;
        if (!DFAType.eq(this.primary, other.primary)) {
            return false;
        }
        if (this.mixins.size() != other.mixins.size()) {
            return false;
        }
        for (Mixin mixin1 : this.mixins) {
            boolean contains = false;
            for (Mixin mixin2 : other.mixins) {
                if (!mixin1.equals(mixin2)) continue;
                contains = mixin1.myNegated == mixin2.myNegated;
                break;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    @Contract(value="-> new")
    @NotNull
    public DFAType copy() {
        DFAType type2 = new DFAType(this.primary, this.flushingType);
        type2.mixins.addAll(this.mixins);
        DFAType dFAType = type2;
        if (dFAType == null) {
            DFAType.$$$reportNull$$$0(2);
        }
        return dFAType;
    }

    @Contract(value="_ -> new")
    @NotNull
    public DFAType negate(@NotNull NegatingGotoInstruction negation) {
        if (negation == null) {
            DFAType.$$$reportNull$$$0(3);
        }
        DFAType result2 = this.copy();
        Set<ConditionInstruction> conditionsToNegate = negation.getCondition().getDependentConditions();
        ListIterator<Mixin> iterator2 = result2.mixins.listIterator();
        while (iterator2.hasNext()) {
            Mixin mixin = iterator2.next();
            if (!conditionsToNegate.contains(mixin.myCondition)) continue;
            iterator2.set(mixin.negate());
        }
        DFAType dFAType = result2;
        if (dFAType == null) {
            DFAType.$$$reportNull$$$0(4);
        }
        return dFAType;
    }

    @Nullable
    public PsiType getResultType(@NotNull PsiManager manager) {
        PsiType flushedPrimary;
        if (manager == null) {
            DFAType.$$$reportNull$$$0(5);
        }
        PsiType psiType = flushedPrimary = PsiType.NULL.equals((Object)this.flushingType) ? this.primary : GenericsUtil.getLeastUpperBound((PsiType)this.primary, (PsiType)this.flushingType, (PsiManager)manager);
        if (this.mixins.isEmpty()) {
            return flushedPrimary;
        }
        ArrayList<PsiType> types = new ArrayList<PsiType>();
        if (flushedPrimary != null) {
            types.add(flushedPrimary);
        }
        for (Mixin mixin : this.mixins) {
            if (mixin.myNegated || mixin.myType.equals(PsiType.NULL)) continue;
            types.add(mixin.myType);
        }
        if (types.isEmpty()) {
            return null;
        }
        return PsiIntersectionType.createIntersection((PsiType[])types.toArray(PsiType.createArray((int)types.size())));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static DFAType create(@Nullable PsiType type2) {
        return new DFAType(type2);
    }

    private static boolean eq(PsiType t1, PsiType t2) {
        return t1 == t2 || Comparing.equal((Object)TypeConversionUtil.erasure((PsiType)t1), (Object)TypeConversionUtil.erasure((PsiType)t2));
    }

    @NotNull
    public static DFAType create(DFAType t1, DFAType t2, PsiManager manager) {
        if (t1.equals(t2)) {
            DFAType dFAType = t1;
            if (dFAType == null) {
                DFAType.$$$reportNull$$$0(6);
            }
            return dFAType;
        }
        PsiType primary = TypesUtil.getLeastUpperBoundNullable(t1.primary, t2.primary, manager);
        PsiType commonFlushingType = GenericsUtil.getLeastUpperBound((PsiType)t1.flushingType, (PsiType)t2.flushingType, (PsiManager)manager);
        DFAType type2 = new DFAType(primary, commonFlushingType);
        PsiType type1 = DFAType.reduce(t1.mixins);
        PsiType type22 = DFAType.reduce(t2.mixins);
        if (type1 != null && type22 != null) {
            type2.addMixin(GenericsUtil.getLeastUpperBound((PsiType)type1, (PsiType)type22, (PsiManager)manager), null);
        }
        DFAType dFAType = type2;
        if (dFAType == null) {
            DFAType.$$$reportNull$$$0(7);
        }
        return dFAType;
    }

    private static PsiType reduce(List<Mixin> mixins) {
        List types = mixins.stream().filter(it -> !it.myNegated).map(it -> it.myType).collect(Collectors.toList());
        return types.isEmpty() ? null : PsiIntersectionType.createIntersection(types);
    }

    public String toString() {
        return "{" + this.primary + " : " + this.mixins + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "negation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlushingType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "negate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFlushingType";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "negate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResultType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Mixin {
        @NotNull
        private final PsiType myType;
        @Nullable
        private final ConditionInstruction myCondition;
        private final boolean myNegated;

        private Mixin(@NotNull PsiType type2, @Nullable ConditionInstruction condition, boolean negated) {
            if (type2 == null) {
                Mixin.$$$reportNull$$$0(0);
            }
            this.myType = type2;
            this.myCondition = condition;
            this.myNegated = negated;
        }

        private Mixin negate() {
            return new Mixin(this.myType, this.myCondition, !this.myNegated);
        }

        public String toString() {
            return (this.myNegated ? "!" : "") + this.myType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Mixin mixin = (Mixin)o;
            if (!this.myType.equals(mixin.myType)) {
                return false;
            }
            return Objects.equals(this.myCondition, mixin.myCondition);
        }

        public int hashCode() {
            int result2 = this.myType.hashCode();
            result2 = 31 * result2 + (this.myCondition != null ? this.myCondition.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAType$Mixin", "<init>"));
        }
    }
}

