/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.arithmetic;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.references.GrUnaryOperatorReference;
import org.jetbrains.plugins.groovy.lang.typing.DefaultMethodCallTypeCalculatorKt;

public class GrUnaryExpressionImpl
extends GrExpressionImpl
implements GrUnaryExpression {
    private final GroovyMethodCallReference myReference;

    public GrUnaryExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrUnaryExpressionImpl.$$$reportNull$$$0(0);
        }
        super(node);
        this.myReference = new GrUnaryOperatorReference(this);
    }

    @Override
    @NotNull
    public GroovyMethodCallReference getReference() {
        GroovyMethodCallReference groovyMethodCallReference = this.myReference;
        if (groovyMethodCallReference == null) {
            GrUnaryExpressionImpl.$$$reportNull$$$0(1);
        }
        return groovyMethodCallReference;
    }

    public String toString() {
        return "Unary expression";
    }

    @Override
    @Nullable
    public PsiType getOperationType() {
        GroovyMethodCallReference reference = this.getReference();
        GroovyResolveResult result2 = reference.advancedResolve();
        PsiType operatorType = DefaultMethodCallTypeCalculatorKt.getTypeFromResult(result2, reference.getArguments(), this);
        if (operatorType != null) {
            return operatorType;
        }
        GrExpression operand = this.getOperand();
        if (operand == null) {
            return null;
        }
        PsiType operandType = operand.getType();
        if (TypesUtil.isNumericType(operandType)) {
            return operandType;
        }
        return null;
    }

    @Override
    @NotNull
    public IElementType getOperationTokenType() {
        PsiElement opElement = this.getOperationToken();
        ASTNode node = opElement.getNode();
        assert (node != null);
        IElementType iElementType = node.getElementType();
        if (iElementType == null) {
            GrUnaryExpressionImpl.$$$reportNull$$$0(2);
        }
        return iElementType;
    }

    @Override
    @NotNull
    public PsiElement getOperationToken() {
        PsiElement opElement = this.findChildByType(TokenSets.UNARY_OP_SET);
        assert (opElement != null);
        PsiElement psiElement = opElement;
        if (psiElement == null) {
            GrUnaryExpressionImpl.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @Override
    public GrExpression getOperand() {
        return GrUnaryExpressionImpl.findExpressionChild(this);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrUnaryExpressionImpl.$$$reportNull$$$0(4);
        }
        visitor2.visitUnaryExpression(this);
    }

    @Override
    public boolean isPostfix() {
        return this.getFirstChild() instanceof GrExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/arithmetic/GrUnaryExpressionImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/arithmetic/GrUnaryExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationTokenType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationToken";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

