/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.psi.PsiType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.codehaus.groovy.syntax.Numbers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\nH\u0002\u001a\f\u0010\r\u001a\u00020\f*\u0004\u0018\u00010\u000e\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"zeros", "", "", "getLiteralType", "Lcom/intellij/psi/PsiType;", "literal", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/literals/GrLiteral;", "parseInteger", "", "literalText", "", "hasIntegerSuffix", "", "isZero", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "intellij.groovy.psi"})
public final class LiteralUtilKt {
    private static final Set<Object> zeros;

    @Nullable
    public static final Number parseInteger(@NotNull String literalText) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)literalText, (String)"literalText");
        try {
            number = Numbers.parseInteger((String)literalText);
        }
        catch (NumberFormatException e) {
            number = null;
        }
        return number;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final PsiType getLiteralType(@NotNull GrLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        elemType = GrLiteralImpl.getLiteralType(literal);
        if (elemType == GroovyElementTypes.KW_NULL) {
            return (PsiType)PsiType.NULL;
        }
        if (!Intrinsics.areEqual((Object)elemType, (Object)GroovyElementTypes.NUM_INT)) ** GOTO lbl-1000
        var3_2 = literal.getText();
        var4_3 = false;
        var5_5 = false;
        text = var3_2;
        $i$a$-let-LiteralUtilKt$getLiteralType$integerLiteralWithoutSuffix$1 = false;
        v0 = text;
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"text");
        if (LiteralUtilKt.hasIntegerSuffix(v0) == false) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = integerLiteralWithoutSuffix = false;
        }
        if (!integerLiteralWithoutSuffix) ** GOTO lbl29
        var4_4 = literal.getValue();
        if (var4_4 instanceof Integer) {
            v2 = "java.lang.Integer";
        } else if (var4_4 instanceof Long) {
            v2 = "java.lang.Long";
        } else if (var4_4 instanceof BigInteger) {
            v2 = "java.math.BigInteger";
        } else {
            return null;
lbl29:
            // 1 sources

            v3 = TypesUtil.getBoxedTypeName(elemType);
            if (v3 == null) {
                return null;
            }
            v2 = v3;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"TypesUtil.getBoxedTypeNa\u2026(elemType) ?: return null");
        }
        fqn = v2;
        return (PsiType)TypesUtil.createTypeByFQClassName(fqn, literal);
    }

    private static final boolean hasIntegerSuffix(String $this$hasIntegerSuffix) {
        return StringsKt.endsWith$default((CharSequence)$this$hasIntegerSuffix, (char)'i', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)$this$hasIntegerSuffix, (char)'I', (boolean)false, (int)2, null);
    }

    public static final boolean isZero(@Nullable GrExpression $this$isZero) {
        if (!($this$isZero instanceof GrLiteral)) {
            return false;
        }
        Object value = ((GrLiteral)$this$isZero).getValue();
        return CollectionsKt.contains((Iterable)zeros, (Object)value) || value instanceof BigDecimal && ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0;
    }

    static {
        Object[] objectArray = new Object[5];
        objectArray[0] = 0;
        objectArray[1] = 0L;
        objectArray[2] = Float.valueOf(0.0f);
        objectArray[3] = 0.0;
        int n = 0;
        boolean bl = false;
        BigInteger bigInteger = BigInteger.valueOf(n);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"BigInteger.valueOf(this.toLong())");
        objectArray[4] = bigInteger;
        zeros = SetsKt.setOf((Object[])objectArray);
    }
}

