/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.lang.typing.FixedMultiAssignmentTypes;
import org.jetbrains.plugins.groovy.lang.typing.MultiAssignmentTypes;
import org.jetbrains.plugins.groovy.lang.typing.UnboundedMultiAssignmentTypes;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\u001a\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0015\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0010\u001a\u0015\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0013\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"tupleRegex", "Lkotlin/text/Regex;", "getIterableMultiAssignmentTypes", "Lorg/jetbrains/plugins/groovy/lang/typing/MultiAssignmentTypes;", "rValue", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "getLiteralMultiAssignmentTypes", "Lorg/jetbrains/plugins/groovy/lang/typing/FixedMultiAssignmentTypes;", "getLiteralMultiAssignmentTypesCS", "getMultiAssignmentType", "Lcom/intellij/psi/PsiType;", "position", "", "getMultiAssignmentTypes", "getMultiAssignmentTypesCS", "getMultiAssignmentTypesCountCS", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;)Ljava/lang/Integer;", "getTupleComponentCountOrNull", "type", "(Lcom/intellij/psi/PsiType;)Ljava/lang/Integer;", "getTupleMultiAssignmentTypes", "getTupleMultiAssignmentTypesCS", "intellij.groovy.psi"})
public final class TuplesKt {
    private static final Regex tupleRegex;

    @Nullable
    public static final Integer getTupleComponentCountOrNull(@NotNull PsiType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        PsiType psiType = type2;
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        PsiClassType psiClassType = (PsiClassType)psiType;
        if (psiClassType == null) {
            return null;
        }
        PsiClassType classType = psiClassType;
        Object object = classType.resolve();
        if (object == null || (object = object.getQualifiedName()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classType.resolve()?.qua\u2026           ?: return null");
        Object fqn = object;
        Object object2 = tupleRegex.matchEntire((CharSequence)fqn);
        return object2 != null && (object2 = object2.getGroupValues()) != null && (object2 = (String)CollectionsKt.getOrNull((List)object2, (int)1)) != null ? StringsKt.toIntOrNull((String)object2) : null;
    }

    @Nullable
    public static final PsiType getMultiAssignmentType(@NotNull GrExpression rValue, int position) {
        Intrinsics.checkNotNullParameter((Object)rValue, (String)"rValue");
        MultiAssignmentTypes multiAssignmentTypes = TuplesKt.getMultiAssignmentTypes(rValue);
        return multiAssignmentTypes != null ? multiAssignmentTypes.getComponentType(position) : null;
    }

    @Nullable
    public static final MultiAssignmentTypes getMultiAssignmentTypes(@NotNull GrExpression rValue) {
        Intrinsics.checkNotNullParameter((Object)rValue, (String)"rValue");
        if (CompileStaticUtil.isCompileStatic(rValue)) {
            return TuplesKt.getMultiAssignmentTypesCS(rValue);
        }
        FixedMultiAssignmentTypes fixedMultiAssignmentTypes = TuplesKt.getLiteralMultiAssignmentTypes(rValue);
        if (fixedMultiAssignmentTypes == null) {
            fixedMultiAssignmentTypes = TuplesKt.getTupleMultiAssignmentTypes(rValue);
        }
        return fixedMultiAssignmentTypes != null ? (MultiAssignmentTypes)fixedMultiAssignmentTypes : TuplesKt.getIterableMultiAssignmentTypes(rValue);
    }

    @Nullable
    public static final Integer getMultiAssignmentTypesCountCS(@NotNull GrExpression rValue) {
        Intrinsics.checkNotNullParameter((Object)rValue, (String)"rValue");
        Object object = TuplesKt.getMultiAssignmentTypesCS(rValue);
        return object != null && (object = ((FixedMultiAssignmentTypes)object).getTypes()) != null ? Integer.valueOf(object.size()) : null;
    }

    private static final FixedMultiAssignmentTypes getMultiAssignmentTypesCS(GrExpression rValue) {
        FixedMultiAssignmentTypes fixedMultiAssignmentTypes = TuplesKt.getLiteralMultiAssignmentTypesCS(rValue);
        if (fixedMultiAssignmentTypes == null) {
            fixedMultiAssignmentTypes = TuplesKt.getTupleMultiAssignmentTypesCS(rValue);
        }
        return fixedMultiAssignmentTypes;
    }

    private static final FixedMultiAssignmentTypes getLiteralMultiAssignmentTypesCS(GrExpression rValue) {
        if (!(rValue instanceof GrListOrMap) || ((GrListOrMap)rValue).isMap()) {
            return null;
        }
        return TuplesKt.getLiteralMultiAssignmentTypes(rValue);
    }

    private static final FixedMultiAssignmentTypes getLiteralMultiAssignmentTypes(GrExpression rValue) {
        PsiType psiType = rValue.getType();
        if (!(psiType instanceof GrTupleType)) {
            psiType = null;
        }
        GrTupleType grTupleType = (GrTupleType)psiType;
        if (grTupleType == null) {
            return null;
        }
        GrTupleType tupleType = grTupleType;
        List<PsiType> list = tupleType.getComponentTypes();
        Intrinsics.checkNotNullExpressionValue(list, (String)"tupleType.componentTypes");
        return new FixedMultiAssignmentTypes(list);
    }

    private static final FixedMultiAssignmentTypes getTupleMultiAssignmentTypesCS(GrExpression rValue) {
        if (GroovyConfigUtils.getInstance().getSDKVersion(rValue).compareTo("3.0") < 0) {
            return null;
        }
        return TuplesKt.getTupleMultiAssignmentTypes(rValue);
    }

    private static final FixedMultiAssignmentTypes getTupleMultiAssignmentTypes(GrExpression rValue) {
        PsiType psiType = rValue.getType();
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        PsiClassType psiClassType = (PsiClassType)psiType;
        if (psiClassType == null) {
            return null;
        }
        PsiClassType classType = psiClassType;
        Object object = classType.resolve();
        if (object == null || (object = object.getQualifiedName()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classType.resolve()?.qua\u2026           ?: return null");
        Object fqn = object;
        CharSequence charSequence = (CharSequence)fqn;
        Regex regex = tupleRegex;
        boolean bl = false;
        if (!regex.matches(charSequence)) {
            return null;
        }
        Object[] objectArray = classType.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"classType.parameters");
        return new FixedMultiAssignmentTypes(ArraysKt.toList((Object[])objectArray));
    }

    private static final MultiAssignmentTypes getIterableMultiAssignmentTypes(GrExpression rValue) {
        PsiType psiType = PsiUtil.extractIterableTypeParameter((PsiType)rValue.getType(), (boolean)false);
        if (psiType == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"extractIterableTypeParam\u2026pe, false) ?: return null");
        PsiType iterableTypeParameter = psiType;
        return new UnboundedMultiAssignmentTypes(iterableTypeParameter);
    }

    static {
        String string = "groovy.lang.Tuple(\\d+)";
        boolean bl = false;
        tupleRegex = new Regex(string);
    }
}

