/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.resolve.jvm.checkers.PolymorphicSignatureCallChecker;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u000f*\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/PolymorphicSignatureLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "isCast", "", "transform", "castReturnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "backend.jvm"})
public final class PolymorphicSignatureLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public PolymorphicSignatureLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        if (this.context.getState().getLanguageVersionSettings().supportsFeature(LanguageFeature.PolymorphicSignature)) {
            this.transformChildrenVoid(irFile);
        }
    }

    private final boolean isCast(IrTypeOperatorCall $this$isCast) {
        return $this$isCast.getOperator() != IrTypeOperator.INSTANCEOF && $this$isCast.getOperator() != IrTypeOperator.NOT_INSTANCEOF;
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrCall irCall;
        IrCall irCall2;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrExpression irExpression = expression2.getArgument();
        IrCall irCall3 = irCall2 = irExpression instanceof IrCall ? (IrCall)irExpression : null;
        if (irCall2 == null) {
            irCall = null;
        } else {
            IrCall irCall4 = irCall2;
            boolean bl = false;
            boolean bl2 = false;
            IrCall it = irCall4;
            boolean bl3 = false;
            irExpression = this.isCast(expression2) && IrTypePredicatesKt.isNullableAny(it.getType()) ? irCall4 : null;
            irCall = irExpression == null ? null : this.transform((IrCall)irExpression, expression2.getTypeOperand());
        }
        IrCall irCall5 = irCall;
        return irCall5 == null ? super.visitTypeOperator(expression2) : (IrExpression)irCall5;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrCall irCall = this.transform(expression2, null);
        return irCall == null ? super.visitCall(expression2) : (IrExpression)irCall;
    }

    /*
     * WARNING - void declaration
     */
    private final IrCall transform(IrCall $this$transform, IrType castReturnType) {
        List list2;
        IrType it;
        boolean $i$f$map;
        List list3;
        IrDeclarationBase irDeclarationBase;
        Object b = $this$transform.getSymbol().getOwner();
        IrDeclarationBase irDeclarationBase2 = irDeclarationBase = b instanceof IrSimpleFunction ? (IrSimpleFunction)b : null;
        if (irDeclarationBase == null) {
            return null;
        }
        IrDeclarationBase function2 = irDeclarationBase;
        if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)function2, PolymorphicSignatureCallChecker.polymorphicSignatureFqName)) {
            return null;
        }
        irDeclarationBase = CollectionsKt.singleOrNull(function2.getValueParameters());
        boolean bl = (irDeclarationBase == null ? null : ((IrValueParameter)irDeclarationBase).getVarargElementType()) != null;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-PolymorphicSignatureLowering$transform$222 = false;
            String $i$a$-assert-PolymorphicSignatureLowering$transform$222 = Intrinsics.stringPlus("@PolymorphicSignature methods should only have a single vararg argument: ", DumpIrTreeKt.dump$default($this$transform, false, 1, null));
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-PolymorphicSignatureLowering$transform$222));
        }
        IrVararg $i$a$-assert-PolymorphicSignatureLowering$transform$222 = (IrVararg)$this$transform.getValueArgument(0);
        if ($i$a$-assert-PolymorphicSignatureLowering$transform$222 == null) {
            list3 = null;
        } else {
            List<IrVarargElement> list4 = $i$a$-assert-PolymorphicSignatureLowering$transform$222.getElements();
            if (list4 == null) {
                list3 = null;
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list4;
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    IrExpression irExpression;
                    IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    IrType irType = it;
                    if (irType instanceof IrExpression) {
                        irExpression = (IrExpression)((Object)it);
                    } else if (irType instanceof IrSpreadElement) {
                        irExpression = ((IrSpreadElement)((Object)it)).getExpression();
                    } else {
                        throw new AssertionError((Object)Intrinsics.stringPlus("unknown IrVarargElement: ", it));
                    }
                    IrExpression irExpression2 = irExpression;
                    collection.add(irExpression2);
                }
                list3 = (List)destination$iv$iv;
            }
        }
        List list5 = list3;
        if (list5 == null) {
            boolean $i$a$-assert-PolymorphicSignatureLowering$transform$222 = false;
            list2 = CollectionsKt.emptyList();
        } else {
            list2 = list5;
        }
        List values2 = list2;
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        $i$f$map = false;
        boolean $this$mapTo$iv$iv = false;
        Object $this$buildFun_u24lambda_u2d14$iv = irFunctionBuilder;
        int n = 0;
        IrFunctionBuilder $this$transform_u24lambda_u2d3 = $this$buildFun_u24lambda_u2d14$iv;
        boolean bl4 = false;
        $this$transform_u24lambda_u2d3.updateFrom((IrFunction)function2);
        $this$transform_u24lambda_u2d3.setName(function2.getName());
        $this$transform_u24lambda_u2d3.setOrigin(JvmLoweredDeclarationOrigin.POLYMORPHIC_SIGNATURE_INSTANTIATION.INSTANCE);
        it = castReturnType;
        $this$transform_u24lambda_u2d3.setReturnType(it == null ? function2.getReturnType() : it);
        IrElementBase irElementBase = DeclarationBuildersKt.buildFunction($this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2d14$iv);
        boolean bl5 = false;
        boolean bl6 = false;
        IrSimpleFunction $this$transform_u24lambda_u2d4 = irElementBase;
        boolean bl7 = false;
        $this$transform_u24lambda_u2d4.setParent(function2.getParent());
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTypeParametersFrom$default($this$transform_u24lambda_u2d4, function2, null, null, 6, null);
        $this$transform_u24lambda_u2d4.setDispatchReceiverParameter(function2.getDispatchReceiverParameter());
        $this$transform_u24lambda_u2d4.setExtensionReceiverParameter(function2.getExtensionReceiverParameter());
        $this$buildFun_u24lambda_u2d14$iv = values2.iterator();
        n = 0;
        while ($this$buildFun_u24lambda_u2d14$iv.hasNext()) {
            int i = n++;
            IrExpression value2 = (IrExpression)$this$buildFun_u24lambda_u2d14$iv.next();
            DeclarationBuildersKt.addValueParameter((IrFunction)$this$transform_u24lambda_u2d4, Intrinsics.stringPlus("$", i), value2.getType(), (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.POLYMORPHIC_SIGNATURE_INSTANTIATION.INSTANCE);
        }
        IrSimpleFunction fakeFunction = irElementBase;
        irElementBase = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, $this$transform.getStartOffset(), $this$transform.getEndOffset(), fakeFunction.getReturnType(), fakeFunction.getSymbol(), 0, 0, $this$transform.getOrigin(), $this$transform.getSuperQualifierSymbol(), 48, null);
        bl5 = false;
        bl6 = false;
        IrElementBase $this$transform_u24lambda_u2d5 = irElementBase;
        boolean bl8 = false;
        IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default((IrMemberAccessExpression)$this$transform_u24lambda_u2d5, $this$transform, 0, 2, null);
        ((IrMemberAccessExpression)$this$transform_u24lambda_u2d5).setDispatchReceiver($this$transform.getDispatchReceiver());
        ((IrMemberAccessExpression)$this$transform_u24lambda_u2d5).setExtensionReceiver($this$transform.getExtensionReceiver());
        Iterable $this$forEachIndexed$iv = values2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void p1;
            int n2 = index$iv++;
            boolean bl9 = false;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrExpression irExpression = (IrExpression)item$iv;
            int p0 = n2;
            boolean bl10 = false;
            ((IrFunctionAccessExpression)$this$transform_u24lambda_u2d5).putValueArgument(p0, (IrExpression)p1);
        }
        this.transformChildrenVoid($this$transform_u24lambda_u2d5);
        return (IrCall)irElementBase;
    }
}

