/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.serialization;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.load.java.descriptors.JavaForKotlinOverridePropertyDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/serialization/JvmIdSignatureDescriptor;", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureDescriptor;", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;", "(Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;)V", "createSignatureBuilder", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureDescriptor$DescriptorBasedSignatureBuilder;", "JvmDescriptorBasedSignatureBuilder", "ir.serialization.jvm"})
public final class JvmIdSignatureDescriptor
extends IdSignatureDescriptor {
    @NotNull
    private final KotlinMangler.DescriptorMangler mangler;

    public JvmIdSignatureDescriptor(@NotNull KotlinMangler.DescriptorMangler mangler) {
        Intrinsics.checkNotNullParameter(mangler, "mangler");
        super(mangler);
        this.mangler = mangler;
    }

    @Override
    @NotNull
    protected IdSignatureDescriptor.DescriptorBasedSignatureBuilder createSignatureBuilder() {
        return new JvmDescriptorBasedSignatureBuilder(this.mangler);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0016H\u0014J\u001a\u0010\u0017\u001a\u00020\u000b*\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u001a\u0010\n\u001a\u00020\u000b*\u00020\u001a2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/serialization/JvmIdSignatureDescriptor$JvmDescriptorBasedSignatureBuilder;", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureDescriptor$DescriptorBasedSignatureBuilder;", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;", "(Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;)V", "collectContainingClasses", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "member", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isCapturingTypeParameter", "", "keepTrackOfOverridesForPossiblyClashingFakeOverride", "", "descriptor", "platformSpecificFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "platformSpecificGetter", "Lorg/jetbrains/kotlin/descriptors/PropertyGetterDescriptor;", "platformSpecificProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "platformSpecificSetter", "Lorg/jetbrains/kotlin/descriptors/PropertySetterDescriptor;", "containsTypeParametersOf", "Lorg/jetbrains/kotlin/types/KotlinType;", "containingClasses", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "ir.serialization.jvm"})
    private static final class JvmDescriptorBasedSignatureBuilder
    extends IdSignatureDescriptor.DescriptorBasedSignatureBuilder {
        public JvmDescriptorBasedSignatureBuilder(@NotNull KotlinMangler.DescriptorMangler mangler) {
            Intrinsics.checkNotNullParameter(mangler, "mangler");
            super(mangler);
        }

        @Override
        protected void platformSpecificFunction(@NotNull FunctionDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            this.keepTrackOfOverridesForPossiblyClashingFakeOverride(descriptor2);
        }

        @Override
        protected void platformSpecificProperty(@NotNull PropertyDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            this.setSpecialJavaProperty(descriptor2 instanceof JavaForKotlinOverridePropertyDescriptor);
            this.keepTrackOfOverridesForPossiblyClashingFakeOverride(descriptor2);
        }

        @Override
        protected void platformSpecificGetter(@NotNull PropertyGetterDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            this.keepTrackOfOverridesForPossiblyClashingFakeOverride(descriptor2);
        }

        @Override
        protected void platformSpecificSetter(@NotNull PropertySetterDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            this.keepTrackOfOverridesForPossiblyClashingFakeOverride(descriptor2);
        }

        private final void keepTrackOfOverridesForPossiblyClashingFakeOverride(CallableMemberDescriptor descriptor2) {
            Collection<CallableMemberDescriptor> collection;
            Object object;
            ClassDescriptor classDescriptor;
            if (descriptor2.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            ClassDescriptor classDescriptor2 = classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor containingClass = classDescriptor;
            declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
                MemberScope memberScope2 = containingClass.getUnsubstitutedMemberScope();
                object = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty().getName();
                Intrinsics.checkNotNullExpressionValue(object, "descriptor.correspondingProperty.name");
                collection = memberScope2.getContributedVariables((Name)object, NoLookupLocation.FROM_BACKEND);
            } else if (declarationDescriptor instanceof PropertyDescriptor) {
                MemberScope memberScope3 = containingClass.getUnsubstitutedMemberScope();
                object = ((PropertyDescriptor)descriptor2).getName();
                Intrinsics.checkNotNullExpressionValue(object, "descriptor.name");
                collection = memberScope3.getContributedVariables((Name)object, NoLookupLocation.FROM_BACKEND);
            } else if (declarationDescriptor instanceof FunctionDescriptor) {
                MemberScope memberScope4 = containingClass.getUnsubstitutedMemberScope();
                object = ((FunctionDescriptor)descriptor2).getName();
                Intrinsics.checkNotNullExpressionValue(object, "descriptor.name");
                collection = memberScope4.getContributedFunctions((Name)object, NoLookupLocation.FROM_BACKEND);
            } else {
                throw new AssertionError((Object)Intrinsics.stringPlus("Unexpected CallableMemberDescriptor: ", descriptor2));
            }
            Collection<? extends PropertyDescriptor> possiblyClashingMembers = collection;
            if (possiblyClashingMembers.size() <= 1) {
                return;
            }
            List<CallableMemberDescriptor> capturingOverrides2 = SequencesKt.toList(SequencesKt.filter(DescriptorUtilsKt.overriddenTreeAsSequence(descriptor2, true), (Function1)new Function1<CallableMemberDescriptor, Boolean>(this){
                final /* synthetic */ JvmDescriptorBasedSignatureBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final boolean invoke(@NotNull CallableMemberDescriptor it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && JvmDescriptorBasedSignatureBuilder.access$isCapturingTypeParameter(this.this$0, it);
                }
            }));
            object = capturingOverrides2;
            boolean bl = false;
            if (!object.isEmpty()) {
                Iterable $this$sortedBy$iv = capturingOverrides2;
                boolean $i$f$sortedBy = false;
                boolean bl2 = false;
                this.setOverridden(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        CallableMemberDescriptor it = (CallableMemberDescriptor)a;
                        boolean bl2 = false;
                        DeclarationDescriptor $this$cast$iv = it.getContainingDeclaration();
                        boolean $i$f$cast = false;
                        DeclarationDescriptor declarationDescriptor = $this$cast$iv;
                        if (declarationDescriptor == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                        }
                        it = (CallableMemberDescriptor)b;
                        Comparable comparable = (Comparable)((Object)DescriptorUtilsKt.getFqNameUnsafe((ClassDescriptor)declarationDescriptor).asString());
                        bl2 = false;
                        $this$cast$iv = it.getContainingDeclaration();
                        $i$f$cast = false;
                        DeclarationDescriptor declarationDescriptor2 = $this$cast$iv;
                        if (declarationDescriptor2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                        }
                        String string2 = DescriptorUtilsKt.getFqNameUnsafe((ClassDescriptor)declarationDescriptor2).asString();
                        return ComparisonsKt.compareValues(comparable, (Comparable)((Object)string2));
                    }
                }));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isCapturingTypeParameter(CallableMemberDescriptor member2) {
            ValueParameterDescriptor it;
            Set<ClassDescriptor> containingClasses = this.collectContainingClasses(member2);
            Object object = member2.getExtensionReceiverParameter();
            if (Intrinsics.areEqual(object == null ? null : Boolean.valueOf(this.isCapturingTypeParameter((ParameterDescriptor)object, containingClasses)), true)) return true;
            object = member2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(object, "member.valueParameters");
            Iterable $this$any$iv = (Iterable)object;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (ValueParameterDescriptor)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
            } while (!this.isCapturingTypeParameter(it, containingClasses));
            return true;
        }

        private final Set<ClassDescriptor> collectContainingClasses(CallableMemberDescriptor member2) {
            HashSet<ClassDescriptor> result2 = new HashSet<ClassDescriptor>();
            DeclarationDescriptor pointer = member2;
            while (true) {
                DeclarationDescriptor declarationDescriptor;
                ClassDescriptor classDescriptor;
                ClassDescriptor classDescriptor2 = classDescriptor = (declarationDescriptor = pointer.getContainingDeclaration()) instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
                if (classDescriptor == null) break;
                ClassDescriptor containingClass = classDescriptor;
                result2.add(containingClass);
                if (!containingClass.isInner()) break;
                pointer = containingClass;
            }
            return result2;
        }

        private final boolean isCapturingTypeParameter(ParameterDescriptor $this$isCapturingTypeParameter, Set<? extends ClassDescriptor> containingClasses) {
            KotlinType kotlinType = $this$isCapturingTypeParameter.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "type");
            return this.containsTypeParametersOf(kotlinType, containingClasses);
        }

        private final boolean containsTypeParametersOf(KotlinType $this$containsTypeParametersOf, Set<? extends ClassDescriptor> containingClasses) {
            return TypeUtilsKt.contains($this$containsTypeParametersOf, (Function1<? super UnwrappedType, Boolean>)new Function1<UnwrappedType, Boolean>(containingClasses){
                final /* synthetic */ Set<ClassDescriptor> $containingClasses;
                {
                    this.$containingClasses = $containingClasses;
                    super(1);
                }

                public final boolean invoke(@NotNull UnwrappedType it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    ClassifierDescriptor descriptor2 = it.getConstructor().getDeclarationDescriptor();
                    return descriptor2 instanceof TypeParameterDescriptor && CollectionsKt.contains((Iterable)this.$containingClasses, ((TypeParameterDescriptor)descriptor2).getContainingDeclaration());
                }
            });
        }

        public static final /* synthetic */ boolean access$isCapturingTypeParameter(JvmDescriptorBasedSignatureBuilder $this, CallableMemberDescriptor member2) {
            return $this.isCapturingTypeParameter(member2);
        }
    }
}

