/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.modules;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.modules.JavaModuleGraph;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModule;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleResolver;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ&\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000eH\u0082\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CliJavaModuleResolver;", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleResolver;", "moduleGraph", "Lorg/jetbrains/kotlin/cli/jvm/modules/JavaModuleGraph;", "userModules", "", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "systemModules", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Explicit;", "(Lorg/jetbrains/kotlin/cli/jvm/modules/JavaModuleGraph;Ljava/util/List;Ljava/util/List;)V", "sourceModule", "checkAccessibility", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleResolver$AccessError;", "fileFromOurModule", "Lcom/intellij/openapi/vfs/VirtualFile;", "referencedFile", "referencedPackage", "Lorg/jetbrains/kotlin/name/FqName;", "findJavaModule", "file", "contains", "", "cli"})
public final class CliJavaModuleResolver
implements JavaModuleResolver {
    @NotNull
    private final JavaModuleGraph moduleGraph;
    @NotNull
    private final List<JavaModule> userModules;
    @NotNull
    private final List<JavaModule.Explicit> systemModules;
    @Nullable
    private final JavaModule sourceModule;

    /*
     * WARNING - void declaration
     */
    public CliJavaModuleResolver(@NotNull JavaModuleGraph moduleGraph, @NotNull List<? extends JavaModule> userModules, @NotNull List<JavaModule.Explicit> systemModules2) {
        Object v1;
        block5: {
            void $this$firstOrNull$iv;
            int n;
            Intrinsics.checkParameterIsNotNull(moduleGraph, "moduleGraph");
            Intrinsics.checkParameterIsNotNull(userModules, "userModules");
            Intrinsics.checkParameterIsNotNull(systemModules2, "systemModules");
            this.moduleGraph = moduleGraph;
            this.userModules = userModules;
            this.systemModules = systemModules2;
            Iterable $this$count$iv322 = this.userModules;
            boolean $i$f$count = false;
            if ($this$count$iv322 instanceof Collection && ((Collection)$this$count$iv322).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv322) {
                    JavaModule p12 = (JavaModule)element$iv;
                    boolean bl = false;
                    if (!p12.isSourceModule()) continue;
                    int p12 = ++count$iv;
                    boolean bl2 = false;
                    if (p12 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            boolean $this$count$iv322 = n <= 1;
            $i$f$count = false;
            if (_Assertions.ENABLED && !$this$count$iv322) {
                boolean bl = false;
                String string2 = Intrinsics.stringPlus("Modules computed by ClasspathRootsResolver cannot have more than one source module: ", this.userModules);
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            Iterable $this$count$iv322 = this.userModules;
            CliJavaModuleResolver cliJavaModuleResolver = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JavaModule p0 = (JavaModule)element$iv;
                boolean bl = false;
                if (!p0.isSourceModule()) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        Object var12_18 = v1;
        cliJavaModuleResolver.sourceModule = var12_18;
    }

    private final JavaModule findJavaModule(VirtualFile file2) {
        JavaModule javaModule;
        if (Intrinsics.areEqual(file2.getFileSystem().getProtocol(), "jrt")) {
            Object v0;
            block7: {
                Iterable $this$firstOrNull$iv = this.systemModules;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    JavaModule.Explicit module2 = (JavaModule.Explicit)element$iv;
                    boolean bl = false;
                    if (!this.contains(module2, file2)) continue;
                    v0 = element$iv;
                    break block7;
                }
                v0 = null;
            }
            return v0;
        }
        FileType fileType = file2.getFileType();
        if (Intrinsics.areEqual(fileType, KotlinFileType.INSTANCE) ? true : Intrinsics.areEqual(fileType, JavaFileType.INSTANCE)) {
            javaModule = this.sourceModule;
        } else if (Intrinsics.areEqual(fileType, JavaClassFileType.INSTANCE)) {
            Object v2;
            block8: {
                Iterable $this$firstOrNull$iv = this.userModules;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    JavaModule module3 = (JavaModule)element$iv;
                    boolean bl = false;
                    if (!this.contains(module3, file2)) continue;
                    v2 = element$iv;
                    break block8;
                }
                v2 = null;
            }
            javaModule = v2;
        } else {
            javaModule = null;
        }
        return javaModule;
    }

    private final boolean contains(JavaModule $this$contains, VirtualFile file2) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull($this$contains, "<this>");
            Iterable $this$any$iv = $this$contains.getModuleRoots();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JavaModule.Root $dstr$root$isBinary = (JavaModule.Root)element$iv;
                    boolean bl2 = false;
                    VirtualFile root2 = $dstr$root$isBinary.component1();
                    boolean isBinary = $dstr$root$isBinary.component2();
                    if (!(isBinary && VfsUtilCore.isAncestor(root2, file2, false))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public JavaModuleResolver.AccessError checkAccessibility(@Nullable VirtualFile fileFromOurModule, @NotNull VirtualFile referencedFile, @Nullable FqName referencedPackage) {
        Object object;
        JavaModule javaModule;
        Intrinsics.checkParameterIsNotNull(referencedFile, "referencedFile");
        VirtualFile virtualFile2 = fileFromOurModule;
        if (virtualFile2 == null) {
            javaModule = null;
        } else {
            object = virtualFile2;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile p0 = object;
            boolean bl3 = false;
            javaModule = this.findJavaModule(p0);
        }
        JavaModule ourModule = javaModule;
        JavaModule theirModule = this.findJavaModule(referencedFile);
        object = ourModule;
        String string2 = object == null ? null : object.getName();
        object = theirModule;
        if (Intrinsics.areEqual(string2, object == null ? null : object.getName())) {
            return null;
        }
        if (theirModule == null) {
            return JavaModuleResolver.AccessError.ModuleDoesNotReadUnnamedModule.INSTANCE;
        }
        if (ourModule != null && !this.moduleGraph.reads(ourModule.getName(), theirModule.getName())) {
            return new JavaModuleResolver.AccessError.ModuleDoesNotReadModule(theirModule.getName());
        }
        FqName fqName2 = referencedPackage;
        if (fqName2 == null) {
            return null;
        }
        FqName fqName3 = fqName2;
        if (!(theirModule.exports(fqName3) || ourModule != null && theirModule.exportsTo(fqName3, ourModule.getName()))) {
            return new JavaModuleResolver.AccessError.ModuleDoesNotExportPackage(theirModule.getName());
        }
        return null;
    }
}

