/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.parcel;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.android.parcel.IgnoredOnParcel;
import kotlinx.android.parcel.TypeParceler;
import kotlinx.android.parcel.WriteWith;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.parcel.ParcelableResolveExtensionKt;
import org.jetbrains.kotlin.android.synthetic.diagnostic.ErrorsAndroid;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J,\u0010\u0013\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J,\u0010\u0014\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/android/parcel/ParcelableAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkIfTheContainingClassIsParcelize", "containingClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "checkIgnoredOnParcelUsage", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "checkTypeParcelerUsage", "checkWriteWithUsage", "Companion", "android-extensions-compiler"})
public final class ParcelableAnnotationChecker
implements CallChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final FqName TYPE_PARCELER_FQNAME = new FqName(TypeParceler.class.getName());
    @NotNull
    private static final FqName WRITE_WITH_FQNAME = new FqName(WriteWith.class.getName());
    @NotNull
    private static final FqName IGNORED_ON_PARCEL_FQNAME = new FqName(IgnoredOnParcel.class.getName());

    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        ClassDescriptor classDescriptor;
        ClassConstructorDescriptor classConstructorDescriptor;
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
        ClassConstructorDescriptor classConstructorDescriptor2 = classConstructorDescriptor = callableDescriptor instanceof ClassConstructorDescriptor ? (ClassConstructorDescriptor)callableDescriptor : null;
        if (classConstructorDescriptor == null) {
            return;
        }
        ClassConstructorDescriptor constructorDescriptor = classConstructorDescriptor;
        ClassDescriptor classDescriptor2 = constructorDescriptor.getConstructedClass();
        boolean bl = false;
        boolean bl2 = false;
        ClassDescriptor it = classDescriptor2;
        boolean bl3 = false;
        Object object = classDescriptor = it.getKind() == ClassKind.ANNOTATION_CLASS ? classDescriptor2 : null;
        if (classDescriptor == null) {
            return;
        }
        CallableDescriptor annotationClass = callableDescriptor = classDescriptor;
        classDescriptor2 = resolvedCall.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"resolvedCall.call.callElement");
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)classDescriptor2;
        boolean $i$f$getNonStrictParentOfType = false;
        classDescriptor = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtAnnotationEntry.class, (boolean)false);
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor annotationEntry = classDescriptor;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)annotationEntry;
        boolean $i$f$getStrictParentOfType = false;
        classDescriptor2 = (KtModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtModifierListOwner.class, (boolean)true);
        if (classDescriptor2 == null) {
            return;
        }
        ClassDescriptor annotationOwner = classDescriptor2;
        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)annotationClass)), (Object)TYPE_PARCELER_FQNAME)) {
            this.checkTypeParcelerUsage(resolvedCall, (KtAnnotationEntry)annotationEntry, context2, (KtModifierListOwner)annotationOwner);
        }
        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)annotationClass)), (Object)WRITE_WITH_FQNAME)) {
            this.checkWriteWithUsage(resolvedCall, (KtAnnotationEntry)annotationEntry, context2, (KtModifierListOwner)annotationOwner);
        }
        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)annotationClass)), (Object)IGNORED_ON_PARCEL_FQNAME)) {
            this.checkIgnoredOnParcelUsage((KtAnnotationEntry)annotationEntry, context2, (KtModifierListOwner)annotationOwner);
        }
    }

    private final void checkIgnoredOnParcelUsage(KtAnnotationEntry annotationEntry, CallCheckerContext context2, KtModifierListOwner element) {
        if (element instanceof KtParameter && PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), KtDeclaration.class) instanceof KtPrimaryConstructor) {
            context2.getTrace().report((Diagnostic)ErrorsAndroid.INAPPLICABLE_IGNORED_ON_PARCEL_CONSTRUCTOR_PROPERTY.on((PsiElement)annotationEntry));
        } else if (!(element instanceof KtProperty) || !(PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), KtDeclaration.class) instanceof KtClass)) {
            context2.getTrace().report((Diagnostic)ErrorsAndroid.INAPPLICABLE_IGNORED_ON_PARCEL.on((PsiElement)annotationEntry));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeParcelerUsage(ResolvedCall<?> resolvedCall, KtAnnotationEntry annotationEntry, CallCheckerContext context2, KtModifierListOwner element) {
        int duplicatingAnnotationCount;
        int n;
        void $this$count$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        DeclarationDescriptor declarationDescriptor;
        DeclarationDescriptor declarationDescriptor2 = (DeclarationDescriptor)context2.getTrace().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)element);
        if (declarationDescriptor2 == null) {
            return;
        }
        DeclarationDescriptor descriptor = declarationDescriptor = declarationDescriptor2;
        Collection collection = resolvedCall.getTypeArguments().values();
        boolean bl = false;
        boolean bl2 = false;
        Collection it2 = collection;
        boolean bl3 = false;
        Iterable<Object> iterable = it2.size() == 2 ? collection : null;
        KotlinType kotlinType = declarationDescriptor2 = iterable == null ? null : (KotlinType)CollectionsKt.first((Iterable)iterable);
        if (declarationDescriptor2 == null) {
            return;
        }
        DeclarationDescriptor thisMappedType = declarationDescriptor2;
        iterable = (Iterable)descriptor.getAnnotations();
        boolean $i$f$filter = false;
        void var10_14 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (AnnotationDescriptor)element$iv$iv;
            boolean bl4 = false;
            if (!Intrinsics.areEqual((Object)it.getFqName(), (Object)TYPE_PARCELER_FQNAME)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            KotlinType kotlinType2;
            List list;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl5 = false;
            AnnotationDescriptor it3 = (AnnotationDescriptor)element$iv$iv;
            boolean bl6 = false;
            List list2 = it3.getType().getArguments();
            boolean bl7 = false;
            boolean bl8 = false;
            List args = list2;
            boolean bl9 = false;
            List list3 = list = args.size() == 2 ? list2 : null;
            if ((list == null ? null : ((list2 = (TypeProjection)CollectionsKt.first((List)list)) == null ? null : list2.getType())) == null) continue;
            kotlinType2 = kotlinType2;
            boolean bl10 = false;
            boolean bl11 = false;
            KotlinType it$iv$iv = kotlinType2;
            boolean bl12 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$count2 = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                KotlinType it4 = (KotlinType)element$iv;
                boolean bl13 = false;
                if (!Intrinsics.areEqual((Object)it4, (Object)thisMappedType)) continue;
                int n2 = ++count$iv;
                bl13 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = duplicatingAnnotationCount = count$iv;
        }
        if (duplicatingAnnotationCount > 1) {
            List count$iv = annotationEntry.getTypeArguments();
            Intrinsics.checkNotNullExpressionValue((Object)count$iv, (String)"annotationEntry.typeArguments");
            KtTypeProjection $i$f$count2 = (KtTypeProjection)CollectionsKt.firstOrNull((List)count$iv);
            KtElementImplStub reportElement = $i$f$count2 == null ? (KtElementImplStub)annotationEntry : (KtElementImplStub)$i$f$count2;
            context2.getTrace().report((Diagnostic)ErrorsAndroid.DUPLICATING_TYPE_PARCELERS.on((PsiElement)reportElement));
            return;
        }
        KtModifierListOwner $i$f$count2 = element;
        KtClassOrObject containingClass = $i$f$count2 instanceof KtClassOrObject ? (KtClassOrObject)element : ($i$f$count2 instanceof KtParameter ? KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)element)) : null);
        this.checkIfTheContainingClassIsParcelize(containingClass, annotationEntry, context2);
        if (element instanceof KtParameter) {
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
            boolean $i$f$getStrictParentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtDeclaration.class, (boolean)true) instanceof KtPrimaryConstructor) {
                ClassDescriptor containingClassDescriptor = (ClassDescriptor)context2.getTrace().get((ReadOnlySlice)BindingContext.CLASS, (Object)containingClass);
                AnnotationDescriptor thisAnnotationDescriptor = (AnnotationDescriptor)context2.getTrace().get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)annotationEntry);
                if (containingClass != null && containingClassDescriptor != null && thisAnnotationDescriptor != null) {
                    boolean bl14;
                    block15: {
                        Iterable $this$any$iv = (Iterable)containingClassDescriptor.getAnnotations();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl14 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (AnnotationDescriptor)element$iv;
                                boolean bl15 = false;
                                if (!Intrinsics.areEqual((Object)it.getType(), (Object)thisAnnotationDescriptor.getType())) continue;
                                bl14 = true;
                                break block15;
                            }
                            bl14 = false;
                        }
                    }
                    if (bl14) {
                        KtUserType ktUserType;
                        KtTypeReference ktTypeReference = annotationEntry.getTypeReference();
                        KtTypeElement ktTypeElement = ktTypeReference == null ? null : ktTypeReference.getTypeElement();
                        KtUserType ktUserType2 = ktUserType = ktTypeElement instanceof KtUserType ? (KtUserType)ktTypeElement : null;
                        KtElement reportElement = ktUserType == null ? (KtElement)annotationEntry : ((ktTypeElement = ktUserType.getReferenceExpression()) == null ? (KtElement)annotationEntry : (KtElement)ktTypeElement);
                        context2.getTrace().report((Diagnostic)ErrorsAndroid.REDUNDANT_TYPE_PARCELER.on((PsiElement)reportElement, (Object)containingClass));
                    }
                }
            }
        }
    }

    private final void checkWriteWithUsage(ResolvedCall<?> resolvedCall, KtAnnotationEntry annotationEntry, CallCheckerContext context2, KtModifierListOwner element) {
        KotlinType kotlinType;
        Object v3;
        SimpleType simpleType;
        KotlinType actualType;
        block9: {
            ClassDescriptor classDescriptor;
            KotlinType kotlinType2;
            KtTypeReference ktTypeReference;
            KtTypeReference ktTypeReference2 = ktTypeReference = element instanceof KtTypeReference ? (KtTypeReference)element : null;
            if (ktTypeReference == null) {
                return;
            }
            KotlinType kotlinType3 = (KotlinType)context2.getTrace().get((ReadOnlySlice)BindingContext.TYPE, (Object)element);
            KotlinType kotlinType4 = kotlinType2 = kotlinType3 == null ? null : TypeUtilsKt.replaceAnnotations((KotlinType)kotlinType3, (Annotations)Annotations.Companion.getEMPTY());
            if (kotlinType2 == null) {
                return;
            }
            actualType = kotlinType2;
            kotlinType3 = (KotlinType)CollectionsKt.singleOrNull((Iterable)resolvedCall.getTypeArguments().values());
            if (kotlinType3 == null) {
                return;
            }
            KotlinType parcelerType = kotlinType3;
            ClassifierDescriptor classifierDescriptor = parcelerType.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor2 = classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor parcelerClass = classDescriptor;
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
            boolean $i$f$getStrictParentOfType = false;
            KtClassOrObject containingClass = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClassOrObject.class, (boolean)true);
            this.checkIfTheContainingClassIsParcelize(containingClass, annotationEntry, context2);
            if (parcelerClass.getKind() != ClassKind.OBJECT) {
                context2.getTrace().report((Diagnostic)ErrorsAndroid.PARCELER_SHOULD_BE_OBJECT.on((PsiElement)ParcelableAnnotationChecker.checkWriteWithUsage$reportElement(annotationEntry)));
                return;
            }
            simpleType = parcelerClass.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"parcelerClass.defaultType");
            Iterable $this$firstOrNull$iv = TypeUtilsKt.supertypes((KotlinType)((KotlinType)simpleType));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KotlinType it = (KotlinType)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)ParcelableAnnotationChecker.checkWriteWithUsage$fqName(it), (Object)ParcelableResolveExtensionKt.getPARCELER_FQNAME())) continue;
                v3 = element$iv;
                break block9;
            }
            v3 = null;
        }
        KotlinType $i$f$getStrictParentOfType = v3;
        if ($i$f$getStrictParentOfType == null) {
            return;
        }
        KotlinType parcelerSuperType = $i$f$getStrictParentOfType;
        TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull((List)parcelerSuperType.getArguments());
        KotlinType kotlinType5 = kotlinType = typeProjection == null ? null : typeProjection.getType();
        if (kotlinType == null) {
            return;
        }
        simpleType = kotlinType;
        SimpleType expectedType = simpleType;
        if (!TypeUtilsKt.isSubtypeOf((KotlinType)actualType, (KotlinType)expectedType)) {
            context2.getTrace().report((Diagnostic)ErrorsAndroid.PARCELER_TYPE_INCOMPATIBLE.on((PsiElement)ParcelableAnnotationChecker.checkWriteWithUsage$reportElement(annotationEntry), (Object)expectedType, (Object)actualType));
        }
    }

    private final void checkIfTheContainingClassIsParcelize(KtClassOrObject containingClass, KtAnnotationEntry annotationEntry, CallCheckerContext context2) {
        ClassDescriptor containingClassDescriptor;
        if (containingClass != null && (containingClassDescriptor = (ClassDescriptor)context2.getTrace().get((ReadOnlySlice)BindingContext.CLASS, (Object)containingClass)) != null && !ParcelableResolveExtensionKt.isParcelize(containingClassDescriptor)) {
            KtUserType ktUserType;
            KtTypeReference ktTypeReference = annotationEntry.getTypeReference();
            KtTypeElement ktTypeElement = ktTypeReference == null ? null : ktTypeReference.getTypeElement();
            KtUserType ktUserType2 = ktUserType = ktTypeElement instanceof KtUserType ? (KtUserType)ktTypeElement : null;
            KtElement reportElement = ktUserType == null ? (KtElement)annotationEntry : ((ktTypeElement = ktUserType.getReferenceExpression()) == null ? (KtElement)annotationEntry : (KtElement)ktTypeElement);
            context2.getTrace().report((Diagnostic)ErrorsAndroid.CLASS_SHOULD_BE_PARCELIZE.on((PsiElement)reportElement, (Object)containingClass));
        }
    }

    private static final KtElementImplStub<? extends StubElement<? extends KtElementImplStub<?>>> checkWriteWithUsage$reportElement(KtAnnotationEntry $annotationEntry) {
        List list = $annotationEntry.getTypeArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"annotationEntry.typeArguments");
        KtTypeProjection ktTypeProjection = (KtTypeProjection)CollectionsKt.singleOrNull((List)list);
        return ktTypeProjection == null ? (KtElementImplStub)$annotationEntry : (KtElementImplStub)ktTypeProjection;
    }

    private static final FqName checkWriteWithUsage$fqName(KotlinType $this$checkWriteWithUsage_u24fqName) {
        ClassifierDescriptor classifierDescriptor = $this$checkWriteWithUsage_u24fqName.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor == null ? null : DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/android/parcel/ParcelableAnnotationChecker$Companion;", "", "()V", "IGNORED_ON_PARCEL_FQNAME", "Lorg/jetbrains/kotlin/name/FqName;", "getIGNORED_ON_PARCEL_FQNAME", "()Lorg/jetbrains/kotlin/name/FqName;", "TYPE_PARCELER_FQNAME", "getTYPE_PARCELER_FQNAME", "WRITE_WITH_FQNAME", "getWRITE_WITH_FQNAME", "android-extensions-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FqName getTYPE_PARCELER_FQNAME() {
            return TYPE_PARCELER_FQNAME;
        }

        @NotNull
        public final FqName getWRITE_WITH_FQNAME() {
            return WRITE_WITH_FQNAME;
        }

        @NotNull
        public final FqName getIGNORED_ON_PARCEL_FQNAME() {
            return IGNORED_ON_PARCEL_FQNAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

