/*
 * Decompiled with CFR 0.152.
 */
package training.util;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.TimeoutUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.io.JsonBuilderKt;
import org.jetbrains.io.JsonObjectBuilder;
import training.dsl.TaskTestContext;
import training.learn.CourseManager;
import training.learn.course.KLesson;
import training.learn.course.Lesson;
import training.learn.lesson.LessonListener;
import training.statistic.LessonStartingWay;
import training.util.LearningLessonsAutoExecutorKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Ltraining/util/LearningLessonsAutoExecutor;", "", "project", "Lcom/intellij/openapi/project/Project;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "executeLesson", "", "lesson", "Ltraining/learn/course/Lesson;", "runAllLessons", "", "", "", "runSingleLesson", "Companion", "intellij.featuresTrainer"})
public final class LearningLessonsAutoExecutor {
    @NotNull
    private final Project project;
    private final ProgressIndicator progress;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void runSingleLesson(Lesson lesson) {
        ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(this, lesson){
            final /* synthetic */ LearningLessonsAutoExecutor this$0;
            final /* synthetic */ Lesson $lesson;

            public final void invoke() {
                CourseManager.openLesson$default(CourseManager.Companion.getInstance(), this.this$0.getProject(), this.$lesson, LessonStartingWay.LEARN_TAB, false, 8, null);
            }
            {
                this.this$0 = learningLessonsAutoExecutor;
                this.$lesson = lesson;
                super(0);
            }
        }), (int)1, null);
        try {
            this.executeLesson(lesson);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        if (!lesson.getPassed$intellij_featuresTrainer()) {
            LearningLessonsAutoExecutorKt.access$getLOG$p().error("Can't pass lesson " + lesson.getName());
        }
    }

    private final Map<String, Long> runAllLessons() {
        boolean bl = false;
        Map durations = new LinkedHashMap();
        TaskTestContext.Companion.setInTestMode(true);
        List<Lesson> lessons = CourseManager.Companion.getInstance().getLessonsForModules();
        for (Lesson lesson : lessons) {
            if (!(lesson instanceof KLesson) || lesson.getTestScriptProperties().getSkipTesting() || durations.containsKey(lesson.getId())) continue;
            this.progress.checkCanceled();
            Thread.sleep(1000L);
            long duration2 = TimeoutUtil.measureExecutionTime((ThrowableRunnable)new ThrowableRunnable(this, lesson){
                final /* synthetic */ LearningLessonsAutoExecutor this$0;
                final /* synthetic */ Lesson $lesson;

                public final void run() {
                    LearningLessonsAutoExecutor.access$runSingleLesson(this.this$0, this.$lesson);
                }
                {
                    this.this$0 = learningLessonsAutoExecutor;
                    this.$lesson = lesson;
                }
            });
            durations.put(lesson.getId(), duration2);
        }
        TaskTestContext.Companion.setInTestMode(false);
        return durations;
    }

    private final void executeLesson(Lesson lesson) {
        AsyncPromise lessonPromise = new AsyncPromise();
        lesson.addLessonListener(new LessonListener(lessonPromise){
            final /* synthetic */ AsyncPromise $lessonPromise;

            public void lessonPassed(@NotNull Lesson lesson) {
                Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
                this.$lessonPromise.setResult((Object)true);
            }
            {
                this.$lessonPromise = $captured_local_variable$0;
            }

            public void lessonStarted(@NotNull Lesson lesson, @NotNull LessonStartingWay way) {
                Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
                Intrinsics.checkNotNullParameter((Object)((Object)way), (String)"way");
                LessonListener.DefaultImpls.lessonStarted(this, lesson, way);
            }

            public void lessonStopped(@NotNull Lesson lesson) {
                Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
                LessonListener.DefaultImpls.lessonStopped(this, lesson);
            }
        });
        this.progress.checkCanceled();
        Boolean passedStatus = (Boolean)lessonPromise.blockingGet(lesson.getTestScriptProperties().getDuration(), TimeUnit.SECONDS);
        if (passedStatus == null || !passedStatus.booleanValue()) {
            LearningLessonsAutoExecutorKt.access$getLOG$p().error("Can't pass lesson " + lesson.getName());
        } else {
            System.err.println("Passed " + lesson.getName());
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public LearningLessonsAutoExecutor(@NotNull Project project, @NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        this.project = project;
        this.progress = progress;
    }

    public static final /* synthetic */ void access$runSingleLesson(LearningLessonsAutoExecutor $this, Lesson lesson) {
        $this.runSingleLesson(lesson);
    }

    public static final /* synthetic */ Map access$runAllLessons(LearningLessonsAutoExecutor $this) {
        return $this.runAllLessons();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Ltraining/util/LearningLessonsAutoExecutor$Companion;", "", "()V", "getJsonStatus", "", "durations", "", "", "runAllLessons", "", "project", "Lcom/intellij/openapi/project/Project;", "runSingleLesson", "lesson", "Ltraining/learn/course/Lesson;", "intellij.featuresTrainer"})
    public static final class Companion {
        public final void runAllLessons(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String title$iv = "Running All Lessons";
            boolean cancellable$iv = true;
            boolean $i$f$runBackgroundableTask = false;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title$iv, cancellable$iv, project, title$iv, cancellable$iv, project){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $title;
                final /* synthetic */ boolean $cancellable;
                final /* synthetic */ Project $project$inlined;
                {
                    this.$project = $captured_local_variable$1;
                    this.$title = $captured_local_variable$2;
                    this.$cancellable = $captured_local_variable$3;
                    this.$project$inlined = project;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    try {
                        LearningLessonsAutoExecutor learningLessonsAutoExecutor = new LearningLessonsAutoExecutor(this.$project$inlined, it);
                        Map durations = LearningLessonsAutoExecutor.access$runAllLessons(learningLessonsAutoExecutor);
                        System.setProperty("ift.gui.result", training.util.LearningLessonsAutoExecutor$Companion.access$getJsonStatus(LearningLessonsAutoExecutor.Companion, durations));
                    }
                    finally {
                        TaskTestContext.Companion.setInTestMode(false);
                    }
                }
            });
        }

        public final void runSingleLesson(@NotNull Project project, @NotNull Lesson lesson) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
            String title$iv = "Running lesson " + lesson.getName();
            boolean cancellable$iv = true;
            boolean $i$f$runBackgroundableTask = false;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title$iv, cancellable$iv, project, title$iv, cancellable$iv, project, lesson){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $title;
                final /* synthetic */ boolean $cancellable;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ Lesson $lesson$inlined;
                {
                    this.$project = $captured_local_variable$1;
                    this.$title = $captured_local_variable$2;
                    this.$cancellable = $captured_local_variable$3;
                    this.$project$inlined = project;
                    this.$lesson$inlined = lesson;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    TaskTestContext.Companion.setInTestMode(true);
                    try {
                        LearningLessonsAutoExecutor learningLessonsAutoExecutor = new LearningLessonsAutoExecutor(this.$project$inlined, it);
                        LearningLessonsAutoExecutor.access$runSingleLesson(learningLessonsAutoExecutor, this.$lesson$inlined);
                    }
                    finally {
                        TaskTestContext.Companion.setInTestMode(false);
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final String getJsonStatus(Map<String, Long> durations) {
            void closeChar$iv$iv;
            int i$iv$iv;
            int n;
            void openChar$iv$iv;
            void this_$iv$iv;
            StringBuilder result2;
            StringBuilder $this$json$iv = result2 = new StringBuilder();
            boolean $i$f$json = false;
            JsonObjectBuilder builder$iv = new JsonObjectBuilder($this$json$iv, 0, null, 6, null);
            JsonBuilderKt.appendCommaIfNeeded((StringBuilder)$this$json$iv);
            JsonObjectBuilder jsonObjectBuilder = builder$iv;
            int n2 = 123;
            int n3 = 125;
            boolean isColonRequired$iv$iv = false;
            boolean $i$f$appendComplexValue = false;
            this_$iv$iv.getBuilder().append((char)openChar$iv$iv);
            if (this_$iv$iv.getIndent() != null) {
                this_$iv$iv.getBuilder().append('\n');
                int n4 = 1;
                n = this_$iv$iv.getIndentLevel() + 1;
                if (n4 <= n) {
                    while (true) {
                        this_$iv$iv.getBuilder().append(this_$iv$iv.getIndent());
                        if (i$iv$iv == n) break;
                        ++i$iv$iv;
                    }
                }
            }
            boolean bl = false;
            JsonObjectBuilder $this$json = builder$iv;
            boolean bl2 = false;
            $this$json.array((CharSequence)"lessons", (Function1)new Function1<JsonObjectBuilder, Unit>(result2, durations){
                final /* synthetic */ StringBuilder $result$inlined;
                final /* synthetic */ Map $durations$inlined;
                {
                    this.$result$inlined = stringBuilder;
                    this.$durations$inlined = map;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull JsonObjectBuilder $this$array) {
                    Intrinsics.checkNotNullParameter((Object)$this$array, (String)"$receiver");
                    for (Lesson lesson : CourseManager.Companion.getInstance().getLessonsForModules()) {
                        void closeChar$iv$iv;
                        int i$iv$iv;
                        int n;
                        void openChar$iv$iv;
                        void this_$iv$iv;
                        void $this$json$iv;
                        if (!(lesson instanceof KLesson) || lesson.getTestScriptProperties().getSkipTesting()) continue;
                        StringBuilder stringBuilder = this.$result$inlined;
                        JsonObjectBuilder this_$iv = $this$array;
                        boolean $i$f$json = false;
                        JsonObjectBuilder builder$iv = new JsonObjectBuilder((StringBuilder)$this$json$iv, this_$iv.getIndentLevel() + 1, null, 4, null);
                        JsonBuilderKt.appendCommaIfNeeded((StringBuilder)$this$json$iv);
                        JsonObjectBuilder jsonObjectBuilder = builder$iv;
                        int n2 = 123;
                        int n3 = 125;
                        boolean isColonRequired$iv$iv = false;
                        boolean $i$f$appendComplexValue = false;
                        this_$iv$iv.getBuilder().append((char)openChar$iv$iv);
                        if (this_$iv$iv.getIndent() != null) {
                            this_$iv$iv.getBuilder().append('\n');
                            int n4 = 1;
                            n = this_$iv$iv.getIndentLevel() + 1;
                            if (n4 <= n) {
                                while (true) {
                                    this_$iv$iv.getBuilder().append(this_$iv$iv.getIndent());
                                    if (i$iv$iv == n) break;
                                    ++i$iv$iv;
                                }
                            }
                        }
                        boolean bl = false;
                        JsonObjectBuilder $this$json = builder$iv;
                        boolean bl2 = false;
                        $this$json.to("id", lesson.getId());
                        $this$json.to("passed", lesson.getPassed$intellij_featuresTrainer());
                        $this$json.toRaw("duration", String.valueOf(this.$durations$inlined.get(lesson.getId())));
                        if (this_$iv$iv.getIndent() != null) {
                            this_$iv$iv.getBuilder().append('\n');
                            i$iv$iv = 1;
                            n = this_$iv$iv.getIndentLevel();
                            if (i$iv$iv <= n) {
                                while (true) {
                                    this_$iv$iv.getBuilder().append(this_$iv$iv.getIndent());
                                    if (i$iv$iv == n) break;
                                    ++i$iv$iv;
                                }
                            }
                        }
                        this_$iv$iv.getBuilder().append((char)closeChar$iv$iv);
                    }
                }
            });
            if (this_$iv$iv.getIndent() != null) {
                this_$iv$iv.getBuilder().append('\n');
                i$iv$iv = 1;
                n = this_$iv$iv.getIndentLevel();
                if (i$iv$iv <= n) {
                    while (true) {
                        this_$iv$iv.getBuilder().append(this_$iv$iv.getIndent());
                        if (i$iv$iv == n) break;
                        ++i$iv$iv;
                    }
                }
            }
            this_$iv$iv.getBuilder().append((char)closeChar$iv$iv);
            String string = result2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
            return string;
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$getJsonStatus(Companion $this, Map durations) {
            return $this.getJsonStatus(durations);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

