/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.DynamicBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.ChangesBrowserDialog;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTableModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceCommittedChangesProvider;
import org.jetbrains.idea.perforce.application.PerforcePanel;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.BranchSpec;
import org.jetbrains.idea.perforce.perforce.ChangeListChooser;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.ParticularConnectionSettings;
import org.jetbrains.idea.perforce.perforce.PerforceChangeList;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class ParticularConnectionPerforceIntegratePanel
implements PerforcePanel {
    private static final Logger LOG = Logger.getInstance(ParticularConnectionPerforceIntegratePanel.class);
    private final Project myProject;
    private JComboBox myBranches;
    private JComboBox myChangeLists;
    private JButton myNewChangeListButton;
    private JPanel myPanel;
    private final ChangeListChooser myChangeListChooser;
    private JCheckBox myUsingChangeList;
    private JCheckBox myIsReverse;
    private JTextArea myBranchSpecDescription;
    private JLabel myIntegrateWithChangeListLabel;
    private final P4Connection myConnection;
    private final PerforceRunner myRunner;

    public ParticularConnectionPerforceIntegratePanel(final Project project, final @NotNull P4Connection connection) {
        if (connection == null) {
            ParticularConnectionPerforceIntegratePanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myChangeListChooser = new ChangeListChooser(this.myChangeLists, this.myNewChangeListButton, project, connection);
        this.myConnection = connection;
        this.myRunner = PerforceRunner.getInstance(project);
        this.myUsingChangeList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ParticularConnectionPerforceIntegratePanel.this.myUsingChangeList.isSelected()) {
                    PerforceChangeList selectedChangeList = ParticularConnectionPerforceIntegratePanel.this.chooseChangeList(project);
                    if (selectedChangeList != null) {
                        ParticularConnectionPerforceIntegratePanel.this.myIntegrateWithChangeListLabel.setText(String.valueOf(selectedChangeList.getNumber()));
                    } else {
                        ParticularConnectionPerforceIntegratePanel.this.myIntegrateWithChangeListLabel.setText("");
                        ParticularConnectionPerforceIntegratePanel.this.myUsingChangeList.setSelected(false);
                    }
                } else {
                    ParticularConnectionPerforceIntegratePanel.this.myIntegrateWithChangeListLabel.setText("");
                }
            }
        });
        this.myBranches.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedBranchName = ParticularConnectionPerforceIntegratePanel.this.getSelectedBranchName();
                if (selectedBranchName == null) {
                    ParticularConnectionPerforceIntegratePanel.this.myBranchSpecDescription.setText(PerforceBundle.message("no.branch.spec.selected.label.text", new Object[0]));
                } else {
                    try {
                        BranchSpec branchSpec = ParticularConnectionPerforceIntegratePanel.this.myRunner.loadBranchSpec(selectedBranchName, connection);
                        ParticularConnectionPerforceIntegratePanel.this.myBranchSpecDescription.setText(ParticularConnectionPerforceIntegratePanel.composeBranchSpecText(branchSpec));
                    }
                    catch (VcsException e1) {
                        ParticularConnectionPerforceIntegratePanel.this.myBranchSpecDescription.setText(PerforceBundle.message("cannot.load.branch.spec.description.error.text", e1.getLocalizedMessage()));
                    }
                }
            }
        });
    }

    @Nullable
    private String getSelectedBranchName() {
        return (String)this.myBranches.getSelectedItem();
    }

    private PerforceChangeList chooseChangeList(Project project) {
        try {
            List<PerforceChangeList> changes = this.getChangesToIntegrate(this.getSelectedBranchName(), this.myIsReverse.isSelected());
            PerforceCommittedChangesProvider provider = PerforceVcs.getInstance(project).getCommittedChangesProvider();
            CommittedChangesTableModel model = new CommittedChangesTableModel(changes, provider.getColumns(), false);
            ChangesBrowserDialog dlg = new ChangesBrowserDialog(project, model, ChangesBrowserDialog.Mode.Choose, null);
            return dlg.showAndGet() ? (PerforceChangeList)dlg.getSelectedChangeList() : null;
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @VisibleForTesting
    public List<PerforceChangeList> getChangesToIntegrate(String branchName, boolean reverse) throws VcsException {
        List<String> fileSpecs = branchName != null ? this.myRunner.getBranchViews(branchName, reverse, this.myConnection) : Collections.singletonList(P4File.create(this.myProject.getBaseDir()).getRecursivePath());
        return this.myRunner.getSubmittedChangeLists(this.myConnection, null, null, -1, false, fileSpecs);
    }

    private static String composeBranchSpecText(BranchSpec branchSpec) {
        StringBuilder result = new StringBuilder();
        result.append(branchSpec.getDescription());
        result.append(" (");
        result.append(PerforceBundle.message("configure.integrate.branch.spec.description.part.created.by", branchSpec.getOwner()));
        result.append(")");
        result.append("\n");
        for (String view : branchSpec.getViews()) {
            result.append("\n");
            result.append(view);
        }
        return result.toString();
    }

    @Override
    public void updateFrom(PerforceSettings settings) {
        this.myBranches.removeAllItems();
        ParticularConnectionSettings connectionSettings = settings.getSettings(this.myConnection);
        try {
            List<String> branches = this.myRunner.getBranches(this.myConnection);
            for (String branch : branches) {
                this.myBranches.addItem(branch);
            }
            this.myBranches.setSelectedItem(connectionSettings.INTEGRATE_BRANCH_NAME);
            if (this.myBranches.getSelectedIndex() < 0 && this.myBranches.getItemCount() > 0) {
                this.myBranches.setSelectedIndex(0);
            }
        }
        catch (VcsException e) {
            Messages.showErrorDialog((String)PerforceBundle.message("integrate.configurable.cannot.load.branches.error.message", e.getLocalizedMessage()), (String)PerforceBundle.message("integrate.configurable.load.branches.dialog.title", new Object[0]));
        }
        try {
            this.myChangeListChooser.fillChangeLists(this.myRunner.getPendingChangeLists(this.myConnection), 0L);
        }
        catch (VcsException e1) {
            Messages.showErrorDialog((String)PerforceBundle.message("message.text.cannot.load.changes", e1.getLocalizedMessage()), (String)PerforceBundle.message("message.title.refresh.changes", new Object[0]));
        }
        this.myUsingChangeList.setSelected(false);
        this.myIsReverse.setSelected(connectionSettings.INTEGRATE_REVERSE);
        this.myIntegrateWithChangeListLabel.setText("");
    }

    @Override
    public void applyTo(PerforceSettings settings) throws ConfigurationException {
        if (this.myBranches.getSelectedItem() == null) {
            throw new ConfigurationException(PerforceBundle.message("configure.integrate.branchspec.none.selected", new Object[0]));
        }
        ParticularConnectionSettings connectionSettings = settings.getSettings(this.myConnection);
        connectionSettings.INTEGRATE_BRANCH_NAME = (String)this.myBranches.getSelectedItem();
        connectionSettings.INTEGRATE_TO_CHANGELIST_NUM = this.myChangeListChooser.getChangeListNumber();
        connectionSettings.INTEGRATED_CHANGE_LIST_NUMBER = this.myIntegrateWithChangeListLabel.getText();
        connectionSettings.INTEGRATE_CHANGE_LIST = this.myUsingChangeList.isSelected();
        connectionSettings.INTEGRATE_REVERSE = this.myIsReverse.isSelected();
    }

    @Override
    public boolean isModified(PerforceSettings settings) {
        ParticularConnectionSettings connectionSettings = settings.getSettings(this.myConnection);
        return !Objects.equals(connectionSettings.INTEGRATE_BRANCH_NAME, this.myBranches.getSelectedItem()) || connectionSettings.INTEGRATE_TO_CHANGELIST_NUM != this.myChangeListChooser.getChangeListNumber() || !Objects.equals(connectionSettings.INTEGRATED_CHANGE_LIST_NUMBER, this.myIntegrateWithChangeListLabel.getText()) || connectionSettings.INTEGRATE_CHANGE_LIST != this.myUsingChangeList.isSelected() || connectionSettings.INTEGRATE_REVERSE != this.myIsReverse.isSelected();
    }

    @Override
    public JPanel getPanel() {
        return this.myPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/application/ParticularConnectionPerforceIntegratePanel", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JCheckBox jCheckBox;
        JButton jButton;
        JComboBox jComboBox;
        JTextArea jTextArea;
        JCheckBox jCheckBox2;
        JComboBox jComboBox2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/PerforceBundle", ParticularConnectionPerforceIntegratePanel.class).getString("configure.integrate.branch.spec.title"), (int)0, (int)0, null, null));
        this.myBranches = jComboBox2 = new JComboBox();
        jPanel2.add(jComboBox2, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myIsReverse = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/PerforceBundle", ParticularConnectionPerforceIntegratePanel.class).getString("configure.integrate.reverse.checkbox"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setEnabled(true);
        jBScrollPane.setWheelScrollingEnabled(true);
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 7, new Dimension(-1, 100), null, null));
        this.myBranchSpecDescription = jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jBScrollPane.setViewportView(jTextArea);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/PerforceBundle", ParticularConnectionPerforceIntegratePanel.class).getString("configure.integrate.store.changes.to.change.list.group.title"), (int)0, (int)0, null, null));
        this.myChangeLists = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myNewChangeListButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/PerforceBundle", ParticularConnectionPerforceIntegratePanel.class).getString("button.text.new"));
        jPanel4.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUsingChangeList = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PerforceBundle", ParticularConnectionPerforceIntegratePanel.class).getString("configure.integrate.integrate.change.list.label"));
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIntegrateWithChangeListLabel = jLabel = new JLabel();
        jLabel.setText("###");
        jPanel5.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

