/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.ide.ui.IdeUiService;
import com.intellij.internal.statistic.eventLog.connection.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.connection.request.StatsProxyInfo;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogAppConnectionSettings
implements EventLogConnectionSettings {
    private static final StatsProxyInfo NO_PROXY = new StatsProxyInfo(Proxy.NO_PROXY, null);

    @Override
    @NotNull
    public String getUserAgent() {
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isDisposed()) {
            String productName = ApplicationNamesInfo.getInstance().getFullProductName();
            String version = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
            String string = productName + "/" + version;
            if (string == null) {
                EventLogAppConnectionSettings.$$$reportNull$$$0(0);
            }
            return string;
        }
        return "IntelliJ";
    }

    @Override
    @NotNull
    public StatsProxyInfo selectProxy(@NotNull String url) {
        Proxy proxy;
        Application app;
        if (url == null) {
            EventLogAppConnectionSettings.$$$reportNull$$$0(1);
        }
        if ((app = ApplicationManager.getApplication()) != null && !app.isDisposed() && (proxy = EventLogAppConnectionSettings.findProxy(url)) != Proxy.NO_PROXY) {
            return new StatsProxyInfo(proxy, EventLogAppConnectionSettings.getAuthProvider());
        }
        StatsProxyInfo statsProxyInfo = NO_PROXY;
        if (statsProxyInfo == null) {
            EventLogAppConnectionSettings.$$$reportNull$$$0(2);
        }
        return statsProxyInfo;
    }

    @Override
    @Nullable
    public SSLContext getSSLContext() {
        return IdeUiService.getInstance().getSslContext();
    }

    @Nullable
    private static StatsProxyInfo.StatsProxyAuthProvider getAuthProvider() {
        if (IdeUiService.getInstance().isProxyAuth()) {
            return EventLogAppProxyAuth.INSTANCE;
        }
        return null;
    }

    @NotNull
    private static Proxy findProxy(@NotNull String url) {
        Proxy proxy;
        if (url == null) {
            EventLogAppConnectionSettings.$$$reportNull$$$0(3);
        }
        try {
            List proxies = IdeUiService.getInstance().getProxyList(new URL(url));
            proxy = !proxies.isEmpty() ? (Proxy)proxies.get(0) : Proxy.NO_PROXY;
        }
        catch (MalformedURLException malformedURLException) {
            Proxy proxy2 = Proxy.NO_PROXY;
            if (proxy2 == null) {
                EventLogAppConnectionSettings.$$$reportNull$$$0(5);
            }
            return proxy2;
        }
        if (proxy == null) {
            EventLogAppConnectionSettings.$$$reportNull$$$0(4);
        }
        return proxy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/EventLogAppConnectionSettings";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserAgent";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogAppConnectionSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "selectProxy";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findProxy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectProxy";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findProxy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EventLogAppProxyAuth
    implements StatsProxyInfo.StatsProxyAuthProvider {
        private static final EventLogAppProxyAuth INSTANCE = new EventLogAppProxyAuth();

        private EventLogAppProxyAuth() {
        }

        @Override
        @Nullable
        public String getProxyLogin() {
            return IdeUiService.getInstance().getProxyLogin();
        }

        @Override
        @Nullable
        public String getProxyPassword() {
            return IdeUiService.getInstance().getPlainProxyPassword();
        }
    }
}

