/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.local;

import com.intellij.internal.statistic.local.ActionExtendedSummary;
import com.intellij.internal.statistic.local.ActionSummary;
import com.intellij.internal.statistic.local.ActionsLocalSummary;
import com.intellij.internal.statistic.local.ActionsLocalSummaryState;
import com.intellij.internal.statistic.local.ActionsTotalSummary;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SimpleModificationTracker;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ActionsLocalSummary", storages={@Storage(value="actionSummary.xml", roamingType=RoamingType.DISABLED)}, reportStatistic=false)
@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0002H\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000eJ\b\u0010\u0010\u001a\u00020\u0002H\u0016J\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0002H\u0016J\u001d\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0016R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/internal/statistic/local/ActionsLocalSummary;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/internal/statistic/local/ActionsLocalSummaryState;", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "()V", "state", "totalSummary", "Lcom/intellij/internal/statistic/local/ActionsTotalSummary;", "calculateTotalSummary", "getActionStatsById", "Lcom/intellij/internal/statistic/local/ActionExtendedSummary;", "actionId", "", "getActionsStats", "", "Lcom/intellij/internal/statistic/local/ActionSummary;", "getState", "getTotalStats", "loadState", "", "updateActionsSummary", "place", "updateActionsSummary$intellij_platform_statistics", "intellij.platform.statistics"})
public final class ActionsLocalSummary
extends SimpleModificationTracker
implements PersistentStateComponent<ActionsLocalSummaryState> {
    private volatile ActionsLocalSummaryState state = new ActionsLocalSummaryState(null, 1, null);
    private volatile ActionsTotalSummary totalSummary = new ActionsTotalSummary(0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);

    @NotNull
    public ActionsLocalSummaryState getState() {
        return this.state;
    }

    public void loadState(@NotNull ActionsLocalSummaryState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
        this.totalSummary = this.calculateTotalSummary(state);
    }

    private final ActionsTotalSummary calculateTotalSummary(ActionsLocalSummaryState state) {
        int maxUsageCount = 0;
        int maxUsageCountFromSe = 0;
        int minUsageCount = Integer.MAX_VALUE;
        int minUsageCountFromSe = Integer.MAX_VALUE;
        for (ActionExtendedSummary value : state.getData$intellij_platform_statistics().values()) {
            int n = value.usageCount;
            boolean bl = false;
            maxUsageCount = Math.max(maxUsageCount, n);
            n = value.usageCount;
            bl = false;
            minUsageCount = Math.min(minUsageCount, n);
            n = value.usageFromSearchEverywhere;
            bl = false;
            maxUsageCountFromSe = Math.max(maxUsageCountFromSe, n);
            n = value.usageFromSearchEverywhere;
            bl = false;
            minUsageCountFromSe = Math.min(minUsageCountFromSe, n);
        }
        return new ActionsTotalSummary(maxUsageCount, minUsageCount, maxUsageCountFromSe, minUsageCountFromSe);
    }

    @NotNull
    public final synchronized ActionsTotalSummary getTotalStats() {
        return this.totalSummary;
    }

    @NotNull
    public final synchronized Map<String, ActionSummary> getActionsStats() {
        if (this.state.getData$intellij_platform_statistics().isEmpty()) {
            return MapsKt.emptyMap();
        }
        boolean bl = false;
        HashMap result = new HashMap();
        Map<String, ActionExtendedSummary> map = this.state.getData$intellij_platform_statistics();
        boolean bl2 = false;
        for (Map.Entry<String, ActionExtendedSummary> datum : map.entrySet()) {
            ActionSummary summary2 = new ActionSummary();
            summary2.usageCount = datum.getValue().usageCount;
            summary2.lastUsedTimestamp = datum.getValue().lastUsedTimestamp;
            ((Map)result).put(datum.getKey(), summary2);
        }
        return result;
    }

    @Nullable
    public final synchronized ActionExtendedSummary getActionStatsById(@NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        return this.state.getData$intellij_platform_statistics().get(actionId);
    }

    public final synchronized void updateActionsSummary$intellij_platform_statistics(@NotNull String actionId, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        boolean isFromSearchEverywhere = Intrinsics.areEqual((Object)place, (Object)"GoToAction");
        ActionExtendedSummary actionExtendedSummary = this.state.getData$intellij_platform_statistics().computeIfAbsent(actionId, updateActionsSummary.summary.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)actionExtendedSummary, (String)"state.data.computeIfAbse\u2026ActionExtendedSummary() }");
        ActionExtendedSummary summary2 = actionExtendedSummary;
        summary2.incrementUsage(isFromSearchEverywhere);
        this.totalSummary.updateUsage(summary2, isFromSearchEverywhere);
        this.incModificationCount();
    }
}

