/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.EventListener;
import java.util.function.BiConsumer;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.github.api.GHRequestExecutorBreaker;
import org.jetbrains.plugins.github.api.GithubApiContentHelper;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiResponse;
import org.jetbrains.plugins.github.api.data.GithubErrorMessage;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubConfusingException;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;
import org.jetbrains.plugins.github.exceptions.GithubRateLimitExceededException;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.util.GithubSettings;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001a2\u00020\u0001:\u0006\u0018\u0019\u001a\u001b\u001c\u001dB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ)\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0015H'\u00a2\u0006\u0002\u0010\u0016J!\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0015H\u0007\u00a2\u0006\u0002\u0010\u0017R'\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u0082\u0001\u0001\u001e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "", "()V", "authDataChangedEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$AuthDataChangeListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getAuthDataChangedEventDispatcher", "()Lcom/intellij/util/EventDispatcher;", "addListener", "", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "Lkotlin/Function0;", "execute", "T", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "request", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lorg/jetbrains/plugins/github/api/GithubApiRequest;)Ljava/lang/Object;", "(Lorg/jetbrains/plugins/github/api/GithubApiRequest;)Ljava/lang/Object;", "AuthDataChangeListener", "Base", "Companion", "Factory", "NoAuth", "WithTokenAuth", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Base;", "intellij.vcs.github"})
public abstract class GithubApiRequestExecutor {
    @NotNull
    private final EventDispatcher<AuthDataChangeListener> authDataChangedEventDispatcher;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    protected final EventDispatcher<AuthDataChangeListener> getAuthDataChangedEventDispatcher() {
        return this.authDataChangedEventDispatcher;
    }

    @RequiresBackgroundThread
    public abstract <T> T execute(@NotNull ProgressIndicator var1, @NotNull GithubApiRequest<? extends T> var2) throws IOException, ProcessCanceledException;

    @TestOnly
    @RequiresBackgroundThread
    public final <T> T execute(@NotNull GithubApiRequest<? extends T> request) throws IOException, ProcessCanceledException {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        return this.execute((ProgressIndicator)new EmptyProgressIndicator(), request);
    }

    public final void addListener(@NotNull AuthDataChangeListener listener2, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.authDataChangedEventDispatcher.addListener((EventListener)listener2, disposable);
    }

    public final void addListener(@NotNull Disposable disposable, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.authDataChangedEventDispatcher.addListener((EventListener)new AuthDataChangeListener(listener2){
            final /* synthetic */ Function0 $listener;

            public void authDataChanged() {
                this.$listener.invoke();
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        }, disposable);
    }

    private GithubApiRequestExecutor() {
        EventDispatcher eventDispatcher = EventDispatcher.create(AuthDataChangeListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"EventDispatcher.create(A\u2026angeListener::class.java)");
        this.authDataChangedEventDispatcher = eventDispatcher;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GithubApiRequestExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public /* synthetic */ GithubApiRequestExecutor(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ)\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$WithTokenAuth;", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Base;", "githubSettings", "Lorg/jetbrains/plugins/github/util/GithubSettings;", "token", "", "useProxy", "", "(Lorg/jetbrains/plugins/github/util/GithubSettings;Ljava/lang/String;Z)V", "value", "getToken$intellij_vcs_github", "()Ljava/lang/String;", "setToken$intellij_vcs_github", "(Ljava/lang/String;)V", "execute", "T", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "request", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lorg/jetbrains/plugins/github/api/GithubApiRequest;)Ljava/lang/Object;", "intellij.vcs.github"})
    public static final class WithTokenAuth
    extends Base {
        @NotNull
        private volatile String token;
        private final boolean useProxy;

        @NotNull
        public final String getToken$intellij_vcs_github() {
            return this.token;
        }

        public final void setToken$intellij_vcs_github(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.token = value;
            ((AuthDataChangeListener)this.getAuthDataChangedEventDispatcher().getMulticaster()).authDataChanged();
        }

        @Override
        public <T> T execute(@NotNull ProgressIndicator indicator, @NotNull GithubApiRequest<? extends T> request) throws IOException, ProcessCanceledException {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Intrinsics.checkNotNullParameter(request, (String)"request");
            boolean $i$f$service = false;
            Class<GHRequestExecutorBreaker> serviceClass$iv = GHRequestExecutorBreaker.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            if (((GHRequestExecutorBreaker)object).isRequestsShouldFail()) {
                String string = "Request failure was triggered by user action. This a pretty long description of this failure that should resemble some long error which can go out of bounds.";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            indicator.checkCanceled();
            RequestBuilder requestBuilder = this.createRequestBuilder(request).tuner(new HttpRequests.ConnectionTuner(this, request){
                final /* synthetic */ WithTokenAuth this$0;
                final /* synthetic */ GithubApiRequest $request;

                public final void tune(@NotNull URLConnection connection) {
                    Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                    Function2 function2 = (Function2)new Function2<String, String, Unit>(connection){

                        public final void invoke(String p1, String p2) {
                            ((URLConnection)this.receiver).addRequestProperty(p1, p2);
                        }
                    };
                    this.$request.getAdditionalHeaders().forEach(new BiConsumer(function2){
                        private final /* synthetic */ Function2 function;
                        {
                            this.function = function2;
                        }

                        public final /* synthetic */ void accept(Object p0, Object p1) {
                            Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0, p1), (String)"invoke(...)");
                        }
                    });
                    connection.addRequestProperty("Authorization", "Bearer " + this.this$0.getToken$intellij_vcs_github());
                }
                {
                    this.this$0 = withTokenAuth;
                    this.$request = githubApiRequest;
                }
            }).useProxy(this.useProxy);
            Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"createRequestBuilder(req\u2026      .useProxy(useProxy)");
            return this.execute(requestBuilder, request, indicator);
        }

        public WithTokenAuth(@NotNull GithubSettings githubSettings, @NotNull String token, boolean useProxy) {
            Intrinsics.checkNotNullParameter((Object)githubSettings, (String)"githubSettings");
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            super(githubSettings);
            this.useProxy = useProxy;
            this.token = token;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$NoAuth;", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Base;", "githubSettings", "Lorg/jetbrains/plugins/github/util/GithubSettings;", "(Lorg/jetbrains/plugins/github/util/GithubSettings;)V", "execute", "T", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "request", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lorg/jetbrains/plugins/github/api/GithubApiRequest;)Ljava/lang/Object;", "intellij.vcs.github"})
    public static final class NoAuth
    extends Base {
        @Override
        public <T> T execute(@NotNull ProgressIndicator indicator, @NotNull GithubApiRequest<? extends T> request) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Intrinsics.checkNotNullParameter(request, (String)"request");
            indicator.checkCanceled();
            RequestBuilder requestBuilder = this.createRequestBuilder(request).tuner(new HttpRequests.ConnectionTuner(request){
                final /* synthetic */ GithubApiRequest $request;

                public final void tune(@NotNull URLConnection connection) {
                    Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                    Function2 function2 = (Function2)new Function2<String, String, Unit>(connection){

                        public final void invoke(String p1, String p2) {
                            ((URLConnection)this.receiver).addRequestProperty(p1, p2);
                        }
                    };
                    this.$request.getAdditionalHeaders().forEach(new /* invalid duplicate definition of identical inner class */);
                }
                {
                    this.$request = githubApiRequest;
                }
            }).useProxy(true);
            Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"createRequestBuilder(req\u2026}\n        .useProxy(true)");
            return this.execute(requestBuilder, request, indicator);
        }

        public NoAuth(@NotNull GithubSettings githubSettings) {
            Intrinsics.checkNotNullParameter((Object)githubSettings, (String)"githubSettings");
            super(githubSettings);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J-\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u0018*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00180\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Base;", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "githubSettings", "Lorg/jetbrains/plugins/github/util/GithubSettings;", "(Lorg/jetbrains/plugins/github/util/GithubSettings;)V", "checkResponseCode", "", "connection", "Ljava/net/HttpURLConnection;", "createRequestBuilder", "Lcom/intellij/util/io/RequestBuilder;", "request", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "createResponse", "Lorg/jetbrains/plugins/github/api/GithubApiResponse;", "Lcom/intellij/util/io/HttpRequests$Request;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getErrorText", "", "getJsonError", "Lorg/jetbrains/plugins/github/api/data/GithubErrorMessage;", "errorText", "execute", "T", "(Lcom/intellij/util/io/RequestBuilder;Lorg/jetbrains/plugins/github/api/GithubApiRequest;Lcom/intellij/openapi/progress/ProgressIndicator;)Ljava/lang/Object;", "intellij.vcs.github"})
    public static abstract class Base
    extends GithubApiRequestExecutor {
        private final GithubSettings githubSettings;

        protected final <T> T execute(@NotNull RequestBuilder $this$execute, @NotNull GithubApiRequest<? extends T> request, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"$this$execute");
            Intrinsics.checkNotNullParameter(request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            indicator.checkCanceled();
            try {
                LOG.debug("Request: " + request.getUrl() + ' ' + request.getOperationName() + " : Connecting");
                return (T)$this$execute.connect(new HttpRequests.RequestProcessor(this, request, indicator){
                    final /* synthetic */ Base this$0;
                    final /* synthetic */ GithubApiRequest $request;
                    final /* synthetic */ ProgressIndicator $indicator;

                    public final T process(@NotNull HttpRequests.Request it) {
                        String string;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        URLConnection uRLConnection = it.getConnection();
                        if (uRLConnection == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
                        }
                        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
                        if (this.$request instanceof GithubApiRequest.WithBody) {
                            GithubApiRequestExecutor.access$getLOG$cp().debug("Request: " + connection.getRequestMethod() + ' ' + connection.getURL() + " with body:\n" + ((GithubApiRequest.WithBody)this.$request).getBody() + " : Connected");
                            String string2 = ((GithubApiRequest.WithBody)this.$request).getBody();
                            if (string2 != null) {
                                string = string2;
                                boolean bl = false;
                                boolean bl2 = false;
                                String body2 = string;
                                boolean bl3 = false;
                                it.write(body2);
                            }
                        } else {
                            GithubApiRequestExecutor.access$getLOG$cp().debug("Request: " + connection.getRequestMethod() + ' ' + connection.getURL() + " : Connected");
                        }
                        Base.access$checkResponseCode(this.this$0, connection);
                        this.$indicator.checkCanceled();
                        T result = this.$request.extractResult(Base.access$createResponse(this.this$0, it, this.$indicator));
                        GithubApiRequestExecutor.access$getLOG$cp().debug("Request: " + connection.getRequestMethod() + ' ' + connection.getURL() + " : Result extracted");
                        return (T)string;
                    }
                    {
                        this.this$0 = base;
                        this.$request = githubApiRequest;
                        this.$indicator = progressIndicator;
                    }
                });
            }
            catch (GithubStatusCodeException e) {
                if (request instanceof GithubApiRequest.Get.Optional && e.getStatusCode() == 404) {
                    return null;
                }
                throw (Throwable)e;
            }
            catch (GithubConfusingException e) {
                if (request.getOperationName() != null) {
                    String errorText = "Can't " + request.getOperationName();
                    e.setDetails(errorText);
                    LOG.debug(errorText, (Throwable)e);
                }
                throw (Throwable)e;
            }
        }

        @NotNull
        protected final RequestBuilder createRequestBuilder(@NotNull GithubApiRequest<?> request) {
            RequestBuilder requestBuilder;
            Intrinsics.checkNotNullParameter(request, (String)"request");
            GithubApiRequest<?> githubApiRequest = request;
            if (githubApiRequest instanceof GithubApiRequest.Get) {
                requestBuilder = HttpRequests.request((String)request.getUrl());
            } else if (githubApiRequest instanceof GithubApiRequest.Patch) {
                requestBuilder = HttpRequests.patch((String)request.getUrl(), (String)((GithubApiRequest.Patch)request).getBodyMimeType());
            } else if (githubApiRequest instanceof GithubApiRequest.Post) {
                requestBuilder = HttpRequests.post((String)request.getUrl(), (String)((GithubApiRequest.Post)request).getBodyMimeType());
            } else if (githubApiRequest instanceof GithubApiRequest.Put) {
                requestBuilder = HttpRequests.put((String)request.getUrl(), (String)((GithubApiRequest.Put)request).getBodyMimeType());
            } else if (githubApiRequest instanceof GithubApiRequest.Head) {
                requestBuilder = HttpRequests.head((String)request.getUrl());
            } else if (githubApiRequest instanceof GithubApiRequest.Delete) {
                requestBuilder = ((GithubApiRequest.Delete)request).getBody() == null ? HttpRequests.delete((String)request.getUrl()) : HttpRequests.delete((String)request.getUrl(), (String)((GithubApiRequest.Delete)request).getBodyMimeType());
            } else {
                throw (Throwable)new UnsupportedOperationException(request.getClass() + " is not supported");
            }
            RequestBuilder requestBuilder2 = requestBuilder.connectTimeout(this.githubSettings.getConnectionTimeout()).userAgent("Intellij IDEA Github Plugin").throwStatusCodeException(false).forceHttps(false).accept(request.getAcceptMimeType());
            Intrinsics.checkNotNullExpressionValue((Object)requestBuilder2, (String)"when (request) {\n       \u2026t(request.acceptMimeType)");
            return requestBuilder2;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final void checkResponseCode(HttpURLConnection connection) throws IOException {
            Throwable throwable;
            GithubErrorMessage jsonError;
            GithubErrorMessage githubErrorMessage;
            GithubErrorMessage githubErrorMessage2;
            if (connection.getResponseCode() < 400) {
                return;
            }
            String statusLine = "" + connection.getResponseCode() + ' ' + connection.getResponseMessage();
            String errorText = this.getErrorText(connection);
            LOG.debug("Request: " + connection.getRequestMethod() + ' ' + connection.getURL() + " : Error " + statusLine + " body:\n" + errorText);
            String string = errorText;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                githubErrorMessage2 = this.getJsonError(connection, it);
            } else {
                githubErrorMessage2 = null;
            }
            if ((githubErrorMessage = (jsonError = githubErrorMessage2)) == null) {
                LOG.debug("Request: " + connection.getRequestMethod() + ' ' + connection.getURL() + " : Unable to parse JSON error");
                githubErrorMessage = Unit.INSTANCE;
            }
            switch (connection.getResponseCode()) {
                case 401: 
                case 402: 
                case 403: {
                    IOException iOException;
                    GithubErrorMessage githubErrorMessage3 = jsonError;
                    if (githubErrorMessage3 != null && githubErrorMessage3.containsReasonMessage("API rate limit exceeded")) {
                        iOException = new GithubRateLimitExceededException(jsonError.getPresentableError());
                    } else {
                        Object object;
                        StringBuilder stringBuilder = new StringBuilder().append("Request response: ");
                        Object object2 = jsonError;
                        if (object2 == null || (object2 = ((GithubErrorMessage)object2).getPresentableError()) == null) {
                            object2 = object = errorText;
                        }
                        if (object2 == null) {
                            object = statusLine;
                        }
                        iOException = new GithubAuthenticationException(stringBuilder.append((String)object).toString());
                    }
                    throwable = iOException;
                    throw throwable;
                }
            }
            throwable = jsonError != null ? new GithubStatusCodeException(statusLine + " - " + jsonError.getPresentableError(), jsonError, connection.getResponseCode()) : new GithubStatusCodeException(statusLine + " - " + errorText, connection.getResponseCode());
            throw throwable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String getErrorText(HttpURLConnection connection) {
            String string;
            InputStream inputStream = connection.getErrorStream();
            if (inputStream == null) {
                return null;
            }
            InputStream errorStream = inputStream;
            InputStream stream = Intrinsics.areEqual((Object)connection.getContentEncoding(), (Object)"gzip") ? (InputStream)new GZIPInputStream(errorStream) : errorStream;
            Closeable closeable = new InputStreamReader(stream, Charsets.UTF_8);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStreamReader it = (InputStreamReader)closeable;
                boolean bl3 = false;
                string = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return string;
        }

        private final GithubErrorMessage getJsonError(HttpURLConnection connection, String errorText) {
            String string = connection.getContentType();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"connection.contentType");
            if (!StringsKt.startsWith$default((String)string, (String)"application/json", (boolean)false, (int)2, null)) {
                return null;
            }
            try {
                GithubApiContentHelper this_$iv = GithubApiContentHelper.INSTANCE;
                boolean $i$f$fromJson = false;
                return (GithubErrorMessage)GithubApiContentHelper.fromJson$default(errorText, GithubErrorMessage.class, false, 4, null);
            }
            catch (GithubJsonException jse) {
                GithubErrorMessage githubErrorMessage = null;
                return githubErrorMessage;
            }
        }

        private final GithubApiResponse createResponse(HttpRequests.Request request, ProgressIndicator indicator) {
            return new GithubApiResponse(request, indicator){
                final /* synthetic */ HttpRequests.Request $request;
                final /* synthetic */ ProgressIndicator $indicator;

                @Nullable
                public String findHeader(@NotNull String headerName) {
                    Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
                    return this.$request.getConnection().getHeaderField(headerName);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public <T> T readBody(@NotNull ThrowableConvertor<Reader, T, IOException> converter) {
                    Object object;
                    Intrinsics.checkNotNullParameter(converter, (String)"converter");
                    Closeable closeable = this.$request.getReader(this.$indicator);
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        BufferedReader it = (BufferedReader)closeable;
                        boolean bl3 = false;
                        object = converter.convert((Object)it);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    return (T)object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public <T> T handleBody(@NotNull ThrowableConvertor<InputStream, T, IOException> converter) {
                    Object object;
                    Intrinsics.checkNotNullParameter(converter, (String)"converter");
                    Closeable closeable = this.$request.getInputStream();
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl3 = false;
                        object = converter.convert((Object)it);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    return (T)object;
                }
                {
                    this.$request = $captured_local_variable$0;
                    this.$indicator = $captured_local_variable$1;
                }
            };
        }

        public Base(@NotNull GithubSettings githubSettings) {
            Intrinsics.checkNotNullParameter((Object)githubSettings, (String)"githubSettings");
            super(null);
            this.githubSettings = githubSettings;
        }

        public static final /* synthetic */ void access$checkResponseCode(Base $this, HttpURLConnection connection) {
            $this.checkResponseCode(connection);
        }

        public static final /* synthetic */ GithubApiResponse access$createResponse(Base $this, HttpRequests.Request request, ProgressIndicator indicator) {
            return $this.createResponse(request, indicator);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0003\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0003\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "", "()V", "create", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$NoAuth;", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$WithTokenAuth;", "token", "", "useProxy", "", "Companion", "intellij.vcs.github"})
    public static final class Factory {
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final WithTokenAuth create(@NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return this.create(token, true);
        }

        @NotNull
        public final WithTokenAuth create(@NotNull String token, boolean useProxy) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            GithubSettings githubSettings = GithubSettings.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)githubSettings, (String)"GithubSettings.getInstance()");
            return new WithTokenAuth(githubSettings, token, useProxy);
        }

        public static /* synthetic */ WithTokenAuth create$default(Factory factory2, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return factory2.create(string, bl);
        }

        @NotNull
        public final NoAuth create() {
            GithubSettings githubSettings = GithubSettings.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)githubSettings, (String)"GithubSettings.getInstance()");
            return new NoAuth(githubSettings);
        }

        @JvmStatic
        @NotNull
        public static final Factory getInstance() {
            return Companion.getInstance();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "intellij.vcs.github"})
        public static final class Companion {
            @JvmStatic
            @NotNull
            public final Factory getInstance() {
                boolean $i$f$service = false;
                Class<Factory> serviceClass$iv = Factory.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                }
                return (Factory)object;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$AuthDataChangeListener;", "Ljava/util/EventListener;", "authDataChanged", "", "intellij.vcs.github"})
    public static interface AuthDataChangeListener
    extends EventListener {
        public void authDataChanged();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

