/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.collaboration.auth.AccountsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/extensions/GHGitAuthenticationFailureManager;", "Lcom/intellij/openapi/Disposable;", "()V", "storeMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "", "", "dispose", "", "ignoreAccount", "url", "account", "isAccountIgnored", "", "intellij.vcs.github"})
public final class GHGitAuthenticationFailureManager
implements Disposable {
    private final ConcurrentHashMap<GithubAccount, Set<String>> storeMap = new ConcurrentHashMap();

    public final void ignoreAccount(@NotNull String url, @NotNull GithubAccount account) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        this.storeMap.compute(account, new BiFunction(url){
            final /* synthetic */ String $url;

            @Nullable
            public final Set<String> apply(@NotNull GithubAccount $noName_0, @Nullable Set<String> current) {
                Intrinsics.checkNotNullParameter((Object)((Object)$noName_0), (String)"<anonymous parameter 0>");
                Set set = current;
                if (set == null || (set = SetsKt.plus(set, (Object)this.$url)) == null) {
                    set = SetsKt.setOf((Object)this.$url);
                }
                return set;
            }
            {
                this.$url = string;
            }
        });
    }

    public final boolean isAccountIgnored(@NotNull String url, @NotNull GithubAccount account) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Set<String> set = this.storeMap.get((Object)account);
        return set != null ? set.contains(url) : false;
    }

    public void dispose() {
        this.storeMap.clear();
    }

    public GHGitAuthenticationFailureManager() {
        boolean $i$f$service = false;
        Class<GHAccountManager> serviceClass$iv = GHAccountManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        ((GHAccountManager)((Object)object)).addListener(this, (AccountsListener)new AccountsListener<GithubAccount>(){

            public void onAccountCredentialsChanged(@NotNull GithubAccount account) {
                Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
                storeMap.remove((Object)account);
            }

            public void onAccountListChanged(@NotNull Collection<GithubAccount> old, @NotNull Collection<GithubAccount> collection) {
                Intrinsics.checkNotNullParameter(old, (String)"old");
                Intrinsics.checkNotNullParameter(collection, (String)"new");
                AccountsListener.DefaultImpls.onAccountListChanged((AccountsListener)this, old, collection);
            }
        });
    }
}

