/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.data.request.search.GithubIssueSearchSort;
import org.jetbrains.plugins.github.api.util.GithubApiSearchQueryBuilder;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0003\u0012\u0013\u0014B\u0017\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery;", "", "terms", "", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "(Ljava/util/List;)V", "buildApiSearchQuery", "", "searchQueryBuilder", "Lorg/jetbrains/plugins/github/api/util/GithubApiSearchQueryBuilder;", "equals", "", "other", "hashCode", "", "isEmpty", "toString", "", "Companion", "QualifierName", "Term", "intellij.vcs.github"})
public final class GHPRSearchQuery {
    private final List<Term<?>> terms;
    @NotNull
    private static final GHPRSearchQuery DEFAULT;
    @NotNull
    private static final GHPRSearchQuery EMPTY;
    private static final SimpleDateFormat DATE_FORMAT;
    @NotNull
    public static final Companion Companion;

    public final void buildApiSearchQuery(@NotNull GithubApiSearchQueryBuilder searchQueryBuilder) {
        Intrinsics.checkNotNullParameter((Object)searchQueryBuilder, (String)"searchQueryBuilder");
        for (Term<?> term : this.terms) {
            Term<?> term2 = term;
            if (term2 instanceof Term.QueryPart) {
                searchQueryBuilder.query(((Term.QueryPart)term).getApiValue());
                continue;
            }
            if (!(term2 instanceof Term.Qualifier)) continue;
            searchQueryBuilder.qualifier(((Term.Qualifier)term).getApiName(), term.getApiValue());
        }
    }

    public final boolean isEmpty() {
        return this.terms.isEmpty();
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.terms, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHPRSearchQuery)) {
            return false;
        }
        return !(Intrinsics.areEqual(this.terms, ((GHPRSearchQuery)other).terms) ^ true);
    }

    public int hashCode() {
        return ((Object)this.terms).hashCode();
    }

    public GHPRSearchQuery(@NotNull List<? extends Term<?>> terms) {
        Intrinsics.checkNotNullParameter(terms, (String)"terms");
        this.terms = terms;
    }

    static {
        Companion = new Companion(null);
        DEFAULT = new GHPRSearchQuery(CollectionsKt.listOf(new Term.Qualifier.Enum<Enum>(QualifierName.state, GithubIssueState.open)));
        boolean bl = false;
        EMPTY = new GHPRSearchQuery(CollectionsKt.emptyList());
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\u0003H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "", "apiName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getApiName", "()Ljava/lang/String;", "createTerm", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "value", "state", "assignee", "author", "label", "after", "before", "reviewedBy", "reviewRequested", "sortBy", "intellij.vcs.github"})
    public static final abstract class QualifierName
    extends Enum<QualifierName> {
        public static final /* enum */ QualifierName state;
        public static final /* enum */ QualifierName assignee;
        public static final /* enum */ QualifierName author;
        public static final /* enum */ QualifierName label;
        public static final /* enum */ QualifierName after;
        public static final /* enum */ QualifierName before;
        public static final /* enum */ QualifierName reviewedBy;
        public static final /* enum */ QualifierName reviewRequested;
        public static final /* enum */ QualifierName sortBy;
        private static final /* synthetic */ QualifierName[] $VALUES;
        @NotNull
        private final String apiName;

        static {
            QualifierName[] qualifierNameArray = new QualifierName[9];
            QualifierName[] qualifierNameArray2 = qualifierNameArray;
            qualifierNameArray[0] = state = new state("state", 0);
            qualifierNameArray[1] = assignee = new assignee("assignee", 1);
            qualifierNameArray[2] = author = new author("author", 2);
            qualifierNameArray[3] = label = new label("label", 3);
            qualifierNameArray[4] = after = new after("after", 4);
            qualifierNameArray[5] = before = new before("before", 5);
            qualifierNameArray[6] = reviewedBy = new reviewedBy("reviewedBy", 6);
            qualifierNameArray[7] = reviewRequested = new reviewRequested("reviewRequested", 7);
            qualifierNameArray[8] = sortBy = new sortBy("sortBy", 8);
            $VALUES = qualifierNameArray;
        }

        @NotNull
        public abstract Term<?> createTerm(@NotNull String var1);

        @NotNull
        public final String getApiName() {
            return this.apiName;
        }

        private QualifierName(String apiName) {
            this.apiName = apiName;
        }

        public /* synthetic */ QualifierName(String $enum$name, int $enum$ordinal, String apiName, DefaultConstructorMarker $constructor_marker) {
            this(apiName);
        }

        public static QualifierName[] values() {
            return (QualifierName[])$VALUES.clone();
        }

        public static QualifierName valueOf(String string) {
            return Enum.valueOf(QualifierName.class, string);
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName$state;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "createTerm", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "value", "", "intellij.vcs.github"})
        static final class state
        extends QualifierName {
            @Override
            @NotNull
            public Term<?> createTerm(@NotNull String value) {
                Term term;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Term.Qualifier.Enum.Companion companion = Term.Qualifier.Enum.Companion;
                QualifierName name$iv = this;
                boolean $i$f$from = false;
                try {
                    term = new Term.Qualifier.Enum<Enum>(name$iv, GithubIssueState.valueOf(value));
                }
                catch (IllegalArgumentException e$iv) {
                    term = new Term.Qualifier.Simple(name$iv, value);
                }
                return term;
            }

            /*
             * WARNING - void declaration
             */
            state() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName$assignee;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "createTerm", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Simple;", "value", "", "intellij.vcs.github"})
        static final class assignee
        extends QualifierName {
            @NotNull
            public Term.Qualifier.Simple createTerm(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new Term.Qualifier.Simple((QualifierName)this, value);
            }

            /*
             * WARNING - void declaration
             */
            assignee() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName$author;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "createTerm", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Simple;", "value", "", "intellij.vcs.github"})
        static final class author
        extends QualifierName {
            @NotNull
            public Term.Qualifier.Simple createTerm(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new Term.Qualifier.Simple((QualifierName)this, value);
            }

            /*
             * WARNING - void declaration
             */
            author() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName$label;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "createTerm", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Simple;", "value", "", "intellij.vcs.github"})
        static final class label
        extends QualifierName {
            @NotNull
            public Term.Qualifier.Simple createTerm(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new Term.Qualifier.Simple((QualifierName)this, value);
            }

            /*
             * WARNING - void declaration
             */
            label() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName$after;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "createTerm", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "value", "", "intellij.vcs.github"})
        static final class after
        extends QualifierName {
            @Override
            @NotNull
            public Term<?> createTerm(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return Term.Qualifier.Date.After.Companion.from(this, value);
            }

            /*
             * WARNING - void declaration
             */
            after() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName$before;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "createTerm", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "value", "", "intellij.vcs.github"})
        static final class before
        extends QualifierName {
            @Override
            @NotNull
            public Term<?> createTerm(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return Term.Qualifier.Date.Before.Companion.from(this, value);
            }

            /*
             * WARNING - void declaration
             */
            before() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName$reviewedBy;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "createTerm", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Simple;", "value", "", "toString", "intellij.vcs.github"})
        static final class reviewedBy
        extends QualifierName {
            @NotNull
            public Term.Qualifier.Simple createTerm(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new Term.Qualifier.Simple((QualifierName)this, value);
            }

            @NotNull
            public String toString() {
                return this.getApiName();
            }

            /*
             * WARNING - void declaration
             */
            reviewedBy() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName$reviewRequested;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "createTerm", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Simple;", "value", "", "toString", "intellij.vcs.github"})
        static final class reviewRequested
        extends QualifierName {
            @NotNull
            public Term.Qualifier.Simple createTerm(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new Term.Qualifier.Simple((QualifierName)this, value);
            }

            @NotNull
            public String toString() {
                return this.getApiName();
            }

            /*
             * WARNING - void declaration
             */
            reviewRequested() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName$sortBy;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "createTerm", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "value", "", "intellij.vcs.github"})
        static final class sortBy
        extends QualifierName {
            @Override
            @NotNull
            public Term<?> createTerm(@NotNull String value) {
                Term term;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Term.Qualifier.Enum.Companion companion = Term.Qualifier.Enum.Companion;
                QualifierName name$iv = this;
                boolean $i$f$from = false;
                try {
                    term = new Term.Qualifier.Enum<Enum>(name$iv, GithubIssueSearchSort.valueOf(value));
                }
                catch (IllegalArgumentException e$iv) {
                    term = new Term.Qualifier.Simple(name$iv, value);
                }
                return term;
            }

            /*
             * WARNING - void declaration
             */
            sortBy() {
                void var1_1;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0002\u0011\u0012B\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0003\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u0082\u0001\u0002\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "T", "", "value", "(Ljava/lang/Object;)V", "apiValue", "", "getApiValue", "()Ljava/lang/String;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "equals", "", "other", "hashCode", "", "Qualifier", "QueryPart", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$QueryPart;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier;", "intellij.vcs.github"})
    public static abstract class Term<T> {
        @NotNull
        private final T value;

        @Nullable
        public abstract String getApiValue();

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Term)) {
                return false;
            }
            return !(Intrinsics.areEqual(this.value, ((Term)other).value) ^ true);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @NotNull
        protected final T getValue() {
            return this.value;
        }

        private Term(T value) {
            this.value = value;
        }

        public /* synthetic */ Term(Object value, DefaultConstructorMarker $constructor_marker) {
            this(value);
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$QueryPart;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "", "value", "(Ljava/lang/String;)V", "apiValue", "getApiValue", "()Ljava/lang/String;", "toString", "intellij.vcs.github"})
        public static final class QueryPart
        extends Term<String> {
            @NotNull
            private final String apiValue;

            @Override
            @NotNull
            public String getApiValue() {
                return this.apiValue;
            }

            @NotNull
            public String toString() {
                return (String)this.getValue();
            }

            public QueryPart(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(value, null);
                this.apiValue = (String)this.getValue();
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0003\u000f\u0010\u0011B\u0017\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\tH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u0082\u0001\u0003\u0012\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier;", "T", "", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "name", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "value", "(Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;Ljava/lang/Object;)V", "apiName", "", "getApiName", "()Ljava/lang/String;", "getName", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "toString", "Date", "Enum", "Simple", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Simple;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Enum;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date;", "intellij.vcs.github"})
        public static abstract class Qualifier<T>
        extends Term<T> {
            @NotNull
            private final String apiName;
            @NotNull
            private final QualifierName name;

            @NotNull
            public final String getApiName() {
                return this.apiName;
            }

            @NotNull
            public String toString() {
                return "" + (Object)((Object)this.name) + ':' + this.getValue();
            }

            @NotNull
            protected final QualifierName getName() {
                return this.name;
            }

            private Qualifier(QualifierName name, T value) {
                super(value, null);
                this.name = name;
                this.apiName = this.name.getApiName();
            }

            public /* synthetic */ Qualifier(QualifierName name, Object value, DefaultConstructorMarker $constructor_marker) {
                this(name, value);
            }

            @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Simple;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier;", "", "name", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "value", "(Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;Ljava/lang/String;)V", "apiValue", "getApiValue", "()Ljava/lang/String;", "intellij.vcs.github"})
            public static final class Simple
            extends Qualifier<String> {
                @NotNull
                private final String apiValue;

                @Override
                @NotNull
                public String getApiValue() {
                    return this.apiValue;
                }

                public Simple(@NotNull QualifierName name, @NotNull String value) {
                    Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    super(name, value, null);
                    this.apiValue = (String)this.getValue();
                }
            }

            @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \f*\u000e\b\u0002\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00020\u0003:\u0001\fB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Enum;", "T", "", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier;", "name", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "value", "(Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;Ljava/lang/Enum;)V", "apiValue", "", "getApiValue", "()Ljava/lang/String;", "Companion", "intellij.vcs.github"})
            public static final class Enum<T extends java.lang.Enum<T>>
            extends Qualifier<java.lang.Enum<T>> {
                @NotNull
                private final String apiValue;
                @NotNull
                public static final Companion Companion = new Companion(null);

                @Override
                @NotNull
                public String getApiValue() {
                    return this.apiValue;
                }

                public Enum(@NotNull QualifierName name, @NotNull T value) {
                    Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
                    Intrinsics.checkNotNullParameter(value, (String)"value");
                    super(name, value, null);
                    this.apiValue = ((java.lang.Enum)this.getValue()).name();
                }

                @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\"\u0010\b\u0003\u0010\u0005\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00050\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Enum$Companion;", "", "()V", "from", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "T", "", "name", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "value", "", "intellij.vcs.github"})
                public static final class Companion {
                    public final /* synthetic */ <T extends java.lang.Enum<T>> Term<?> from(QualifierName name, String value) {
                        Term term;
                        int $i$f$from = 0;
                        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        try {
                            Intrinsics.reifiedOperationMarker((int)5, (String)"T");
                            term = new Enum<java.lang.Enum>(name, (java.lang.Enum)java.lang.Enum.valueOf(null, value));
                        }
                        catch (IllegalArgumentException e) {
                            term = new Simple(name, value);
                        }
                        return term;
                    }

                    private Companion() {
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }

            @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\n\u000bB\u0017\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0004J\b\u0010\t\u001a\u00020\bH\u0016\u0082\u0001\u0002\f\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier;", "Ljava/util/Date;", "name", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "value", "(Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;Ljava/util/Date;)V", "formatDate", "", "toString", "After", "Before", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date$Before;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date$After;", "intellij.vcs.github"})
            public static abstract class Date
            extends Qualifier<java.util.Date> {
                @NotNull
                protected final String formatDate() {
                    String string = DATE_FORMAT.format((java.util.Date)this.getValue());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DATE_FORMAT.format(this.value)");
                    return string;
                }

                @Override
                @NotNull
                public String toString() {
                    return (Object)((Object)this.getName()) + ':' + this.formatDate();
                }

                private Date(QualifierName name, java.util.Date value) {
                    super(name, value, null);
                }

                public /* synthetic */ Date(QualifierName name, java.util.Date value, DefaultConstructorMarker $constructor_marker) {
                    this(name, value);
                }

                @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date$Before;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date;", "name", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "value", "Ljava/util/Date;", "(Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;Ljava/util/Date;)V", "apiValue", "", "getApiValue", "()Ljava/lang/String;", "Companion", "intellij.vcs.github"})
                public static final class Before
                extends Date {
                    @NotNull
                    private final String apiValue;
                    @NotNull
                    public static final Companion Companion = new Companion(null);

                    @Override
                    @NotNull
                    public String getApiValue() {
                        return this.apiValue;
                    }

                    public Before(@NotNull QualifierName name, @NotNull java.util.Date value) {
                        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        super(name, value, null);
                        this.apiValue = '<' + this.formatDate();
                    }

                    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date$Before$Companion;", "", "()V", "from", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "name", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "value", "", "intellij.vcs.github"})
                    public static final class Companion {
                        @NotNull
                        public final Term<?> from(@NotNull QualifierName name, @NotNull String value) {
                            java.util.Date date;
                            java.util.Date date2;
                            Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
                            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                            try {
                                date2 = DATE_FORMAT.parse(value);
                            }
                            catch (ParseException e) {
                                return new Simple(name, value);
                            }
                            java.util.Date date3 = date = date2;
                            Intrinsics.checkNotNullExpressionValue((Object)date3, (String)"date");
                            return new Before(name, date3);
                        }

                        private Companion() {
                        }

                        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                            this();
                        }
                    }
                }

                @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date$After;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date;", "name", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "value", "Ljava/util/Date;", "(Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;Ljava/util/Date;)V", "apiValue", "", "getApiValue", "()Ljava/lang/String;", "Companion", "intellij.vcs.github"})
                public static final class After
                extends Date {
                    @NotNull
                    private final String apiValue;
                    @NotNull
                    public static final Companion Companion = new Companion(null);

                    @Override
                    @NotNull
                    public String getApiValue() {
                        return this.apiValue;
                    }

                    public After(@NotNull QualifierName name, @NotNull java.util.Date value) {
                        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        super(name, value, null);
                        this.apiValue = '>' + this.formatDate();
                    }

                    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date$After$Companion;", "", "()V", "from", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "name", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "value", "", "intellij.vcs.github"})
                    public static final class Companion {
                        @NotNull
                        public final Term<?> from(@NotNull QualifierName name, @NotNull String value) {
                            Term term;
                            Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
                            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                            try {
                                java.util.Date date = DATE_FORMAT.parse(value);
                                Intrinsics.checkNotNullExpressionValue((Object)date, (String)"DATE_FORMAT.parse(value)");
                                term = new After(name, date);
                            }
                            catch (ParseException e) {
                                term = new Simple(name, value);
                            }
                            return term;
                        }

                        private Companion() {
                        }

                        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                            this();
                        }
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Companion;", "", "()V", "DATE_FORMAT", "Ljava/text/SimpleDateFormat;", "DEFAULT", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery;", "getDEFAULT", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery;", "EMPTY", "getEMPTY", "parseFromString", "string", "", "intellij.vcs.github"})
    public static final class Companion {
        @NotNull
        public final GHPRSearchQuery getDEFAULT() {
            return DEFAULT;
        }

        @NotNull
        public final GHPRSearchQuery getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final GHPRSearchQuery parseFromString(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            boolean bl = false;
            List result = new ArrayList();
            String string2 = string;
            boolean bl2 = false;
            List terms = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString(), (char[])new char[]{' '}, (boolean)false, (int)0, (int)6, null);
            for (String term : terms) {
                CharSequence charSequence = term;
                boolean bl3 = false;
                if (charSequence.length() == 0) continue;
                int colonIdx = StringsKt.indexOf$default((CharSequence)term, (char)':', (int)0, (boolean)false, (int)6, null);
                if (colonIdx < 0) {
                    result.add(new Term.QueryPart(StringsKt.replace$default((String)term, (String)"#", (String)"", (boolean)false, (int)4, null)));
                    continue;
                }
                try {
                    String string3 = term;
                    int n = 0;
                    boolean bl4 = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n, colonIdx);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    QualifierName qualifierName = QualifierName.valueOf(string5);
                    string3 = term;
                    n = colonIdx + 1;
                    bl4 = false;
                    String string6 = string3;
                    if (string6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = string6.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                    result.add(qualifierName.createTerm(string7));
                }
                catch (IllegalArgumentException e) {
                    result.add(new Term.QueryPart(term));
                }
            }
            return new GHPRSearchQuery(result);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

