/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.string;

import com.intellij.openapi.diff.impl.string.DiffString;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class DiffStringBuilder
implements CharSequence {
    private char @NotNull [] myData;
    private int myLength;

    public DiffStringBuilder() {
        this(16);
    }

    public DiffStringBuilder(int len) {
        this.myData = new char[len];
        this.myLength = 0;
    }

    @Override
    public int length() {
        return this.myLength;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.myLength) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.myData[index];
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        DiffString.checkBounds(start, end, this.myLength);
        DiffString diffString = DiffString.create(this.myData, start, end - start);
        if (diffString == null) {
            DiffStringBuilder.$$$reportNull$$$0(0);
        }
        return diffString;
    }

    @NotNull
    public DiffString toDiffString() {
        DiffString diffString = DiffString.create(this.myData, 0, this.myLength);
        if (diffString == null) {
            DiffStringBuilder.$$$reportNull$$$0(1);
        }
        return diffString;
    }

    @Override
    @NotNull
    public String toString() {
        String string2 = this.toDiffString().toString();
        if (string2 == null) {
            DiffStringBuilder.$$$reportNull$$$0(2);
        }
        return string2;
    }

    private void ensureCapacityInternal(int neededCapacity) {
        if (neededCapacity > this.myData.length) {
            int newCapacity;
            for (newCapacity = this.myData.length; newCapacity < neededCapacity; newCapacity *= 2) {
            }
            this.myData = Arrays.copyOf(this.myData, newCapacity);
        }
    }

    public void append(@NotNull DiffString s) {
        if (s == null) {
            DiffStringBuilder.$$$reportNull$$$0(3);
        }
        if (s.isEmpty()) {
            return;
        }
        this.ensureCapacityInternal(this.myLength + s.length());
        s.copyData(this.myData, this.myLength);
        this.myLength += s.length();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/string/DiffStringBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "subSequence";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toDiffString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/string/DiffStringBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

