/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.plugins;

import com.intellij.platform.util.plugins.DataLoader;
import com.intellij.util.lang.ZipFilePool;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/util/plugins/LocalFsDataLoader;", "Lcom/intellij/platform/util/plugins/DataLoader;", "basePath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getBasePath", "()Ljava/nio/file/Path;", "pool", "Lcom/intellij/util/lang/ZipFilePool;", "getPool", "()Lcom/intellij/util/lang/ZipFilePool;", "load", "Ljava/io/InputStream;", "path", "", "toString", "intellij.platform.util"})
@ApiStatus.Internal
public final class LocalFsDataLoader
implements DataLoader {
    @NotNull
    private final Path basePath;

    @Override
    @Nullable
    public ZipFilePool getPool() {
        return ZipFilePool.POOL;
    }

    @Override
    @Nullable
    public InputStream load(@NotNull String path) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            inputStream = Files.newInputStream(this.basePath.resolve(path), new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            inputStream = null;
        }
        return inputStream;
    }

    @Override
    @NotNull
    public String toString() {
        return ((Object)this.basePath).toString();
    }

    @NotNull
    public final Path getBasePath() {
        return this.basePath;
    }

    public LocalFsDataLoader(@NotNull Path basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.basePath = basePath;
    }

    @Override
    public boolean isExcludedFromSubSearch(@NotNull Path jarFile) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        return DataLoader.DefaultImpls.isExcludedFromSubSearch(this, jarFile);
    }
}

