/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.google.common.net.InetAddresses;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.ConnectToChannelResult;
import com.intellij.util.io.IdeUtilIoBundle;
import com.intellij.util.io.NettyKt;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.BootstrapUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.ssl.SslHandler;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u008e\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0018H\u0002\u001a.\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002\u001a\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001f\u001a\u00020\u0005\u001a\"\u0010 \u001a\u00020!2\u0006\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\"\u001a\u00020!2\b\b\u0002\u0010#\u001a\u00020!\u001a\u0012\u0010$\u001a\u00020!2\b\b\u0001\u0010%\u001a\u00020\u0002H\u0002\u001a(\u0010&\u001a\u00020!2\n\b\u0001\u0010'\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\"\u001a\u00020!2\b\b\u0002\u0010#\u001a\u00020!H\u0007\u001a\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+\u001a\u0012\u0010,\u001a\u0004\u0018\u00010\u00012\u0006\u0010-\u001a\u00020\u0018H\u0002\u001a5\u0010.\u001a\u00020/*\u0002002#\b\u0004\u00101\u001a\u001d\u0012\u0013\u0012\u001100\u00a2\u0006\f\b3\u0012\b\b4\u0012\u0004\b\b(5\u0012\u0004\u0012\u00020/02H\u0086\b\u00f8\u0001\u0000\u001a\n\u00106\u001a\u00020/*\u00020\f\u001a0\u00107\u001a\u00020\u0012*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aH\u0007\u001a&\u00108\u001a\u00020\u0014*\u00020\u00142\u0014\b\u0004\u00109\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020/02H\u0086\b\u00f8\u0001\u0000\u001a \u0010:\u001a\u00020!*\u00020\u00052\b\b\u0002\u0010\"\u001a\u00020!2\b\b\u0002\u0010#\u001a\u00020!H\u0007\u001a\n\u0010;\u001a\u00020!*\u00020\u0005\u001a\n\u0010<\u001a\u00020!*\u00020\u0005\u001a\n\u0010=\u001a\u00020\u0001*\u00020>\u001a)\u0010?\u001a\u0002H@\"\u0004\b\u0000\u0010@*\u00020>2\f\u00109\u001a\b\u0012\u0004\u0012\u0002H@0AH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010B\u001a\u0014\u0010C\u001a\n\u0012\u0006\b\u0001\u0012\u00020E0D*\u00020+H\u0002\u001a\n\u0010F\u001a\u00020/*\u00020G\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\"\u0017\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\"\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\f8G\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u0001*\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006H"}, d2={"host", "", "Lcom/intellij/util/Url;", "getHost", "(Lcom/intellij/util/Url;)Ljava/lang/String;", "Lio/netty/handler/codec/http/HttpRequest;", "(Lio/netty/handler/codec/http/HttpRequest;)Ljava/lang/String;", "origin", "getOrigin", "referrer", "getReferrer", "uriScheme", "Lio/netty/channel/Channel;", "getUriScheme", "(Lio/netty/channel/Channel;)Ljava/lang/String;", "userAgent", "getUserAgent", "connectNio", "Lcom/intellij/util/io/ConnectToChannelResult;", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "remoteAddress", "Ljava/net/InetSocketAddress;", "maxAttemptCount", "", "stopCondition", "Lcom/intellij/openapi/util/Condition;", "Ljava/lang/Void;", "_attemptCount", "doConnect", "getHostName", "httpRequest", "isLocalHost", "", "onlyAnyOrLoopback", "hostsOnly", "isTrustedChromeExtension", "url", "parseAndCheckIsLocalHost", "uri", "serverBootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "group", "Lio/netty/channel/EventLoopGroup;", "sleep", "time", "addChannelListener", "", "Lio/netty/channel/ChannelFuture;", "listener", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "future", "closeAndShutdownEventLoop", "connectRetrying", "handler", "task", "isLocalOrigin", "isRegularBrowser", "isWriteFromBrowserWithoutOrigin", "readUtf8", "Lio/netty/buffer/ByteBuf;", "releaseIfError", "T", "Lkotlin/Function0;", "(Lio/netty/buffer/ByteBuf;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "serverSocketChannelClass", "Ljava/lang/Class;", "Lio/netty/channel/socket/ServerSocketChannel;", "shutdownIfOio", "Lio/netty/channel/EventLoop;", "intellij.platform.ide.util.netty"})
public final class NettyKt {
    @NotNull
    public static final Bootstrap handler(@NotNull Bootstrap $this$handler, @NotNull Function1<? super Channel, Unit> task) {
        int $i$f$handler = 0;
        Intrinsics.checkNotNullParameter((Object)$this$handler, (String)"$this$handler");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        $this$handler.handler((ChannelHandler)new ChannelInitializer<Channel>(task){
            final /* synthetic */ Function1 $task;

            protected void initChannel(@NotNull Channel channel) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                this.$task.invoke((Object)channel);
            }
            {
                this.$task = $captured_local_variable$0;
            }
        });
        return $this$handler;
    }

    @NotNull
    public static final ServerBootstrap serverBootstrap(@NotNull EventLoopGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        ServerBootstrap bootstrap = (ServerBootstrap)new ServerBootstrap().group(group).channel(NettyKt.serverSocketChannelClass(group));
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        ServerBootstrap serverBootstrap = bootstrap;
        Intrinsics.checkNotNullExpressionValue((Object)serverBootstrap, (String)"bootstrap");
        return serverBootstrap;
    }

    private static final Class<? extends ServerSocketChannel> serverSocketChannelClass(EventLoopGroup $this$serverSocketChannelClass) {
        Class<NioServerSocketChannel> clazz;
        EventLoopGroup eventLoopGroup = $this$serverSocketChannelClass;
        if (eventLoopGroup instanceof NioEventLoopGroup) {
            clazz = NioServerSocketChannel.class;
        } else if (eventLoopGroup instanceof OioEventLoopGroup) {
            clazz = OioServerSocketChannel.class;
        } else {
            throw (Throwable)new Exception("Unknown event loop group type: " + $this$serverSocketChannelClass.getClass().getName());
        }
        return clazz;
    }

    public static final void addChannelListener(@NotNull ChannelFuture $this$addChannelListener, @NotNull Function1<? super ChannelFuture, Unit> listener2) {
        int $i$f$addChannelListener = 0;
        Intrinsics.checkNotNullParameter((Object)$this$addChannelListener, (String)"$this$addChannelListener");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        $this$addChannelListener.addListener(new GenericFutureListener(listener2){
            final /* synthetic */ Function1 $listener;

            public final void operationComplete(ChannelFuture it) {
                ChannelFuture channelFuture = it;
                Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"it");
                this.$listener.invoke((Object)channelFuture);
            }
            {
                this.$listener = function1;
            }
        });
    }

    public static final void shutdownIfOio(@NotNull EventLoop $this$shutdownIfOio) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$shutdownIfOio, (String)"$this$shutdownIfOio");
            EventLoopGroup eventLoopGroup = $this$shutdownIfOio.parent();
            if (!(eventLoopGroup instanceof OioEventLoopGroup)) {
                eventLoopGroup = null;
            }
            OioEventLoopGroup oioEventLoopGroup = (OioEventLoopGroup)eventLoopGroup;
            if (oioEventLoopGroup == null) break block1;
            oioEventLoopGroup.shutdownGracefully(1L, 2L, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void closeAndShutdownEventLoop(@NotNull Channel $this$closeAndShutdownEventLoop) {
        Intrinsics.checkNotNullParameter((Object)$this$closeAndShutdownEventLoop, (String)"$this$closeAndShutdownEventLoop");
        EventLoop eventLoop = $this$closeAndShutdownEventLoop.eventLoop();
        try {
            $this$closeAndShutdownEventLoop.close().awaitUninterruptibly();
        }
        finally {
            EventLoop eventLoop2 = eventLoop;
            Intrinsics.checkNotNullExpressionValue((Object)eventLoop2, (String)"eventLoop");
            NettyKt.shutdownIfOio(eventLoop2);
        }
    }

    @JvmOverloads
    @NotNull
    public static final ConnectToChannelResult connectRetrying(@NotNull Bootstrap $this$connectRetrying, @NotNull InetSocketAddress remoteAddress, int maxAttemptCount, @Nullable Condition<Void> stopCondition) {
        Intrinsics.checkNotNullParameter((Object)$this$connectRetrying, (String)"$this$connectRetrying");
        Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
        try {
            Condition<Void> condition = stopCondition;
            if (condition == null) {
                Condition condition2 = Conditions.alwaysFalse();
                condition = condition2;
                Intrinsics.checkNotNullExpressionValue(condition2, (String)"Conditions.alwaysFalse<Void>()");
            }
            return NettyKt.doConnect($this$connectRetrying, remoteAddress, maxAttemptCount, condition);
        }
        catch (Throwable e) {
            return new ConnectToChannelResult(e);
        }
    }

    public static /* synthetic */ ConnectToChannelResult connectRetrying$default(Bootstrap bootstrap, InetSocketAddress inetSocketAddress, int n, Condition condition, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 20;
        }
        if ((n2 & 4) != 0) {
            condition = null;
        }
        return NettyKt.connectRetrying(bootstrap, inetSocketAddress, n, condition);
    }

    @JvmOverloads
    @NotNull
    public static final ConnectToChannelResult connectRetrying(@NotNull Bootstrap $this$connectRetrying, @NotNull InetSocketAddress remoteAddress, int maxAttemptCount) {
        return NettyKt.connectRetrying$default($this$connectRetrying, remoteAddress, maxAttemptCount, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final ConnectToChannelResult connectRetrying(@NotNull Bootstrap $this$connectRetrying, @NotNull InetSocketAddress remoteAddress) {
        return NettyKt.connectRetrying$default($this$connectRetrying, remoteAddress, 0, null, 6, null);
    }

    private static final ConnectToChannelResult doConnect(Bootstrap bootstrap, InetSocketAddress remoteAddress, int maxAttemptCount, Condition<Void> stopCondition) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isDispatchThread()) {
            Logger.getInstance("com.intellij.util.io.netty").error("Synchronous connection to socket shouldn't be performed on EDT.");
        }
        int attemptCount = 0;
        if (!(bootstrap.config().group() instanceof OioEventLoopGroup)) {
            return NettyKt.connectNio(bootstrap, remoteAddress, maxAttemptCount, stopCondition, attemptCount);
        }
        bootstrap.validate();
        while (true) {
            try {
                OioSocketChannel channel = new OioSocketChannel(new Socket(remoteAddress.getAddress(), remoteAddress.getPort()));
                BootstrapUtil.INSTANCE.initAndRegister((Channel)channel, bootstrap).sync();
                return new ConnectToChannelResult((Channel)channel);
            }
            catch (IOException e) {
                if (stopCondition.value(null)) {
                    return new ConnectToChannelResult(null, 1, null);
                }
                if (maxAttemptCount == -1) {
                    String string2 = NettyKt.sleep(300);
                    if (string2 != null) {
                        String string3 = string2;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string3;
                        boolean bl3 = false;
                        return new ConnectToChannelResult(it);
                    }
                    ++attemptCount;
                    continue;
                }
                if (++attemptCount < maxAttemptCount) {
                    String string4 = NettyKt.sleep(attemptCount * 100);
                    if (string4 == null) continue;
                    String string5 = string4;
                    boolean bl = false;
                    boolean bl4 = false;
                    String it = string5;
                    boolean bl5 = false;
                    return new ConnectToChannelResult(it);
                    continue;
                }
                return new ConnectToChannelResult(e);
            }
            break;
        }
    }

    private static final ConnectToChannelResult connectNio(Bootstrap bootstrap, InetSocketAddress remoteAddress, int maxAttemptCount, Condition<Void> stopCondition, int _attemptCount) {
        ChannelFuture future;
        int attemptCount = _attemptCount;
        Logger.getInstance("com.intellij.util.io.netty").debug("connectNio: " + Thread.currentThread() + " #" + attemptCount + ", max:#" + maxAttemptCount + " to " + remoteAddress);
        while (true) {
            Logger.getInstance("com.intellij.util.io.netty").debug("Connection attempt #" + attemptCount + " to " + remoteAddress);
            ChannelFuture channelFuture = future = bootstrap.connect((SocketAddress)remoteAddress).awaitUninterruptibly();
            Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"future");
            if (channelFuture.isSuccess()) {
                Channel channel = future.channel();
                Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"future.channel()");
                if (!channel.isOpen()) {
                    Logger.getInstance("com.intellij.util.io.netty").debug("connectNio: !future.channel().isOpen");
                }
                return new ConnectToChannelResult(future.channel());
            }
            if (stopCondition.value(null)) {
                return new ConnectToChannelResult(null, 1, null);
            }
            if (maxAttemptCount == -1) {
                String string2 = NettyKt.sleep(300);
                if (string2 != null) {
                    String string3 = string2;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string3;
                    boolean bl3 = false;
                    return new ConnectToChannelResult(it);
                }
                ++attemptCount;
                continue;
            }
            if (++attemptCount >= maxAttemptCount) break;
            String string4 = NettyKt.sleep(attemptCount * 100);
            if (string4 == null) continue;
            String string5 = string4;
            boolean bl = false;
            boolean bl4 = false;
            String it = string5;
            boolean bl5 = false;
            return new ConnectToChannelResult(it);
        }
        Throwable cause = future.cause();
        if (cause == null) {
            String string6 = IdeUtilIoBundle.message("error.message.cannot.connect.unknown.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"IdeUtilIoBundle.message(\u2026t.connect.unknown.error\")");
            return new ConnectToChannelResult(string6);
        }
        return new ConnectToChannelResult(cause);
    }

    private static final String sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException ignored) {
            return IdeUtilIoBundle.message("error.message.interrupted", new Object[0]);
        }
        return null;
    }

    @NlsSafe
    @NotNull
    public static final String getUriScheme(@NotNull Channel $this$uriScheme) {
        Intrinsics.checkNotNullParameter((Object)$this$uriScheme, (String)"$this$uriScheme");
        return $this$uriScheme.pipeline().get(SslHandler.class) == null ? "http" : "https";
    }

    @Nullable
    public static final String getHost(@NotNull HttpRequest $this$host) {
        Intrinsics.checkNotNullParameter((Object)$this$host, (String)"$this$host");
        return $this$host.headers().getAsString((CharSequence)HttpHeaderNames.HOST);
    }

    @Nullable
    public static final String getHostName(@NotNull HttpRequest httpRequest) {
        String string2;
        String string3;
        block11: {
            block10: {
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
                string3 = httpRequest.headers().getAsString((CharSequence)HttpHeaderNames.HOST);
                if (string3 == null) break block10;
                CharSequence charSequence2 = string3;
                boolean bl = false;
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    boolean bl2 = false;
                    charSequence = null;
                } else {
                    charSequence = charSequence2;
                }
                if ((string3 = (String)charSequence) != null) break block11;
            }
            return null;
        }
        String hostAndPort = string3;
        int portIndex = StringsKt.lastIndexOf$default((CharSequence)hostAndPort, (char)':', (int)0, (boolean)false, (int)6, null);
        if (portIndex > 0) {
            CharSequence charSequence;
            CharSequence charSequence3 = hostAndPort;
            int n = 0;
            boolean bl = false;
            String string4 = charSequence3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, portIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            charSequence3 = string5;
            n = 0;
            if (StringsKt.isBlank((CharSequence)charSequence3)) {
                boolean bl3 = false;
                charSequence = null;
            } else {
                charSequence = charSequence3;
            }
            string2 = charSequence;
        } else {
            string2 = hostAndPort;
        }
        return string2;
    }

    @Nullable
    public static final String getOrigin(@NotNull HttpRequest $this$origin) {
        Intrinsics.checkNotNullParameter((Object)$this$origin, (String)"$this$origin");
        return $this$origin.headers().getAsString((CharSequence)HttpHeaderNames.ORIGIN);
    }

    @Nullable
    public static final String getReferrer(@NotNull HttpRequest $this$referrer) {
        Intrinsics.checkNotNullParameter((Object)$this$referrer, (String)"$this$referrer");
        return $this$referrer.headers().getAsString((CharSequence)HttpHeaderNames.REFERER);
    }

    @NlsSafe
    @Nullable
    public static final String getUserAgent(@NotNull HttpRequest $this$userAgent) {
        Intrinsics.checkNotNullParameter((Object)$this$userAgent, (String)"$this$userAgent");
        return $this$userAgent.headers().getAsString((CharSequence)HttpHeaderNames.USER_AGENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T releaseIfError(@NotNull ByteBuf $this$releaseIfError, @NotNull Function0<? extends T> task) {
        int $i$f$releaseIfError = 0;
        Intrinsics.checkNotNullParameter((Object)$this$releaseIfError, (String)"$this$releaseIfError");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        try {
            return (T)task.invoke();
        }
        catch (Exception e) {
            try {
                $this$releaseIfError.release();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                throw (Throwable)e;
            }
        }
    }

    public static final boolean isLocalHost(@NotNull String host, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (NetUtils.isLocalhost(host)) {
            return true;
        }
        if (onlyAnyOrLoopback && !InetAddresses.isInetAddress((String)host)) {
            return false;
        }
        isLocalHost.1 $fun$isLocal$1 = isLocalHost.1.INSTANCE;
        try {
            InetAddress address;
            InetAddress inetAddress = address = InetAddress.getByName(host);
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"address");
            if (!$fun$isLocal$1.invoke(inetAddress)) {
                return false;
            }
            if (hostsOnly && !InetAddresses.isInetAddress((String)host)) {
                InetAddress inetAddress2 = HostsFileEntriesResolver.DEFAULT.address(host, ResolvedAddressTypes.IPV4_PREFERRED);
                boolean bl = false;
                boolean bl2 = false;
                InetAddress it = inetAddress2;
                boolean bl3 = false;
                return it != null && isLocalHost.1.INSTANCE.invoke(it);
            }
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static /* synthetic */ boolean isLocalHost$default(String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return NettyKt.isLocalHost(string2, bl, bl2);
    }

    @JvmOverloads
    public static final boolean isLocalOrigin(@NotNull HttpRequest $this$isLocalOrigin, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$isLocalOrigin, (String)"$this$isLocalOrigin");
        return NettyKt.parseAndCheckIsLocalHost(NettyKt.getOrigin($this$isLocalOrigin), onlyAnyOrLoopback, hostsOnly) && NettyKt.parseAndCheckIsLocalHost(NettyKt.getReferrer($this$isLocalOrigin), onlyAnyOrLoopback, hostsOnly);
    }

    public static /* synthetic */ boolean isLocalOrigin$default(HttpRequest httpRequest, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return NettyKt.isLocalOrigin(httpRequest, bl, bl2);
    }

    @JvmOverloads
    public static final boolean isLocalOrigin(@NotNull HttpRequest $this$isLocalOrigin, boolean onlyAnyOrLoopback) {
        return NettyKt.isLocalOrigin$default($this$isLocalOrigin, onlyAnyOrLoopback, false, 2, null);
    }

    @JvmOverloads
    public static final boolean isLocalOrigin(@NotNull HttpRequest $this$isLocalOrigin) {
        return NettyKt.isLocalOrigin$default($this$isLocalOrigin, false, false, 3, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isTrustedChromeExtension(@NlsSafe Url url) {
        if (!Intrinsics.areEqual((Object)url.getScheme(), (Object)"chrome-extension")) return false;
        if (Intrinsics.areEqual((Object)url.getAuthority(), (Object)"hmhgeddbohgjknpmjagkdomcpobmllji")) return true;
        if (Intrinsics.areEqual((Object)url.getAuthority(), (Object)"offnedcbhjldheanlbojaefbfbllddna")) return true;
        String string2 = System.getProperty("idea.trusted.chrome.extension.id");
        if (string2 == null) return false;
        boolean bl = string2.equals(url.getAuthority());
        if (!bl) return false;
        return true;
    }

    private static final String getHost(Url $this$host) {
        String string2;
        String string3 = $this$host.getAuthority();
        if (string3 != null) {
            String string4 = string3;
            boolean bl = false;
            boolean bl2 = false;
            String it = string4;
            boolean bl3 = false;
            String string5 = it;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it");
            int portIndex = StringsKt.indexOf$default((CharSequence)string5, (char)':', (int)0, (boolean)false, (int)6, null);
            if (portIndex > 0) {
                String string6 = it;
                int n = 0;
                boolean bl4 = false;
                String string7 = string6.substring(n, portIndex);
                string2 = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string2 = it;
            }
        } else {
            string2 = null;
        }
        return string2;
    }

    @JvmOverloads
    public static final boolean parseAndCheckIsLocalHost(@NlsSafe @Nullable String uri, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        if (uri == null || Intrinsics.areEqual((Object)uri, (Object)"about:blank")) {
            return true;
        }
        try {
            Url url = Urls.parse(uri, false);
            if (url == null) {
                return false;
            }
            Url parsedUri = url;
            String host = NettyKt.getHost(parsedUri);
            return host != null && (NettyKt.isTrustedChromeExtension(parsedUri) || NettyKt.isLocalHost(host, onlyAnyOrLoopback, hostsOnly));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static /* synthetic */ boolean parseAndCheckIsLocalHost$default(String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return NettyKt.parseAndCheckIsLocalHost(string2, bl, bl2);
    }

    @JvmOverloads
    public static final boolean parseAndCheckIsLocalHost(@NlsSafe @Nullable String uri, boolean onlyAnyOrLoopback) {
        return NettyKt.parseAndCheckIsLocalHost$default(uri, onlyAnyOrLoopback, false, 4, null);
    }

    @JvmOverloads
    public static final boolean parseAndCheckIsLocalHost(@NlsSafe @Nullable String uri) {
        return NettyKt.parseAndCheckIsLocalHost$default(uri, false, false, 6, null);
    }

    public static final boolean isRegularBrowser(@NotNull HttpRequest $this$isRegularBrowser) {
        Intrinsics.checkNotNullParameter((Object)$this$isRegularBrowser, (String)"$this$isRegularBrowser");
        String string2 = NettyKt.getUserAgent($this$isRegularBrowser);
        return string2 != null ? StringsKt.startsWith$default((String)string2, (String)"Mozilla/5.0", (boolean)false, (int)2, null) : false;
    }

    public static final boolean isWriteFromBrowserWithoutOrigin(@NotNull HttpRequest $this$isWriteFromBrowserWithoutOrigin) {
        Intrinsics.checkNotNullParameter((Object)$this$isWriteFromBrowserWithoutOrigin, (String)"$this$isWriteFromBrowserWithoutOrigin");
        HttpMethod method = $this$isWriteFromBrowserWithoutOrigin.method();
        CharSequence charSequence = NettyKt.getOrigin($this$isWriteFromBrowserWithoutOrigin);
        boolean bl = false;
        boolean bl2 = false;
        return (charSequence == null || charSequence.length() == 0) && NettyKt.isRegularBrowser($this$isWriteFromBrowserWithoutOrigin) && (Intrinsics.areEqual((Object)method, (Object)HttpMethod.POST) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.PATCH) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.PUT) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.DELETE));
    }

    @NotNull
    public static final String readUtf8(@NotNull ByteBuf $this$readUtf8) {
        Intrinsics.checkNotNullParameter((Object)$this$readUtf8, (String)"$this$readUtf8");
        String string2 = $this$readUtf8.toString(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(Charsets.UTF_8)");
        return string2;
    }
}

