/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.MavenArtifactDownloadServerProgressEvent;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenRemotePullUtil;
import org.jetbrains.idea.maven.server.MavenServerConsole;
import org.jetbrains.idea.maven.server.MavenServerConsoleEvent;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.MavenServerPullProgressIndicator;

public class MavenServerProgressIndicatorWrapper
extends MavenRemoteObject
implements MavenServerProgressIndicator,
MavenServerPullProgressIndicator,
MavenServerConsole {
    private final ConcurrentLinkedQueue<MavenArtifactDownloadServerProgressEvent> myPullingQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<MavenServerConsoleEvent> myConsoleEventsQueue = new ConcurrentLinkedQueue();
    private boolean myCancelled = false;

    public void setText(String text) throws RemoteException {
    }

    public void setText2(String text) throws RemoteException {
    }

    public void startedDownload(MavenServerProgressIndicator.ResolveType type, String dependencyId) throws RemoteException {
        this.myPullingQueue.add(new MavenArtifactDownloadServerProgressEvent(type, MavenArtifactDownloadServerProgressEvent.ArtifactEventType.DOWNLOAD_STARTED, dependencyId, null, null));
    }

    public void completedDownload(MavenServerProgressIndicator.ResolveType type, String dependencyId) throws RemoteException {
        this.myPullingQueue.add(new MavenArtifactDownloadServerProgressEvent(type, MavenArtifactDownloadServerProgressEvent.ArtifactEventType.DOWNLOAD_COMPLETED, dependencyId, null, null));
    }

    public void failedDownload(MavenServerProgressIndicator.ResolveType type, String dependencyId, String errorMessage, String stackTrace) throws RemoteException {
        this.myPullingQueue.add(new MavenArtifactDownloadServerProgressEvent(type, MavenArtifactDownloadServerProgressEvent.ArtifactEventType.DOWNLOAD_FAILED, dependencyId, errorMessage, stackTrace));
    }

    public boolean isCanceled() throws RemoteException {
        return this.myCancelled;
    }

    public void setIndeterminate(boolean value) throws RemoteException {
    }

    public void setFraction(double fraction) throws RemoteException {
    }

    @Nullable
    public List<MavenArtifactDownloadServerProgressEvent> pullDownloadEvents() throws RemoteException {
        return MavenRemotePullUtil.pull(this.myPullingQueue);
    }

    @Nullable
    public List<MavenServerConsoleEvent> pullConsoleEvents() throws RemoteException {
        return MavenRemotePullUtil.pull(this.myConsoleEventsQueue);
    }

    public void printMessage(int level, String message, Throwable throwable) throws RemoteException {
        this.myConsoleEventsQueue.add(new MavenServerConsoleEvent(level, message, throwable));
    }

    public void cancel() {
        this.myCancelled = true;
    }
}

