/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.clientProperties;

import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.LoaderFactory;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.clientProperties.AddClientPropertyDialog;
import com.intellij.uiDesigner.clientProperties.ClassNameInputDialog;
import com.intellij.uiDesigner.clientProperties.ClientPropertiesManager;
import java.awt.Component;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureClientPropertiesDialog
extends DialogWrapper {
    private JTree myClassTree;
    private JTable myPropertiesTable;
    private Class mySelectedClass;
    private List<ClientPropertiesManager.ClientProperty> mySelectedProperties = Collections.emptyList();
    private final MyTableModel myTableModel = new MyTableModel();
    private final Project myProject;
    private final ClientPropertiesManager myManager;
    private JBSplitter mySplitter;

    public ConfigureClientPropertiesDialog(Project project) {
        super(project, true);
        this.myProject = project;
        this.setTitle(UIDesignerBundle.message("client.properties.title", new Object[0]));
        this.myManager = ClientPropertiesManager.getInstance(project).clone();
        this.init();
    }

    public void save() {
        ClientPropertiesManager.getInstance(this.myProject).saveFrom(this.myManager);
    }

    private void updateSelectedProperties() {
        this.mySelectedProperties = this.myManager.getConfiguredProperties(this.mySelectedClass);
        this.myTableModel.fireTableDataChanged();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myClassTree = new Tree();
        this.myClassTree.setRootVisible(false);
        this.myClassTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath leadSelectionPath = e.getNewLeadSelectionPath();
                if (leadSelectionPath == null) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)leadSelectionPath.getLastPathComponent();
                ConfigureClientPropertiesDialog.this.mySelectedClass = (Class)node.getUserObject();
                ConfigureClientPropertiesDialog.this.updateSelectedProperties();
            }
        });
        this.myClassTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Class cls;
                DefaultMutableTreeNode node;
                if (tree == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((node = (DefaultMutableTreeNode)value).getUserObject() instanceof Class && (cls = (Class)node.getUserObject()) != null) {
                    @NlsSafe String name = cls.getName();
                    this.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/uiDesigner/clientProperties/ConfigureClientPropertiesDialog$2", "customizeCellRenderer"));
            }
        });
        this.fillClassTree();
        this.myPropertiesTable = new JBTable();
        this.myPropertiesTable.setModel(this.myTableModel);
        this.mySplitter = new JBSplitter("ConfigureClientPropertiesDialog.splitterProportion", 0.5f);
        this.mySplitter.setFirstComponent((JComponent)ToolbarDecorator.createDecorator((JTree)this.myClassTree).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ClassNameInputDialog dlg = new ClassNameInputDialog(ConfigureClientPropertiesDialog.this.myProject, (Component)ConfigureClientPropertiesDialog.this.mySplitter);
                dlg.show();
                if (dlg.getExitCode() == 0) {
                    Class<?> aClass;
                    String className = dlg.getClassName();
                    if (className.isEmpty()) {
                        return;
                    }
                    try {
                        aClass = Class.forName(className, true, LoaderFactory.getInstance(ConfigureClientPropertiesDialog.this.myProject).getProjectClassLoader());
                    }
                    catch (ClassNotFoundException ex) {
                        Messages.showErrorDialog((Component)ConfigureClientPropertiesDialog.this.mySplitter, (String)UIDesignerBundle.message("client.properties.class.not.found", className), (String)UIDesignerBundle.message("client.properties.title", new Object[0]));
                        return;
                    }
                    if (!JComponent.class.isAssignableFrom(aClass)) {
                        Messages.showErrorDialog((Component)ConfigureClientPropertiesDialog.this.mySplitter, (String)UIDesignerBundle.message("client.properties.class.not.component", className), (String)UIDesignerBundle.message("client.properties.title", new Object[0]));
                        return;
                    }
                    ConfigureClientPropertiesDialog.this.myManager.addClientPropertyClass(className);
                    ConfigureClientPropertiesDialog.this.fillClassTree();
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                if (ConfigureClientPropertiesDialog.this.mySelectedClass != null) {
                    ConfigureClientPropertiesDialog.this.myManager.removeClientPropertyClass(ConfigureClientPropertiesDialog.this.mySelectedClass);
                    ConfigureClientPropertiesDialog.this.fillClassTree();
                }
            }
        }).setToolbarPosition(SystemInfo.isMac ? ActionToolbarPosition.BOTTOM : ActionToolbarPosition.RIGHT).createPanel());
        this.mySplitter.setSecondComponent((JComponent)ToolbarDecorator.createDecorator((JTable)this.myPropertiesTable).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                AddClientPropertyDialog dlg = new AddClientPropertyDialog(ConfigureClientPropertiesDialog.this.myProject);
                dlg.show();
                if (dlg.getExitCode() == 0) {
                    for (ClientPropertiesManager.ClientProperty prop : ConfigureClientPropertiesDialog.this.myManager.getClientProperties(ConfigureClientPropertiesDialog.this.mySelectedClass)) {
                        if (!prop.getName().equalsIgnoreCase(dlg.getEnteredProperty().getName())) continue;
                        Messages.showErrorDialog((Component)ConfigureClientPropertiesDialog.this.mySplitter, (String)UIDesignerBundle.message("client.properties.already.defined", prop.getName()), (String)UIDesignerBundle.message("client.properties.title", new Object[0]));
                        return;
                    }
                    ConfigureClientPropertiesDialog.this.myManager.addConfiguredProperty(ConfigureClientPropertiesDialog.this.mySelectedClass, dlg.getEnteredProperty());
                    ConfigureClientPropertiesDialog.this.updateSelectedProperties();
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int row = ConfigureClientPropertiesDialog.this.myPropertiesTable.getSelectedRow();
                if (row >= 0 && row < ConfigureClientPropertiesDialog.this.mySelectedProperties.size()) {
                    ConfigureClientPropertiesDialog.this.myManager.removeConfiguredProperty(ConfigureClientPropertiesDialog.this.mySelectedClass, ConfigureClientPropertiesDialog.this.mySelectedProperties.get(row).getName());
                    ConfigureClientPropertiesDialog.this.updateSelectedProperties();
                    if (!ConfigureClientPropertiesDialog.this.mySelectedProperties.isEmpty()) {
                        if (row >= ConfigureClientPropertiesDialog.this.mySelectedProperties.size()) {
                            --row;
                        }
                        ConfigureClientPropertiesDialog.this.myPropertiesTable.getSelectionModel().setSelectionInterval(row, row);
                    }
                }
            }
        }).createPanel());
        return this.mySplitter;
    }

    private static int getInheritanceLevel(Class aClass) {
        int level = 0;
        while (aClass.getSuperclass() != null) {
            ++level;
            aClass = aClass.getSuperclass();
        }
        return level;
    }

    private void fillClassTree() {
        List<Class<?>> configuredClasses = this.myManager.getConfiguredClasses(this.myProject);
        configuredClasses.sort(Comparator.comparingInt(ConfigureClientPropertiesDialog::getInheritanceLevel));
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        HashMap classToNodeMap = new HashMap();
        for (Class<?> cls : configuredClasses) {
            DefaultMutableTreeNode parentNode = root;
            for (Class<?> superClass = cls.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
                if (!classToNodeMap.containsKey(superClass)) continue;
                parentNode = (DefaultMutableTreeNode)classToNodeMap.get(superClass);
                break;
            }
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(cls);
            classToNodeMap.put(cls, childNode);
            parentNode.add(childNode);
        }
        this.myClassTree.setModel(treeModel);
        if (root.getChildCount() > 0) {
            this.myClassTree.expandRow(0);
            this.myClassTree.getSelectionModel().setSelectionMode(1);
            this.myClassTree.getSelectionModel().setSelectionPath(new TreePath(new Object[]{root, root.getFirstChild()}));
        }
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "ConfigureClientPropertiesDialog";
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return ConfigureClientPropertiesDialog.this.mySelectedProperties.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return ConfigureClientPropertiesDialog.this.mySelectedProperties.get(rowIndex).getName();
            }
            return ConfigureClientPropertiesDialog.this.mySelectedProperties.get(rowIndex).getValueClass();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return UIDesignerBundle.message("client.properties.name", new Object[0]);
            }
            return UIDesignerBundle.message("client.properties.class", new Object[0]);
        }
    }
}

