/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.quickFixes;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.uiDesigner.ErrorInfo;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.quickFixes.FocusListenerImpl;
import com.intellij.uiDesigner.quickFixes.LightBulbComponentImpl;
import com.intellij.uiDesigner.quickFixes.PopupQuickFix;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.uiDesigner.quickFixes.ShowHintAction;
import com.intellij.uiDesigner.quickFixes.VisibilityWatcherImpl;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.util.Alarm;
import com.intellij.util.IJSwingUtilities;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QuickFixManager<T extends JComponent> {
    private static final Logger LOG = Logger.getInstance(QuickFixManager.class);
    private GuiEditor myEditor;
    protected final T myComponent;
    private final Alarm myAlarm;
    private final MyShowHintRequest myShowHintRequest;
    private LightweightHint myHint;
    private Rectangle myLastHintBounds;

    public QuickFixManager(@Nullable GuiEditor editor, @NotNull T component, final @NotNull JViewport viewPort) {
        if (component == null) {
            QuickFixManager.$$$reportNull$$$0(0);
        }
        if (viewPort == null) {
            QuickFixManager.$$$reportNull$$$0(1);
        }
        this.myEditor = editor;
        this.myComponent = component;
        this.myAlarm = new Alarm();
        this.myShowHintRequest = new MyShowHintRequest(this);
        new VisibilityWatcherImpl(this, (JComponent)component).install((Component)this.myComponent);
        ((Component)this.myComponent).addFocusListener(new FocusListenerImpl(this));
        new ShowHintAction(this, (JComponent)component);
        viewPort.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                QuickFixManager.this.updateIntentionHintPosition(viewPort);
            }
        });
    }

    public final GuiEditor getEditor() {
        return this.myEditor;
    }

    public void setEditor(GuiEditor editor) {
        this.myEditor = editor;
    }

    protected abstract ErrorInfo @NotNull [] getErrorInfos();

    @Nullable
    protected abstract Rectangle getErrorBounds();

    public void refreshIntentionHint() {
        if (!((Component)this.myComponent).isShowing() || !IJSwingUtilities.hasFocus(this.myComponent)) {
            this.hideIntentionHint();
            return;
        }
        if (this.myHint == null || !this.myHint.isVisible()) {
            this.updateIntentionHintVisibility();
        } else {
            ErrorInfo[] errorInfos = this.getErrorInfos();
            Rectangle bounds = this.getErrorBounds();
            if (!QuickFixManager.haveFixes(errorInfos) || bounds == null || !bounds.equals(this.myLastHintBounds)) {
                this.hideIntentionHint();
                this.updateIntentionHintVisibility();
            }
        }
    }

    public final void updateIntentionHintVisibility() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest((Runnable)this.myShowHintRequest, 500);
    }

    final void showIntentionHint() {
        if (!((Component)this.myComponent).isShowing() || !IJSwingUtilities.hasFocus(this.myComponent)) {
            this.hideIntentionHint();
            return;
        }
        this.hideIntentionHint();
        ErrorInfo[] errorInfos = this.getErrorInfos();
        if (!QuickFixManager.haveFixes(errorInfos)) {
            this.hideIntentionHint();
            return;
        }
        Rectangle bounds = this.getErrorBounds();
        if (bounds == null) {
            return;
        }
        LightBulbComponentImpl lightBulbComponent = new LightBulbComponentImpl(this, AllIcons.Actions.IntentionBulb);
        this.myHint = new LightweightHint((JComponent)lightBulbComponent);
        this.myLastHintBounds = bounds;
        this.myHint.show(this.myComponent, bounds.x - AllIcons.Actions.IntentionBulb.getIconWidth() - 4, bounds.y, this.myComponent, new HintHint(this.myComponent, bounds.getLocation()));
    }

    private void updateIntentionHintPosition(JViewport viewPort) {
        Rectangle rc;
        if (this.myHint != null && this.myHint.isVisible() && (rc = this.getErrorBounds()) != null) {
            this.myLastHintBounds = rc;
            Rectangle hintRect = new Rectangle(rc.x - AllIcons.Actions.IntentionBulb.getIconWidth() - 4, rc.y, AllIcons.Actions.IntentionBulb.getIconWidth() + 4, AllIcons.Actions.IntentionBulb.getIconHeight() + 4);
            LOG.debug("hintRect=" + hintRect);
            if (this.getHintClipRect(viewPort).contains(hintRect)) {
                this.myHint.pack();
            } else {
                this.myHint.hide();
            }
        }
    }

    protected Rectangle getHintClipRect(JViewport viewPort) {
        return viewPort.getViewRect();
    }

    private static boolean haveFixes(ErrorInfo[] errorInfos) {
        boolean haveFixes = false;
        for (ErrorInfo errorInfo : errorInfos) {
            if (errorInfo.myFixes.length <= 0 && errorInfo.getInspectionId() == null) continue;
            haveFixes = true;
            break;
        }
        return haveFixes;
    }

    public final void hideIntentionHint() {
        this.myAlarm.cancelAllRequests();
        if (this.myHint != null && this.myHint.isVisible()) {
            this.myHint.hide();
            ((JComponent)this.myComponent).paintImmediately(((JComponent)this.myComponent).getVisibleRect());
        }
    }

    final void showIntentionPopup() {
        LOG.debug("showIntentionPopup()");
        if (this.myHint == null || !this.myHint.isVisible()) {
            return;
        }
        ErrorInfo[] errorInfos = this.getErrorInfos();
        if (!QuickFixManager.haveFixes(errorInfos)) {
            return;
        }
        ArrayList<ErrorWithFix> fixList = new ArrayList<ErrorWithFix>();
        for (ErrorInfo errorInfo : errorInfos) {
            QuickFix[] quickFixes = errorInfo.myFixes;
            if (quickFixes.length > 0) {
                for (QuickFix fix : quickFixes) {
                    fixList.add(new ErrorWithFix(errorInfo, fix));
                }
                continue;
            }
            if (errorInfo.getInspectionId() == null) continue;
            this.buildSuppressFixes(errorInfo, fixList, true);
        }
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new QuickFixPopupStep(fixList, true));
        popup.showUnderneathOf((Component)this.myHint.getComponent());
    }

    private void buildSuppressFixes(ErrorInfo errorInfo, ArrayList<ErrorWithFix> suppressList, boolean named) {
        String suppressName = named ? UIDesignerBundle.message("action.suppress.named.for.component", errorInfo.myDescription) : UIDesignerBundle.message("action.suppress.for.component", new Object[0]);
        String suppressAllName = named ? UIDesignerBundle.message("action.suppress.named.for.all.components", errorInfo.myDescription) : UIDesignerBundle.message("action.suppress.for.all.components", new Object[0]);
        SuppressFix suppressFix = new SuppressFix(this.myEditor, suppressName, errorInfo.getInspectionId(), errorInfo.getComponent());
        SuppressFix suppressAllFix = new SuppressFix(this.myEditor, suppressAllName, errorInfo.getInspectionId(), null);
        suppressList.add(new ErrorWithFix(errorInfo, suppressFix));
        suppressList.add(new ErrorWithFix(errorInfo, suppressAllFix));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "component";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "viewPort";
                break;
            }
        }
        objectArray[1] = "com/intellij/uiDesigner/quickFixes/QuickFixManager";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyShowHintRequest
    implements Runnable {
        private final QuickFixManager myManager;

        MyShowHintRequest(@NotNull QuickFixManager manager) {
            if (manager == null) {
                MyShowHintRequest.$$$reportNull$$$0(0);
            }
            this.myManager = manager;
        }

        @Override
        public void run() {
            this.myManager.showIntentionHint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/uiDesigner/quickFixes/QuickFixManager$MyShowHintRequest", "<init>"));
        }
    }

    private static class SuppressFix
    extends QuickFix {
        private final String myInspectionId;

        SuppressFix(GuiEditor editor, @IntentionName String name, String inspectionId, RadComponent component) {
            super(editor, name, component);
            this.myInspectionId = inspectionId;
        }

        @Override
        public void run() {
            if (!this.myEditor.ensureEditable()) {
                return;
            }
            this.myEditor.getRootContainer().suppressInspection(this.myInspectionId, this.myComponent);
            this.myEditor.refreshAndSave(true);
            DaemonCodeAnalyzer.getInstance((Project)this.myEditor.getProject()).restart();
        }
    }

    private class QuickFixPopupStep
    extends BaseListPopupStep<ErrorWithFix> {
        private final boolean myShowSuppresses;

        QuickFixPopupStep(ArrayList<ErrorWithFix> fixList, boolean showSuppresses) {
            super(null, fixList);
            this.myShowSuppresses = showSuppresses;
        }

        @NotNull
        public String getTextFor(ErrorWithFix value) {
            String string = ((QuickFix)value.second).getName();
            if (string == null) {
                QuickFixPopupStep.$$$reportNull$$$0(0);
            }
            return string;
        }

        public PopupStep onChosen(ErrorWithFix selectedValue, boolean finalChoice) {
            if (selectedValue.second instanceof PopupQuickFix) {
                return ((PopupQuickFix)selectedValue.second).getPopupStep();
            }
            if (finalChoice || !this.myShowSuppresses) {
                return this.doFinalStep(() -> CommandProcessor.getInstance().executeCommand(QuickFixManager.this.myEditor.getProject(), () -> ((QuickFix)selectedValue.second).run(), ((QuickFix)selectedValue.second).getName(), null));
            }
            if (((ErrorInfo)selectedValue.first).getInspectionId() != null && ((QuickFix)selectedValue.second).getComponent() != null && !(selectedValue.second instanceof SuppressFix)) {
                ArrayList<ErrorWithFix> suppressList = new ArrayList<ErrorWithFix>();
                QuickFixManager.this.buildSuppressFixes((ErrorInfo)selectedValue.first, suppressList, false);
                return new QuickFixPopupStep(suppressList, false);
            }
            return FINAL_CHOICE;
        }

        public boolean hasSubstep(ErrorWithFix selectedValue) {
            return this.myShowSuppresses && ((ErrorInfo)selectedValue.first).getInspectionId() != null && ((QuickFix)selectedValue.second).getComponent() != null && !(selectedValue.second instanceof SuppressFix) || selectedValue.second instanceof PopupQuickFix;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/quickFixes/QuickFixManager$QuickFixPopupStep", "getTextFor"));
        }
    }

    private static class ErrorWithFix
    extends Pair<ErrorInfo, QuickFix> {
        ErrorWithFix(ErrorInfo first, QuickFix second) {
            super((Object)first, (Object)second);
        }
    }
}

