/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.options.impl;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.beans.PropertyChangeSupport;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.images.options.DefaultImageEditorSettings;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.impl.ImageEditorColorSchemeSettingsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\bJ\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/intellij/images/options/impl/GridOptionsImpl;", "Lorg/intellij/images/options/GridOptions;", "propertyChangeSupport", "Ljava/beans/PropertyChangeSupport;", "(Ljava/beans/PropertyChangeSupport;)V", "lineColor", "Ljava/awt/Color;", "lineMinZoomFactor", "", "lineSpan", "showDefault", "", "getLineColor", "getLineSpan", "getLineZoomFactor", "inject", "", "options", "isShowDefault", "setLineMinZoomFactor", "setLineSpan", "setOption", "name", "", "value", "", "intellij.platform.images"})
public final class GridOptionsImpl
implements GridOptions {
    private boolean showDefault;
    private int lineMinZoomFactor;
    private int lineSpan;
    private Color lineColor;
    private final PropertyChangeSupport propertyChangeSupport;

    @Override
    public boolean isShowDefault() {
        return this.showDefault;
    }

    @Override
    public int getLineZoomFactor() {
        return this.lineMinZoomFactor;
    }

    @Override
    public int getLineSpan() {
        return this.lineSpan;
    }

    @Override
    @NotNull
    public Color getLineColor() {
        Color color;
        Color color2 = this.lineColor;
        if (color2 == null) {
            EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
            color2 = color = editorColorsManager.getGlobalScheme().getColor(ImageEditorColorSchemeSettingsKt.getGRID_LINE_COLOR_KEY());
        }
        if (color2 == null) {
            JBColor jBColor = JBColor.DARK_GRAY;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"JBColor.DARK_GRAY");
            color = (Color)jBColor;
        }
        return color;
    }

    public final void setLineMinZoomFactor(int lineMinZoomFactor) {
        int oldValue = this.lineMinZoomFactor;
        if (oldValue != lineMinZoomFactor) {
            this.lineMinZoomFactor = lineMinZoomFactor;
            this.propertyChangeSupport.firePropertyChange("Editor.Grid.lineZoomFactor", oldValue, this.lineMinZoomFactor);
        }
    }

    public final void setLineSpan(int lineSpan) {
        int oldValue = this.lineSpan;
        if (oldValue != lineSpan) {
            this.lineSpan = lineSpan;
            this.propertyChangeSupport.firePropertyChange("Editor.Grid.lineSpan", oldValue, this.lineSpan);
        }
    }

    @Override
    public void inject(@NotNull GridOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.showDefault = options.isShowDefault();
        this.setLineMinZoomFactor(options.getLineZoomFactor());
        this.setLineSpan(options.getLineSpan());
    }

    @Override
    public boolean setOption(@NotNull String name, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)"Editor.Grid.showDefault", (Object)name)) {
            this.showDefault = (Boolean)value;
        } else if (Intrinsics.areEqual((Object)"Editor.Grid.lineZoomFactor", (Object)name)) {
            this.setLineMinZoomFactor((Integer)value);
        } else if (Intrinsics.areEqual((Object)"Editor.Grid.lineSpan", (Object)name)) {
            this.setLineSpan((Integer)value);
        } else {
            return false;
        }
        return true;
    }

    public GridOptionsImpl(@NotNull PropertyChangeSupport propertyChangeSupport) {
        Intrinsics.checkNotNullParameter((Object)propertyChangeSupport, (String)"propertyChangeSupport");
        this.propertyChangeSupport = propertyChangeSupport;
        this.showDefault = DefaultImageEditorSettings.INSTANCE.getShowGrid();
        this.lineMinZoomFactor = DefaultImageEditorSettings.INSTANCE.getShowGridWhenZoomEqualOrMoreThan();
        this.lineSpan = DefaultImageEditorSettings.INSTANCE.getShowGridAfterEveryXPixels();
    }

    @NotNull
    public Object clone() {
        return GridOptions.DefaultImpls.clone((GridOptions)this);
    }
}

