/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.extension;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.QuickFix;
import com.intellij.java.JavaBundle;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import de.plushnikov.intellij.plugin.handler.BuilderHandler;
import de.plushnikov.intellij.plugin.handler.FieldNameConstantsHandler;
import de.plushnikov.intellij.plugin.handler.LazyGetterHandler;
import de.plushnikov.intellij.plugin.handler.OnXAnnotationHandler;
import de.plushnikov.intellij.plugin.util.LombokLibraryUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LombokHighlightErrorFilter
implements HighlightInfoFilter {
    private static final Pattern LOMBOK_ANY_ANNOTATION_REQUIRED = Pattern.compile(JavaErrorBundle.message((String)"incompatible.types", (Object[])new Object[]{"lombok.*AnyAnnotation\\[\\]", "__*"}));
    private final Map<HighlightSeverity, Map<TextAttributesKey, List<LombokHighlightFilter>>> registeredFilters = new HashMap<HighlightSeverity, Map<TextAttributesKey, List<LombokHighlightFilter>>>();
    private final Map<HighlightSeverity, Map<TextAttributesKey, List<LombokHighlightFixHook>>> registeredHooks = new HashMap<HighlightSeverity, Map<TextAttributesKey, List<LombokHighlightFixHook>>>();

    public LombokHighlightErrorFilter() {
        for (LombokHighlightFilter lombokHighlightFilter : LombokHighlightFilter.values()) {
            this.registeredFilters.computeIfAbsent(lombokHighlightFilter.severity, s -> new HashMap()).computeIfAbsent(lombokHighlightFilter.key, k -> new ArrayList()).add(lombokHighlightFilter);
        }
        for (Enum enum_ : LombokHighlightFixHook.values()) {
            this.registeredHooks.computeIfAbsent(((LombokHighlightFixHook)enum_).severity, s -> new HashMap()).computeIfAbsent(((LombokHighlightFixHook)enum_).key, k -> new ArrayList()).add(enum_);
        }
    }

    public boolean accept(@NotNull HighlightInfo highlightInfo, @Nullable PsiFile file) {
        if (highlightInfo == null) {
            LombokHighlightErrorFilter.$$$reportNull$$$0(0);
        }
        if (null == file) {
            return true;
        }
        Project project = file.getProject();
        if (!LombokLibraryUtil.hasLombokLibrary(project)) {
            return true;
        }
        PsiElement highlightedElement = file.findElementAt(highlightInfo.getStartOffset());
        if (null == highlightedElement) {
            return true;
        }
        boolean acceptHighlight = this.registeredFilters.getOrDefault(highlightInfo.getSeverity(), Collections.emptyMap()).getOrDefault(highlightInfo.type.getAttributesKey(), Collections.emptyList()).stream().filter(filter -> filter.descriptionCheck(highlightInfo.getDescription(), highlightedElement)).allMatch(filter -> filter.accept(highlightedElement));
        if (!acceptHighlight) {
            return false;
        }
        String description = highlightInfo.getDescription();
        if (HighlightSeverity.ERROR.equals((Object)highlightInfo.getSeverity()) && (OnXAnnotationHandler.isOnXParameterAnnotation(highlightInfo, file) || OnXAnnotationHandler.isOnXParameterValue(highlightInfo, file) || description != null && LOMBOK_ANY_ANNOTATION_REQUIRED.matcher(description).matches())) {
            return false;
        }
        this.registeredHooks.getOrDefault(highlightInfo.getSeverity(), Collections.emptyMap()).getOrDefault(highlightInfo.type.getAttributesKey(), Collections.emptyList()).stream().filter(filter -> filter.descriptionCheck(highlightInfo.getDescription())).forEach(filter -> filter.processHook(highlightedElement, highlightInfo));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfo", "de/plushnikov/intellij/plugin/extension/LombokHighlightErrorFilter", "accept"));
    }

    private static enum LombokHighlightFilter {
        VARIABLE_MIGHT_NOT_BEEN_INITIALIZED(HighlightSeverity.ERROR, CodeInsightColors.ERRORS_ATTRIBUTES){

            @Override
            public boolean descriptionCheck(@Nullable String description, PsiElement highlightedElement) {
                return JavaErrorBundle.message((String)"variable.not.initialized", (Object[])new Object[]{highlightedElement.getText()}).equals(description);
            }

            @Override
            public boolean accept(@NotNull PsiElement highlightedElement) {
                if (highlightedElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !LazyGetterHandler.isLazyGetterHandled(highlightedElement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightedElement", "de/plushnikov/intellij/plugin/extension/LombokHighlightErrorFilter$LombokHighlightFilter$1", "accept"));
            }
        }
        ,
        CONSTANT_EXPRESSION_REQUIRED(HighlightSeverity.ERROR, CodeInsightColors.ERRORS_ATTRIBUTES){

            @Override
            public boolean descriptionCheck(@Nullable String description, PsiElement highlightedElement) {
                return JavaErrorBundle.message((String)"constant.expression.required", (Object[])new Object[0]).equals(description);
            }

            @Override
            public boolean accept(@NotNull PsiElement highlightedElement) {
                if (highlightedElement == null) {
                    2.$$$reportNull$$$0(0);
                }
                return !FieldNameConstantsHandler.isFiledNameConstants(highlightedElement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightedElement", "de/plushnikov/intellij/plugin/extension/LombokHighlightErrorFilter$LombokHighlightFilter$2", "accept"));
            }
        }
        ,
        VARIABLE_INITIALIZER_IS_REDUNDANT(HighlightSeverity.WARNING, CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES){
            private final Pattern pattern = Pattern.compile(JavaBundle.message((String)"inspection.unused.assignment.problem.descriptor2", (Object[])new Object[]{"(.+)", "(.+)"}));

            @Override
            public boolean descriptionCheck(@Nullable String description, PsiElement highlightedElement) {
                return description != null && this.pattern.matcher(description).matches();
            }

            @Override
            public boolean accept(@NotNull PsiElement highlightedElement) {
                if (highlightedElement == null) {
                    3.$$$reportNull$$$0(0);
                }
                return !BuilderHandler.isDefaultBuilderValue(highlightedElement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightedElement", "de/plushnikov/intellij/plugin/extension/LombokHighlightErrorFilter$LombokHighlightFilter$3", "accept"));
            }
        }
        ,
        METHOD_INVOCATION_WILL_PRODUCE_NPE(HighlightSeverity.WARNING, CodeInsightColors.WARNINGS_ATTRIBUTES){
            private final CommonProblemDescriptor descriptor = new CommonProblemDescriptor(){

                @NotNull
                public String getDescriptionTemplate() {
                    String string = JavaAnalysisBundle.message((String)"dataflow.message.npe.method.invocation.sure", (Object[])new Object[0]);
                    if (string == null) {
                        LombokHighlightFilter.1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public QuickFix @Nullable [] getFixes() {
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "de/plushnikov/intellij/plugin/extension/LombokHighlightErrorFilter$LombokHighlightFilter$4$1", "getDescriptionTemplate"));
                }
            };

            @Override
            public boolean descriptionCheck(@Nullable String description, PsiElement highlightedElement) {
                return ProblemDescriptorUtil.renderDescriptionMessage((CommonProblemDescriptor)this.descriptor, (PsiElement)highlightedElement).equals(description);
            }

            @Override
            public boolean accept(@NotNull PsiElement highlightedElement) {
                if (highlightedElement == null) {
                    4.$$$reportNull$$$0(0);
                }
                return !LazyGetterHandler.isLazyGetterHandled(highlightedElement) || !LazyGetterHandler.isInitializedInConstructors(highlightedElement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightedElement", "de/plushnikov/intellij/plugin/extension/LombokHighlightErrorFilter$LombokHighlightFilter$4", "accept"));
            }
        }
        ,
        CONSTANT_CONDITIONS_DEFAULT_BUILDER_CAN_BE_SIMPLIFIED(HighlightSeverity.WARNING, CodeInsightColors.WARNINGS_ATTRIBUTES){
            private final Pattern patternCanBeSimplified = this.preparePattern(InspectionGadgetsBundle.message((String)"simplifiable.conditional.expression.problem.descriptor", (Object[])new Object[0]), "''{0}''");
            private final Pattern patternIsAlways = this.preparePattern(JavaAnalysisBundle.message((String)"dataflow.message.constant.condition", (Object[])new Object[0]), "<code>{0, choice, 0#false|1#true}</code>");

            @NotNull
            private Pattern preparePattern(String message, String s) {
                Pattern pattern = Pattern.compile(ProblemDescriptorUtil.removeLocReference((String)message).replace("<code>#ref</code>", "'(.+)'").replace(s, "'(.+)'"));
                if (pattern == null) {
                    5.$$$reportNull$$$0(0);
                }
                return pattern;
            }

            @Override
            public boolean descriptionCheck(@Nullable String description, PsiElement highlightedElement) {
                return description != null && (this.patternCanBeSimplified.matcher(description).matches() || this.patternIsAlways.matcher(description).matches());
            }

            @Override
            public boolean accept(@NotNull PsiElement highlightedElement) {
                PsiReferenceExpression parent;
                if (highlightedElement == null) {
                    5.$$$reportNull$$$0(1);
                }
                if ((parent = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)highlightedElement, PsiReferenceExpression.class)) == null) {
                    return true;
                }
                PsiElement resolve = parent.resolve();
                if (!(resolve instanceof PsiField)) {
                    return true;
                }
                return !PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)((PsiField)resolve), "lombok.Builder.Default");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "de/plushnikov/intellij/plugin/extension/LombokHighlightErrorFilter$LombokHighlightFilter$5";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "highlightedElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "preparePattern";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "de/plushnikov/intellij/plugin/extension/LombokHighlightErrorFilter$LombokHighlightFilter$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "accept";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        private final HighlightSeverity severity;
        private final TextAttributesKey key;

        private LombokHighlightFilter(HighlightSeverity severity, TextAttributesKey key) {
            if (severity == null) {
                LombokHighlightFilter.$$$reportNull$$$0(0);
            }
            this.severity = severity;
            this.key = key;
        }

        public abstract boolean descriptionCheck(@Nullable String var1, PsiElement var2);

        public abstract boolean accept(@NotNull PsiElement var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "de/plushnikov/intellij/plugin/extension/LombokHighlightErrorFilter$LombokHighlightFilter", "<init>"));
        }
    }

    private static enum LombokHighlightFixHook {
        UNHANDLED_EXCEPTION(HighlightSeverity.ERROR, CodeInsightColors.ERRORS_ATTRIBUTES){
            private final Pattern pattern = this.preparePattern(1);
            private final Pattern pattern2 = this.preparePattern(2);

            @NotNull
            private Pattern preparePattern(int count) {
                Pattern pattern = Pattern.compile(JavaErrorBundle.message((String)"unhandled.exceptions", (Object[])new Object[]{".*", count}));
                if (pattern == null) {
                    1.$$$reportNull$$$0(0);
                }
                return pattern;
            }

            @Override
            public boolean descriptionCheck(@Nullable String description) {
                return description != null && (this.pattern.matcher(description).matches() || this.pattern2.matcher(description).matches());
            }

            @Override
            public void processHook(@NotNull PsiElement highlightedElement, @NotNull HighlightInfo highlightInfo) {
                PsiElement importantParent;
                if (highlightedElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (highlightInfo == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((importantParent = PsiTreeUtil.getParentOfType((PsiElement)highlightedElement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class, PsiMethodReferenceExpression.class, PsiClassInitializer.class})) instanceof PsiMethod) {
                    AddAnnotationFix fix = new AddAnnotationFix("lombok.SneakyThrows", (PsiModifierListOwner)importantParent, new String[0]);
                    highlightInfo.registerFix((IntentionAction)fix, null, null, null, null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "de/plushnikov/intellij/plugin/extension/LombokHighlightErrorFilter$LombokHighlightFixHook$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "highlightedElement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "highlightInfo";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "preparePattern";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "de/plushnikov/intellij/plugin/extension/LombokHighlightErrorFilter$LombokHighlightFixHook$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "processHook";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        private final HighlightSeverity severity;
        private final TextAttributesKey key;

        private LombokHighlightFixHook(HighlightSeverity severity, TextAttributesKey key) {
            if (severity == null) {
                LombokHighlightFixHook.$$$reportNull$$$0(0);
            }
            this.severity = severity;
            this.key = key;
        }

        public abstract boolean descriptionCheck(@Nullable String var1);

        public abstract void processHook(@NotNull PsiElement var1, @NotNull HighlightInfo var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "de/plushnikov/intellij/plugin/extension/LombokHighlightErrorFilter$LombokHighlightFixHook", "<init>"));
        }
    }
}

