/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.intention.valvar.to;

import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.intention.valvar.AbstractValVarIntentionAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractReplaceExplicitTypeWithVariableIntentionAction
extends AbstractValVarIntentionAction {
    private final String variableClassName;

    public AbstractReplaceExplicitTypeWithVariableIntentionAction(String variableClassName) {
        this.variableClassName = variableClassName;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = LombokBundle.message("replace.explicit.type.with.0.lombok", StringUtil.getShortName((String)this.variableClassName));
        if (string == null) {
            AbstractReplaceExplicitTypeWithVariableIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isAvailableOnDeclarationStatement(PsiDeclarationStatement context) {
        if (PsiUtil.isLanguageLevel10OrHigher((PsiElement)context)) {
            return false;
        }
        PsiElement[] declaredElements = context.getDeclaredElements();
        if (declaredElements.length != 1) {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiLocalVariable)) {
            return false;
        }
        PsiLocalVariable localVariable = (PsiLocalVariable)declaredElement;
        if (!localVariable.hasInitializer()) {
            return false;
        }
        PsiExpression initializer = localVariable.getInitializer();
        if (initializer instanceof PsiArrayInitializerExpression || initializer instanceof PsiLambdaExpression) {
            return false;
        }
        if (localVariable.getTypeElement().isInferredType()) {
            return false;
        }
        return this.isAvailableOnDeclarationCustom(context, localVariable);
    }

    protected abstract boolean isAvailableOnDeclarationCustom(@NotNull PsiDeclarationStatement var1, @NotNull PsiLocalVariable var2);

    @Override
    public void invokeOnDeclarationStatement(PsiDeclarationStatement declarationStatement) {
        if (declarationStatement.getDeclaredElements().length == 1) {
            PsiLocalVariable localVariable = (PsiLocalVariable)declarationStatement.getDeclaredElements()[0];
            this.invokeOnVariable((PsiVariable)localVariable);
        }
    }

    @Override
    public void invokeOnVariable(PsiVariable psiVariable) {
        Project project = psiVariable.getProject();
        psiVariable.normalizeDeclaration();
        PsiTypeElement typeElement = psiVariable.getTypeElement();
        if (typeElement == null || typeElement.isInferredType()) {
            return;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        PsiClass variablePsiClass = JavaPsiFacade.getInstance((Project)project).findClass(this.variableClassName, psiVariable.getResolveScope());
        if (variablePsiClass == null) {
            return;
        }
        PsiJavaCodeReferenceElement referenceElementByFQClassName = elementFactory.createReferenceElementByFQClassName(this.variableClassName, psiVariable.getResolveScope());
        typeElement = (PsiTypeElement)IntroduceVariableBase.expandDiamondsAndReplaceExplicitTypeWithVar((PsiTypeElement)typeElement, (PsiElement)typeElement);
        typeElement.deleteChildRange(typeElement.getFirstChild(), typeElement.getLastChild());
        typeElement.add((PsiElement)referenceElementByFQClassName);
        RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments((PsiElement)psiVariable);
        this.executeAfterReplacing(psiVariable);
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiVariable);
    }

    protected abstract void executeAfterReplacing(PsiVariable var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "de/plushnikov/intellij/plugin/intention/valvar/to/AbstractReplaceExplicitTypeWithVariableIntentionAction", "getFamilyName"));
    }
}

