/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.lombokconfig;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.indexing.FileBasedIndex;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigValue;
import de.plushnikov.intellij.plugin.lombokconfig.LombokConfigChangeListener;
import de.plushnikov.intellij.plugin.lombokconfig.LombokConfigIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigDiscovery {
    @NotNull
    public static ConfigDiscovery getInstance() {
        ConfigDiscovery configDiscovery = (ConfigDiscovery)ApplicationManager.getApplication().getService(ConfigDiscovery.class);
        if (configDiscovery == null) {
            ConfigDiscovery.$$$reportNull$$$0(0);
        }
        return configDiscovery;
    }

    @NotNull
    public Collection<String> getMultipleValueLombokConfigProperty(@NotNull ConfigKey configKey, @NotNull PsiClass psiClass) {
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(1);
        }
        if (psiClass == null) {
            ConfigDiscovery.$$$reportNull$$$0(2);
        }
        return this.getConfigProperty(configKey, psiClass);
    }

    @NotNull
    public String getStringLombokConfigProperty(@NotNull ConfigKey configKey, @NotNull PsiClass psiClass) {
        Collection<String> result;
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(3);
        }
        if (psiClass == null) {
            ConfigDiscovery.$$$reportNull$$$0(4);
        }
        if (!(result = this.getConfigProperty(configKey, psiClass)).isEmpty()) {
            String string = result.iterator().next();
            if (string == null) {
                ConfigDiscovery.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = configKey.getConfigDefaultValue();
        if (string == null) {
            ConfigDiscovery.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean getBooleanLombokConfigProperty(@NotNull ConfigKey configKey, @NotNull PsiClass psiClass) {
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(7);
        }
        if (psiClass == null) {
            ConfigDiscovery.$$$reportNull$$$0(8);
        }
        String configProperty = this.getStringLombokConfigProperty(configKey, psiClass);
        return Boolean.parseBoolean(configProperty);
    }

    @NotNull
    private Collection<String> getConfigProperty(@NotNull ConfigKey configKey, @NotNull PsiClass psiClass) {
        PsiFile psiFile;
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(9);
        }
        if (psiClass == null) {
            ConfigDiscovery.$$$reportNull$$$0(10);
        }
        if ((psiFile = ConfigDiscovery.calculatePsiFile(psiClass)) != null) {
            Collection<String> collection = this.discoverPropertyWithCache(configKey, psiFile);
            if (collection == null) {
                ConfigDiscovery.$$$reportNull$$$0(11);
            }
            return collection;
        }
        List<String> list = Collections.singletonList(configKey.getConfigDefaultValue());
        if (list == null) {
            ConfigDiscovery.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    private static PsiFile calculatePsiFile(@NotNull PsiClass psiClass) {
        PsiFile psiFile;
        if (psiClass == null) {
            ConfigDiscovery.$$$reportNull$$$0(13);
        }
        if ((psiFile = psiClass.getContainingFile()) != null) {
            psiFile = psiFile.getOriginalFile();
        }
        return psiFile;
    }

    @NotNull
    protected Collection<String> discoverPropertyWithCache(@NotNull ConfigKey configKey, @NotNull PsiFile psiFile) {
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(14);
        }
        if (psiFile == null) {
            ConfigDiscovery.$$$reportNull$$$0(15);
        }
        Collection collection = (Collection)((Map)CachedValuesManager.getCachedValue((PsiElement)psiFile, () -> {
            ConcurrentMap result = ConcurrentFactoryMap.createMap(configKeyInner -> this.discoverProperty((ConfigKey)((Object)((Object)configKeyInner)), psiFile));
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{LombokConfigChangeListener.CONFIG_CHANGE_TRACKER});
        })).get((Object)configKey);
        if (collection == null) {
            ConfigDiscovery.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    protected Collection<String> discoverProperty(@NotNull ConfigKey configKey, @NotNull PsiFile psiFile) {
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(17);
        }
        if (psiFile == null) {
            ConfigDiscovery.$$$reportNull$$$0(18);
        }
        if (configKey.isConfigScalarValue()) {
            return this.discoverScalarProperty(configKey, psiFile);
        }
        return this.discoverCollectionProperty(configKey, psiFile);
    }

    @NotNull
    private Collection<String> discoverScalarProperty(@NotNull ConfigKey configKey, @NotNull PsiFile psiFile) {
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(19);
        }
        if (psiFile == null) {
            ConfigDiscovery.$$$reportNull$$$0(20);
        }
        for (VirtualFile currentFile = psiFile.getVirtualFile(); currentFile != null; currentFile = currentFile.getParent()) {
            ConfigValue configValue = this.readProperty(configKey, psiFile.getProject(), currentFile);
            if (null == configValue) continue;
            if (null == configValue.getValue()) {
                if (!configValue.isStopBubbling()) continue;
                break;
            }
            List<String> list = Collections.singletonList(configValue.getValue());
            if (list == null) {
                ConfigDiscovery.$$$reportNull$$$0(21);
            }
            return list;
        }
        List<String> list = Collections.singletonList(configKey.getConfigDefaultValue());
        if (list == null) {
            ConfigDiscovery.$$$reportNull$$$0(22);
        }
        return list;
    }

    @VisibleForTesting
    protected FileBasedIndex getFileBasedIndex() {
        return FileBasedIndex.getInstance();
    }

    @Nullable
    private ConfigValue readProperty(@NotNull ConfigKey configKey, @NotNull Project project, @NotNull VirtualFile directory) {
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(23);
        }
        if (project == null) {
            ConfigDiscovery.$$$reportNull$$$0(24);
        }
        if (directory == null) {
            ConfigDiscovery.$$$reportNull$$$0(25);
        }
        GlobalSearchScope directoryScope = GlobalSearchScopes.directoryScope((Project)project, (VirtualFile)directory, (boolean)false);
        List values = this.getFileBasedIndex().getValues(LombokConfigIndex.NAME, (Object)configKey, directoryScope);
        if (!values.isEmpty()) {
            return (ConfigValue)values.iterator().next();
        }
        return null;
    }

    @NotNull
    private Collection<String> discoverCollectionProperty(@NotNull ConfigKey configKey, @NotNull PsiFile file) {
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(26);
        }
        if (file == null) {
            ConfigDiscovery.$$$reportNull$$$0(27);
        }
        ArrayList<String> properties = new ArrayList<String>();
        for (VirtualFile currentFile = file.getVirtualFile(); currentFile != null; currentFile = currentFile.getParent()) {
            ConfigValue configValue = this.readProperty(configKey, file.getProject(), currentFile);
            if (null == configValue) continue;
            if (null == configValue.getValue()) {
                if (!configValue.isStopBubbling()) continue;
                break;
            }
            properties.add(configValue.getValue());
        }
        Collections.reverse(properties);
        HashSet<String> result = new HashSet<String>();
        for (String configProperty : properties) {
            String[] values;
            if (!StringUtil.isNotEmpty((String)configProperty)) continue;
            for (String value : values = configProperty.split(";")) {
                if (value.startsWith("+")) {
                    result.add(value.substring(1));
                    continue;
                }
                if (!value.startsWith("-")) continue;
                result.remove(value.substring(1));
            }
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            ConfigDiscovery.$$$reportNull$$$0(28);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/lombokconfig/ConfigDiscovery";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 14: 
            case 17: 
            case 19: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/lombokconfig/ConfigDiscovery";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLombokConfigProperty";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigProperty";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "discoverPropertyWithCache";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "discoverScalarProperty";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "discoverCollectionProperty";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMultipleValueLombokConfigProperty";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStringLombokConfigProperty";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanLombokConfigProperty";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getConfigProperty";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "calculatePsiFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "discoverPropertyWithCache";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "discoverProperty";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "discoverScalarProperty";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "readProperty";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "discoverCollectionProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

