/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz.constructor;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.AbstractConstructorClassProcessor;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RequiredArgsConstructorProcessor
extends AbstractConstructorClassProcessor {
    public RequiredArgsConstructorProcessor() {
        super("lombok.RequiredArgsConstructor", PsiMethod.class);
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiAnnotation == null) {
            RequiredArgsConstructorProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            RequiredArgsConstructorProcessor.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            RequiredArgsConstructorProcessor.$$$reportNull$$$0(2);
        }
        boolean result = super.validate(psiAnnotation, psiClass, builder);
        Collection<PsiField> allReqFields = this.getRequiredFields(psiClass);
        String staticConstructorName = this.getStaticConstructorName(psiAnnotation);
        return result &= this.validateIsConstructorNotDefined(psiClass, staticConstructorName, allReqFields, builder);
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target) {
        String methodVisibility;
        if (psiClass == null) {
            RequiredArgsConstructorProcessor.$$$reportNull$$$0(3);
        }
        if (psiAnnotation == null) {
            RequiredArgsConstructorProcessor.$$$reportNull$$$0(4);
        }
        if (target == null) {
            RequiredArgsConstructorProcessor.$$$reportNull$$$0(5);
        }
        if (null != (methodVisibility = LombokProcessorUtil.getAccessVisibility(psiAnnotation))) {
            target.addAll(this.createRequiredArgsConstructor(psiClass, methodVisibility, psiAnnotation, this.getStaticConstructorName(psiAnnotation)));
        }
    }

    @NotNull
    public Collection<PsiMethod> createRequiredArgsConstructor(@NotNull PsiClass psiClass, @PsiModifier.ModifierConstant @NotNull String methodModifier, @NotNull PsiAnnotation psiAnnotation, @Nullable String staticName) {
        if (psiClass == null) {
            RequiredArgsConstructorProcessor.$$$reportNull$$$0(6);
        }
        if (methodModifier == null) {
            RequiredArgsConstructorProcessor.$$$reportNull$$$0(7);
        }
        if (psiAnnotation == null) {
            RequiredArgsConstructorProcessor.$$$reportNull$$$0(8);
        }
        Collection<PsiMethod> collection = this.createRequiredArgsConstructor(psiClass, methodModifier, psiAnnotation, staticName, false);
        if (collection == null) {
            RequiredArgsConstructorProcessor.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiMethod> createRequiredArgsConstructor(@NotNull PsiClass psiClass, @PsiModifier.ModifierConstant @NotNull String methodModifier, @NotNull PsiAnnotation psiAnnotation, @Nullable String staticName, boolean skipConstructorIfAnyConstructorExists) {
        if (psiClass == null) {
            RequiredArgsConstructorProcessor.$$$reportNull$$$0(10);
        }
        if (methodModifier == null) {
            RequiredArgsConstructorProcessor.$$$reportNull$$$0(11);
        }
        if (psiAnnotation == null) {
            RequiredArgsConstructorProcessor.$$$reportNull$$$0(12);
        }
        Collection<PsiField> allReqFields = this.getRequiredFields(psiClass);
        Collection<PsiMethod> collection = this.createConstructorMethod(psiClass, methodModifier, psiAnnotation, false, allReqFields, staticName, skipConstructorIfAnyConstructorExists);
        if (collection == null) {
            RequiredArgsConstructorProcessor.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        PsiClass containingClass;
        if (psiField == null) {
            RequiredArgsConstructorProcessor.$$$reportNull$$$0(14);
        }
        if (psiAnnotation == null) {
            RequiredArgsConstructorProcessor.$$$reportNull$$$0(15);
        }
        if (null != (containingClass = psiField.getContainingClass()) && PsiClassUtil.getNames(this.getRequiredFields(containingClass)).contains(psiField.getName())) {
            return LombokPsiElementUsage.WRITE;
        }
        return LombokPsiElementUsage.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodModifier";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/constructor/RequiredArgsConstructorProcessor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/constructor/RequiredArgsConstructorProcessor";
                break;
            }
            case 9: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequiredArgsConstructor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRequiredArgsConstructor";
                break;
            }
            case 9: 
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

