/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.field;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.problem.LombokProblem;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.problem.ProblemEmptyBuilder;
import de.plushnikov.intellij.plugin.problem.ProblemNewBuilder;
import de.plushnikov.intellij.plugin.processor.AbstractProcessor;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.processor.field.FieldProcessor;
import de.plushnikov.intellij.plugin.thirdparty.LombokCopyableAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import de.plushnikov.intellij.plugin.util.PsiMethodUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFieldProcessor
extends AbstractProcessor
implements FieldProcessor {
    AbstractFieldProcessor(@NotNull Class<? extends PsiElement> supportedClass, @NotNull String supportedAnnotationClass) {
        if (supportedClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(0);
        }
        if (supportedAnnotationClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(1);
        }
        super(supportedClass, supportedAnnotationClass);
    }

    AbstractFieldProcessor(@NotNull Class<? extends PsiElement> supportedClass, @NotNull String supportedAnnotationClass, @NotNull String equivalentAnnotationClass) {
        if (supportedClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(2);
        }
        if (supportedAnnotationClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(3);
        }
        if (equivalentAnnotationClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(4);
        }
        super(supportedClass, supportedAnnotationClass, equivalentAnnotationClass);
    }

    @Override
    @NotNull
    public List<? super PsiElement> process(@NotNull PsiClass psiClass, @Nullable String nameHint) {
        if (psiClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(5);
        }
        ArrayList result = new ArrayList();
        for (PsiField psiField : PsiClassUtil.collectClassFieldsIntern(psiClass)) {
            PsiAnnotation psiAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, this.getSupportedAnnotationClasses());
            if (null == psiAnnotation || !this.possibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation, psiField) || !this.validate(psiAnnotation, psiField, ProblemEmptyBuilder.getInstance())) continue;
            this.generatePsiElements(psiField, psiAnnotation, result);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    protected boolean possibleToGenerateElementNamed(@Nullable String nameHint, @NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField) {
        if (psiClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(7);
        }
        if (psiAnnotation == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(8);
        }
        if (psiField == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(9);
        }
        return true;
    }

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(10);
        }
        ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
        for (PsiField psiField : PsiClassUtil.collectClassFieldsIntern(psiClass)) {
            PsiAnnotation psiAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, this.getSupportedAnnotationClasses());
            if (null == psiAnnotation) continue;
            result.add(psiAnnotation);
        }
        ArrayList<PsiAnnotation> arrayList = result;
        if (arrayList == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<LombokProblem> verifyAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(12);
        }
        Collection<LombokProblem> result = Collections.emptyList();
        PsiField psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiField.class);
        if (null != psiField) {
            ProblemNewBuilder problemNewBuilder = new ProblemNewBuilder();
            this.validate(psiAnnotation, psiField, problemNewBuilder);
            result = problemNewBuilder.getProblems();
        }
        List<LombokProblem> list = result;
        if (list == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(13);
        }
        return list;
    }

    protected abstract boolean validate(@NotNull PsiAnnotation var1, @NotNull PsiField var2, @NotNull ProblemBuilder var3);

    protected void validateOnXAnnotations(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField, @NotNull ProblemBuilder builder, @NotNull String parameterName) {
        Iterable<String> onMethodAnnotations;
        List<PsiAnnotation> copyableAnnotations;
        if (psiAnnotation == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(14);
        }
        if (psiField == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(15);
        }
        if (builder == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(16);
        }
        if (parameterName == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(17);
        }
        if (!(copyableAnnotations = AbstractFieldProcessor.copyableAnnotations(psiField, LombokCopyableAnnotations.BASE_COPYABLE)).isEmpty()) {
            Iterable<String> onXAnnotations = LombokProcessorUtil.getOnX(psiAnnotation, parameterName);
            List copyableAnnotationsFQNs = ContainerUtil.map(copyableAnnotations, PsiAnnotation::getQualifiedName);
            for (String copyableAnnotationFQN : copyableAnnotationsFQNs) {
                for (String onXAnnotation : onXAnnotations) {
                    if (!onXAnnotation.startsWith(copyableAnnotationFQN)) continue;
                    builder.addError(LombokBundle.message("inspection.message.annotation.copy.duplicate", copyableAnnotationFQN));
                }
            }
        }
        if (psiField.isDeprecated() && StreamSupport.stream((onMethodAnnotations = LombokProcessorUtil.getOnX(psiAnnotation, "onMethod")).spliterator(), false).anyMatch("java.lang.Deprecated"::equals)) {
            builder.addError(LombokBundle.message("inspection.message.annotation.copy.duplicate", "java.lang.Deprecated"));
        }
    }

    protected abstract void generatePsiElements(@NotNull PsiField var1, @NotNull PsiAnnotation var2, @NotNull List<? super PsiElement> var3);

    protected boolean validateExistingMethods(@NotNull PsiField psiField, @NotNull ProblemBuilder builder, boolean isGetter) {
        if (psiField == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(18);
        }
        if (builder == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(19);
        }
        boolean result = true;
        PsiClass psiClass = psiField.getContainingClass();
        if (null != psiClass) {
            boolean isBoolean = PsiType.BOOLEAN.equals((Object)psiField.getType());
            AccessorsInfo accessorsInfo = AccessorsInfo.build(psiField);
            String fieldName = psiField.getName();
            Collection<PsiMethod> classMethods = PsiClassUtil.collectClassMethodsIntern(psiClass);
            AbstractFieldProcessor.filterByAccessorName(isGetter, isBoolean, accessorsInfo, fieldName, classMethods);
            this.filterToleratedElements(classMethods);
            Collection<String> allAccessorsNames = isGetter ? LombokUtils.toAllGetterNames(accessorsInfo, fieldName, isBoolean) : LombokUtils.toAllSetterNames(accessorsInfo, fieldName, isBoolean);
            for (String methodName : allAccessorsNames) {
                if (!PsiMethodUtil.hasSimilarMethod(classMethods, methodName, isGetter ? 0 : 1)) continue;
                String accessorName = isGetter ? LombokUtils.getGetterName(psiField) : LombokUtils.getSetterName(psiField, isBoolean);
                builder.addWarning(LombokBundle.message("inspection.message.not.generated.s.method.with.similar.name.s.already.exists", new Object[0]), accessorName, methodName);
                result = false;
            }
        }
        return result;
    }

    private static void filterByAccessorName(boolean isGetter, boolean isBoolean, AccessorsInfo accessorsInfo, String fieldName, Collection<PsiMethod> classMethods) {
        String baseFieldName = StringUtil.trimStart((String)accessorsInfo.removePrefix(fieldName), (String)"is");
        classMethods.removeIf(method -> {
            String methodName = method.getName();
            if (!StringUtil.containsIgnoreCase((String)methodName, (String)baseFieldName)) {
                return true;
            }
            return !accessorsInfo.isFluent() && !AbstractFieldProcessor.isAccessorName(isGetter, isBoolean, methodName);
        });
    }

    private static boolean isAccessorName(boolean isGetter, boolean isBoolean, String methodName) {
        if (isGetter) {
            return isBoolean && methodName.startsWith("is") || methodName.startsWith("get");
        }
        return methodName.startsWith("set");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedAnnotationClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equivalentAnnotationClass";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/field/AbstractFieldProcessor";
                break;
            }
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 9: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/field/AbstractFieldProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "possibleToGenerateElementNamed";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "verifyAnnotation";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "validateOnXAnnotations";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "validateExistingMethods";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

