/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.handler;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import de.plushnikov.intellij.plugin.util.PsiMethodUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class EqualsAndHashCodeToStringHandler {
    private static final String TO_STRING_RANK_ANNOTATION_PARAMETER = "rank";

    public Collection<MemberInfo> filterFields(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, boolean filterTransient, String includeAnnotationProperty) {
        Collection<String> excludeProperty;
        Collection<Object> ofProperty;
        if (psiClass == null) {
            EqualsAndHashCodeToStringHandler.$$$reportNull$$$0(0);
        }
        if (psiAnnotation == null) {
            EqualsAndHashCodeToStringHandler.$$$reportNull$$$0(1);
        }
        boolean explicitOf = PsiAnnotationUtil.hasDeclaredProperty(psiAnnotation, "of");
        boolean onlyExplicitlyIncluded = PsiAnnotationUtil.getBooleanAnnotationValue(psiAnnotation, "onlyExplicitlyIncluded", false);
        String annotationFQN = psiAnnotation.getQualifiedName();
        String annotationIncludeFQN = annotationFQN + ".Include";
        String annotationExcludeFQN = annotationFQN + ".Exclude";
        if (!explicitOf) {
            ofProperty = Collections.emptyList();
            excludeProperty = this.makeSet(PsiAnnotationUtil.getAnnotationValues(psiAnnotation, "exclude", String.class));
        } else {
            ofProperty = this.makeSet(PsiAnnotationUtil.getAnnotationValues(psiAnnotation, "of", String.class));
            excludeProperty = Collections.emptyList();
        }
        Collection<PsiMember> psiMembers = PsiClassUtil.collectClassMemberIntern(psiClass);
        ArrayList<String> fieldNames2BeReplaced = new ArrayList<String>();
        ArrayList<MemberInfo> result = new ArrayList<MemberInfo>(psiMembers.size());
        for (PsiMember psiMember : psiMembers) {
            PsiAnnotation includeAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiMember, annotationIncludeFQN);
            if (null == includeAnnotation) {
                PsiField psiField;
                String fieldName;
                if (onlyExplicitlyIncluded || !(psiMember instanceof PsiField) || null == (fieldName = (psiField = (PsiField)psiMember).getName())) continue;
                if (ofProperty.contains(fieldName)) {
                    result.add(new MemberInfo(psiField));
                    continue;
                }
                if (explicitOf || excludeProperty.contains(fieldName) || psiField.hasModifierProperty("static") || filterTransient && psiField.hasModifierProperty("transient") || fieldName.startsWith("$") || PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiField, annotationExcludeFQN)) continue;
                result.add(new MemberInfo(psiField, fieldName, true));
                continue;
            }
            String includeNameValue = PsiAnnotationUtil.getStringAnnotationValue(includeAnnotation, includeAnnotationProperty, "");
            String newMemberName = StringUtil.isEmptyOrSpaces((String)includeNameValue) ? psiMember.getName() : includeNameValue;
            if (psiMember instanceof PsiMethod) {
                PsiMethod psiMethod = (PsiMethod)psiMember;
                if (0 != psiMethod.getParameterList().getParametersCount()) continue;
                fieldNames2BeReplaced.add(newMemberName);
                int memberRank = this.calcMemberRank(includeAnnotation);
                result.add(new MemberInfo(psiMethod, psiMethod.getName(), memberRank));
                continue;
            }
            int memberRank = this.calcMemberRank(includeAnnotation);
            result.add(new MemberInfo((PsiField)psiMember, newMemberName, memberRank));
        }
        for (String fieldName : fieldNames2BeReplaced) {
            result.removeIf(memberInfo -> memberInfo.matchDefaultIncludedFieldName(fieldName));
        }
        result.sort(MemberInfo::compareTo);
        return result;
    }

    private int calcMemberRank(@NotNull PsiAnnotation includeAnnotation) {
        if (includeAnnotation == null) {
            EqualsAndHashCodeToStringHandler.$$$reportNull$$$0(2);
        }
        return PsiAnnotationUtil.getIntAnnotationValue(includeAnnotation, TO_STRING_RANK_ANNOTATION_PARAMETER, 0);
    }

    public String getMemberAccessorName(@NotNull MemberInfo memberInfo, boolean doNotUseGetters, @NotNull PsiClass psiClass) {
        if (memberInfo == null) {
            EqualsAndHashCodeToStringHandler.$$$reportNull$$$0(3);
        }
        if (psiClass == null) {
            EqualsAndHashCodeToStringHandler.$$$reportNull$$$0(4);
        }
        Object memberAccessor = null == memberInfo.getMethod() ? this.buildAttributeNameString(doNotUseGetters, memberInfo.getField(), psiClass) : memberInfo.getName() + "()";
        return memberAccessor;
    }

    private String buildAttributeNameString(boolean doNotUseGetters, @NotNull PsiField classField, @NotNull PsiClass psiClass) {
        PsiAnnotation getterLombokAnnotation;
        if (classField == null) {
            EqualsAndHashCodeToStringHandler.$$$reportNull$$$0(5);
        }
        if (psiClass == null) {
            EqualsAndHashCodeToStringHandler.$$$reportNull$$$0(6);
        }
        String fieldName = classField.getName();
        if (doNotUseGetters) {
            return fieldName;
        }
        String getterName = LombokUtils.getGetterName(classField);
        boolean annotatedWith = PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.Data", "lombok.Value", "lombok.Getter");
        boolean hasGetter = annotatedWith ? null == (getterLombokAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiClass, "lombok.Getter")) || null != LombokProcessorUtil.getMethodModifier(getterLombokAnnotation) : PsiMethodUtil.hasMethodByName(PsiClassUtil.collectClassMethodsIntern(psiClass), getterName, 0);
        return hasGetter ? getterName + "()" : fieldName;
    }

    private Collection<String> makeSet(@NotNull Collection<String> exclude) {
        if (exclude == null) {
            EqualsAndHashCodeToStringHandler.$$$reportNull$$$0(7);
        }
        if (exclude.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(exclude);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeAnnotation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classField";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exclude";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/processor/handler/EqualsAndHashCodeToStringHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "filterFields";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calcMemberRank";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getMemberAccessorName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "buildAttributeNameString";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "makeSet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MemberInfo
    implements Comparable<MemberInfo> {
        private final PsiField psiField;
        private final PsiMethod psiMethod;
        private final String memberName;
        private final boolean defaultInclude;
        private final int rankValue;

        MemberInfo(PsiField psiField) {
            this(psiField, psiField.getName(), false);
        }

        MemberInfo(PsiField psiField, String memberName, int rankValue) {
            this(psiField, memberName, false, rankValue);
        }

        MemberInfo(PsiField psiField, String memberName, boolean defaultInclude) {
            this(psiField, memberName, defaultInclude, 0);
        }

        private MemberInfo(PsiField psiField, String memberName, boolean defaultInclude, int rankValue) {
            this.psiField = psiField;
            this.psiMethod = null;
            this.memberName = memberName;
            this.defaultInclude = defaultInclude;
            this.rankValue = rankValue;
        }

        MemberInfo(PsiMethod psiMethod, String memberName, int rankValue) {
            this.psiField = null;
            this.psiMethod = psiMethod;
            this.memberName = memberName;
            this.defaultInclude = false;
            this.rankValue = rankValue;
        }

        public PsiField getField() {
            return this.psiField;
        }

        public PsiMethod getMethod() {
            return this.psiMethod;
        }

        public String getName() {
            return this.memberName;
        }

        public PsiType getType() {
            if (null != this.psiField) {
                return this.psiField.getType();
            }
            return this.psiMethod.getReturnType();
        }

        private boolean matchDefaultIncludedFieldName(String fieldName) {
            if (null != this.psiField && this.defaultInclude) {
                return fieldName.equals(this.psiField.getName());
            }
            return false;
        }

        @Override
        public int compareTo(@NotNull MemberInfo other) {
            if (other == null) {
                MemberInfo.$$$reportNull$$$0(0);
            }
            return Integer.compare(other.rankValue, this.rankValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "de/plushnikov/intellij/plugin/processor/handler/EqualsAndHashCodeToStringHandler$MemberInfo", "compareTo"));
        }
    }
}

