/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.util;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class PsiClassUtil {
    @NotNull
    public static Collection<PsiMethod> collectClassMethodsIntern(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiClassUtil.$$$reportNull$$$0(0);
        }
        if (psiClass instanceof PsiExtensibleClass) {
            return new ArrayList<PsiMethod>(((PsiExtensibleClass)psiClass).getOwnMethods());
        }
        Collection<PsiMethod> collection = PsiClassUtil.filterPsiElements(psiClass, PsiMethod.class);
        if (collection == null) {
            PsiClassUtil.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiField> collectClassFieldsIntern(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiClassUtil.$$$reportNull$$$0(2);
        }
        if (psiClass instanceof PsiExtensibleClass) {
            List list = ((PsiExtensibleClass)psiClass).getOwnFields();
            if (list == null) {
                PsiClassUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        Collection<PsiField> collection = PsiClassUtil.filterPsiElements(psiClass, PsiField.class);
        if (collection == null) {
            PsiClassUtil.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClass> collectInnerClassesIntern(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiClassUtil.$$$reportNull$$$0(5);
        }
        if (psiClass instanceof PsiExtensibleClass) {
            List list = ((PsiExtensibleClass)psiClass).getOwnInnerClasses();
            if (list == null) {
                PsiClassUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        Collection<PsiClass> collection = PsiClassUtil.filterPsiElements(psiClass, PsiClass.class);
        if (collection == null) {
            PsiClassUtil.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiMember> collectClassMemberIntern(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiClassUtil.$$$reportNull$$$0(8);
        }
        Collection collection = Arrays.stream(psiClass.getChildren()).filter(e -> e instanceof PsiField || e instanceof PsiMethod).map(PsiMember.class::cast).collect(Collectors.toList());
        if (collection == null) {
            PsiClassUtil.$$$reportNull$$$0(9);
        }
        return collection;
    }

    private static <T extends PsiElement> Collection<T> filterPsiElements(@NotNull PsiClass psiClass, @NotNull Class<T> desiredClass) {
        if (psiClass == null) {
            PsiClassUtil.$$$reportNull$$$0(10);
        }
        if (desiredClass == null) {
            PsiClassUtil.$$$reportNull$$$0(11);
        }
        return Arrays.stream(psiClass.getChildren()).filter(desiredClass::isInstance).map(desiredClass::cast).collect(Collectors.toList());
    }

    @NotNull
    public static Collection<PsiMethod> collectClassConstructorIntern(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiClassUtil.$$$reportNull$$$0(12);
        }
        Collection<PsiMethod> psiMethods = PsiClassUtil.collectClassMethodsIntern(psiClass);
        Collection collection = psiMethods.stream().filter(PsiMethod::isConstructor).collect(Collectors.toList());
        if (collection == null) {
            PsiClassUtil.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiMethod> collectClassStaticMethodsIntern(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiClassUtil.$$$reportNull$$$0(14);
        }
        Collection<PsiMethod> psiMethods = PsiClassUtil.collectClassMethodsIntern(psiClass);
        Collection collection = psiMethods.stream().filter(psiMethod -> psiMethod.hasModifierProperty("static")).collect(Collectors.toList());
        if (collection == null) {
            PsiClassUtil.$$$reportNull$$$0(15);
        }
        return collection;
    }

    public static boolean hasSuperClass(@NotNull PsiClass psiClass) {
        PsiClass superClass;
        if (psiClass == null) {
            PsiClassUtil.$$$reportNull$$$0(16);
        }
        return null != (superClass = psiClass.getSuperClass()) && !"java.lang.Object".equals(superClass.getQualifiedName()) || !PsiClassUtil.superTypesIsEmptyOrObjectOnly(psiClass);
    }

    private static boolean superTypesIsEmptyOrObjectOnly(@NotNull PsiClass psiClass) {
        PsiClassType[] superTypes;
        if (psiClass == null) {
            PsiClassUtil.$$$reportNull$$$0(17);
        }
        return (superTypes = psiClass.getSuperTypes()).length != 1 || "java.lang.Object".equals(superTypes[0].getCanonicalText());
    }

    @NotNull
    public static PsiClassType getWildcardClassType(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiClassUtil.$$$reportNull$$$0(18);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
        if (psiClass.hasTypeParameters()) {
            Object[] wildcardTypes = new PsiType[psiClass.getTypeParameters().length];
            Arrays.fill(wildcardTypes, PsiWildcardType.createUnbounded((PsiManager)psiClass.getManager()));
            PsiClassType psiClassType = elementFactory.createType(psiClass, (PsiType[])wildcardTypes);
            if (psiClassType == null) {
                PsiClassUtil.$$$reportNull$$$0(19);
            }
            return psiClassType;
        }
        PsiClassType psiClassType = elementFactory.createType(psiClass);
        if (psiClassType == null) {
            PsiClassUtil.$$$reportNull$$$0(20);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getTypeWithGenerics(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiClassUtil.$$$reportNull$$$0(21);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
        PsiType[] psiTypes = (PsiType[])Stream.of(psiClass.getTypeParameters()).map(arg_0 -> ((PsiElementFactory)factory).createType(arg_0)).toArray(PsiType[]::new);
        if (psiTypes.length > 0) {
            PsiClassType psiClassType = factory.createType(psiClass, psiTypes);
            if (psiClassType == null) {
                PsiClassUtil.$$$reportNull$$$0(22);
            }
            return psiClassType;
        }
        PsiClassType psiClassType = factory.createType(psiClass);
        if (psiClassType == null) {
            PsiClassUtil.$$$reportNull$$$0(23);
        }
        return psiClassType;
    }

    public static Optional<PsiClass> getInnerClassInternByName(@NotNull PsiClass psiClass, @NotNull String className) {
        if (psiClass == null) {
            PsiClassUtil.$$$reportNull$$$0(24);
        }
        if (className == null) {
            PsiClassUtil.$$$reportNull$$$0(25);
        }
        Collection<PsiClass> innerClasses = PsiClassUtil.collectInnerClassesIntern(psiClass);
        return innerClasses.stream().filter(innerClass -> className.equals(innerClass.getName())).findAny();
    }

    public static Collection<String> getNames(Collection<? extends PsiMember> psiMembers) {
        return psiMembers.stream().map(NavigationItem::getName).collect(Collectors.toSet());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/util/PsiClassUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desiredClass";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/util/PsiClassUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassMethodsIntern";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassFieldsIntern";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInnerClassesIntern";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassMemberIntern";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassConstructorIntern";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassStaticMethodsIntern";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getWildcardClassType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeWithGenerics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectClassMethodsIntern";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectClassFieldsIntern";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectInnerClassesIntern";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectClassMemberIntern";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "filterPsiElements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectClassConstructorIntern";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectClassStaticMethodsIntern";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasSuperClass";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "superTypesIsEmptyOrObjectOnly";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getWildcardClassType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithGenerics";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getInnerClassInternByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

