/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationPanelModel;
import com.intellij.core.JavaPsiBundle;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.UI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AnnotationsPanel {
    private final Project myProject;
    private final Set<String> myDefaultAnnotations;
    private final JBTable myTable;
    private final JPanel myComponent;
    private final ComboBox<String> myCombo;
    protected final DefaultTableModel myTableModel;
    private final TableRowSorter<DefaultTableModel> mySorter;

    public AnnotationsPanel(Project project, @NonNls String name, String defaultAnnotation, List<String> annotations, List<String> defaultAnnotations, Set<String> checkedAnnotations, boolean showInstrumentationOptions, boolean showDefaultActions) {
        this(project, new SimpleAnnotationPanelModel(name, defaultAnnotation, annotations, defaultAnnotations, checkedAnnotations), showInstrumentationOptions, showDefaultActions);
    }

    public AnnotationsPanel(Project project, @NotNull AnnotationPanelModel model, boolean showInstrumentationOptions, boolean showDefaultActions) {
        if (model == null) {
            AnnotationsPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myDefaultAnnotations = new HashSet<String>(model.getDefaultAnnotations());
        List<String> annotations = model.getAnnotations();
        this.myCombo = new ComboBox((Object[])((String[])annotations.stream().sorted().toArray(String[]::new)));
        String defaultAnnotation = model.getDefaultAnnotation();
        if (!annotations.contains(defaultAnnotation)) {
            this.addAnnotationToCombo(defaultAnnotation);
        }
        if (model.hasAdvancedAnnotations()) {
            this.loadAdvancedAnnotations(model);
        }
        this.myCombo.setSelectedItem((Object)defaultAnnotation);
        this.myTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }
        };
        this.myTableModel.setColumnCount(showInstrumentationOptions ? 2 : 1);
        for (String annotation : annotations) {
            this.addRow(annotation, model.getCheckedAnnotations().contains(annotation));
        }
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        columnModel.addColumn(new TableColumn(0, 100, (TableCellRenderer)new ColoredTableCellRenderer(){

            public void acquireState(JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
                super.acquireState(table, isSelected, false, row, column);
            }

            protected void customizeCellRenderer(@NotNull JTable table, Object value2, boolean selected, boolean hasFocus, int row, int column) {
                if (table == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.append((String)value2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/codeInsight/AnnotationsPanel$2", "customizeCellRenderer"));
            }
        }, null));
        this.myTable = new JBTable((TableModel)this.myTableModel, (TableColumnModel)columnModel);
        this.mySorter = new TableRowSorter<DefaultTableModel>(this.myTableModel);
        this.mySorter.setSortKeys(List.of(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        this.myTable.setRowSorter(this.mySorter);
        if (!showInstrumentationOptions) {
            this.myTable.setTableHeader(null);
        }
        this.mySorter.sort();
        if (showInstrumentationOptions) {
            columnModel.getColumn(0).setHeaderValue(JavaPsiBundle.message("node.annotation.tooltip", new Object[0]));
            TableColumn checkColumn = new TableColumn(1, 100, (TableCellRenderer)new BooleanTableCellRenderer(), (TableCellEditor)new BooleanTableCellEditor());
            columnModel.addColumn(checkColumn);
            checkColumn.setHeaderValue(" Instrument ");
            final TableCellRenderer defaultRenderer = this.myTable.getTableHeader().getDefaultRenderer();
            TableCellRenderer headerRenderer = new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = defaultRenderer.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
                    if (component instanceof JComponent) {
                        ((JComponent)component).setToolTipText(column == 1 ? JavaBundle.message("nullable.notnull.annotations.runtime.instrumentation.tooltip", new Object[0]) : null);
                    }
                    return component;
                }
            };
            this.myTable.getTableHeader().setDefaultRenderer(headerRenderer);
            checkColumn.setHeaderRenderer(headerRenderer);
            checkColumn.sizeWidthToFit();
        }
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTable)this.myTable).disableUpDownActions().setAddAction(b -> this.chooseAnnotation(model.getName())).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                String selectedValue = AnnotationsPanel.this.getSelectedAnnotation();
                if (selectedValue == null) {
                    return;
                }
                AnnotationsPanel.this.myCombo.removeItem((Object)selectedValue);
                int rowIndex = -1;
                for (int i = 0; i < AnnotationsPanel.this.myTableModel.getDataVector().size(); ++i) {
                    if (!AnnotationsPanel.this.myTableModel.getDataVector().get(i).contains(selectedValue)) continue;
                    rowIndex = i;
                    break;
                }
                if (rowIndex != -1) {
                    AnnotationsPanel.this.myTableModel.removeRow(rowIndex);
                }
            }
        }).setRemoveActionUpdater(e -> !this.myDefaultAnnotations.contains(this.getSelectedAnnotation()));
        this.myTable.setSelectionMode(0);
        this.myTable.setRowSelectionAllowed(true);
        this.myTable.setShowGrid(false);
        JPanel tablePanel = UI.PanelFactory.panel((JComponent)toolbarDecorator.createPanel()).withLabel(JavaBundle.message("nullable.notnull.annotations.panel.title", model.getName())).moveLabelOnTop().resizeY(true).createPanel();
        tablePanel.setPreferredSize((Dimension)new JBDimension(tablePanel.getPreferredSize().width, 200));
        this.myComponent = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.weightx = 1.0;
        if (showDefaultActions) {
            this.myComponent.add((Component)new JLabel(JavaBundle.message("nullable.notnull.annotation.used.label", new Object[0])), constraints);
            constraints.fill = 2;
            constraints.insets.bottom = 3;
            constraints.gridy = 1;
            this.myComponent.add((Component)this.myCombo, constraints);
            constraints.insets.bottom = 0;
            constraints.gridy = 2;
        }
        constraints.fill = 1;
        constraints.weighty = 1.0;
        this.myComponent.add((Component)tablePanel, constraints);
    }

    private void loadAdvancedAnnotations(@NotNull AnnotationPanelModel model) {
        if (model == null) {
            AnnotationsPanel.$$$reportNull$$$0(1);
        }
        final String loading = JavaBundle.message("loading.additional.annotations", new Object[0]);
        this.myCombo.addItem((Object)loading);
        DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> ReadAction.nonBlocking(model::getAdvancedAnnotations).finishOnUiThread(ModalityState.any(), advancedAnnotations -> {
            this.myCombo.removeItem((Object)loading);
            int count = this.myCombo.getItemCount();
            Object selectedItem = this.myCombo.getSelectedItem();
            List<String> newItems = Stream.concat(IntStream.range(0, count).mapToObj(arg_0 -> this.myCombo.getItemAt(arg_0)), advancedAnnotations.stream()).sorted().distinct().collect(Collectors.toList());
            this.myCombo.removeAllItems();
            newItems.forEach(arg_0 -> this.myCombo.addItem(arg_0));
            this.myCombo.setSelectedItem(selectedItem);
        }).submit((Executor)AppExecutorUtil.getAppExecutorService()));
        this.myCombo.addActionListener(new ActionListener(){
            Object previous;
            {
                this.previous = AnnotationsPanel.this.myCombo.getSelectedItem();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = AnnotationsPanel.this.myCombo.getSelectedItem();
                if (item == loading) {
                    AnnotationsPanel.this.myCombo.setSelectedItem(this.previous);
                } else {
                    this.previous = item;
                }
            }
        });
    }

    private void addRow(String annotation, boolean checked) {
        this.myTableModel.addRow(new Object[]{annotation, checked});
    }

    private Integer selectAnnotation(String annotation) {
        for (int i = 0; i < this.myTable.getRowCount(); ++i) {
            if (!annotation.equals(this.myTable.getValueAt(i, 0))) continue;
            this.myTable.setRowSelectionInterval(i, i);
            return i;
        }
        return null;
    }

    @NlsSafe
    private String getSelectedAnnotation() {
        int selectedRow = this.myTable.getSelectedRow();
        return selectedRow < 0 ? null : (String)this.myTable.getValueAt(selectedRow, 0);
    }

    private void chooseAnnotation(@NlsSafe String title) {
        TreeClassChooser chooser = TreeClassChooserFactory.getInstance(this.myProject).createNoInnerClassesScopeChooser(JavaBundle.message("dialog.title.choose.annotation", title), GlobalSearchScope.allScope((Project)this.myProject), new ClassFilter(){

            @Override
            public boolean isAccepted(PsiClass aClass) {
                return aClass.isAnnotationType();
            }
        }, null);
        chooser.showDialog();
        PsiClass selected = chooser.getSelected();
        if (selected == null) {
            return;
        }
        String qualifiedName = selected.getQualifiedName();
        if (this.selectAnnotation(qualifiedName) == null) {
            this.addRow(qualifiedName, false);
            this.addAnnotationToCombo(qualifiedName);
            this.mySorter.sort();
            Integer added = this.selectAnnotation(qualifiedName);
            assert (added != null);
            this.myTable.scrollRectToVisible(this.myTable.getCellRect(added.intValue(), 0, true));
        }
    }

    private void addAnnotationToCombo(@NlsSafe String annotation) {
        int insertAt;
        for (insertAt = 0; insertAt < this.myCombo.getItemCount() && ((String)this.myCombo.getItemAt(insertAt)).compareTo(annotation) < 0; ++insertAt) {
        }
        this.myCombo.insertItemAt((Object)annotation, insertAt);
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    String getDefaultAnnotation() {
        return (String)this.myCombo.getItem();
    }

    public String[] getAnnotations() {
        int size = this.myTable.getRowCount();
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (String)this.myTable.getValueAt(i, 0);
        }
        return result;
    }

    List<String> getCheckedAnnotations() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.myTable.getRowCount(); ++i) {
            if (!Boolean.TRUE.equals(this.myTable.getValueAt(i, 1))) continue;
            result.add((String)this.myTable.getValueAt(i, 0));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "model";
        objectArray2[1] = "com/intellij/codeInsight/AnnotationsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadAdvancedAnnotations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SimpleAnnotationPanelModel
    implements AnnotationPanelModel {
        @NonNls
        private final String myName;
        private final String myDefaultAnnotation;
        private final List<String> myAnnotations;
        private final List<String> myDefaultAnnotations;
        private final Set<String> myCheckedAnnotations;

        private SimpleAnnotationPanelModel(@NonNls String name, String defaultAnnotation, List<String> annotations, List<String> defaultAnnotations, Set<String> checkedAnnotations) {
            this.myName = name;
            this.myDefaultAnnotation = defaultAnnotation;
            this.myAnnotations = annotations;
            this.myDefaultAnnotations = defaultAnnotations;
            this.myCheckedAnnotations = checkedAnnotations;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                SimpleAnnotationPanelModel.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDefaultAnnotation() {
            String string = this.myDefaultAnnotation;
            if (string == null) {
                SimpleAnnotationPanelModel.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public List<String> getAnnotations() {
            List<String> list = this.myAnnotations;
            if (list == null) {
                SimpleAnnotationPanelModel.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        @NotNull
        public List<String> getAdvancedAnnotations() {
            List<String> list = this.myAnnotations;
            if (list == null) {
                SimpleAnnotationPanelModel.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        @NotNull
        public List<String> getDefaultAnnotations() {
            List<String> list = this.myDefaultAnnotations;
            if (list == null) {
                SimpleAnnotationPanelModel.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Override
        @NotNull
        public Set<String> getCheckedAnnotations() {
            Set<String> set = this.myCheckedAnnotations;
            if (set == null) {
                SimpleAnnotationPanelModel.$$$reportNull$$$0(5);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/AnnotationsPanel$SimpleAnnotationPanelModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultAnnotation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotations";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdvancedAnnotations";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultAnnotations";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCheckedAnnotations";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

