/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.util;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MethodParenthesesHandler
extends ParenthesesInsertHandler<LookupElement> {
    private final PsiMethod myMethod;
    private final boolean myOverloadsMatter;

    public MethodParenthesesHandler(PsiMethod method, boolean overloadsMatter) {
        this.myMethod = method;
        this.myOverloadsMatter = overloadsMatter;
    }

    protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement item) {
        return this.myOverloadsMatter ? MethodParenthesesHandler.overloadsHaveParameters(context.getElements(), this.myMethod) != ThreeState.NO : !this.myMethod.getParameterList().isEmpty();
    }

    public static ThreeState overloadsHaveParameters(LookupElement[] allItems, PsiMethod method) {
        List overloads = JBIterable.of((Object[])allItems).map(LookupElement::getPsiElement).filter(PsiMethod.class).filter(element -> element.getName().equals(method.getName())).toList();
        return overloads.isEmpty() ? ThreeState.fromBoolean((!method.getParameterList().isEmpty() ? 1 : 0) != 0) : MethodParenthesesHandler.hasParameters(overloads);
    }

    @NotNull
    public static ThreeState hasParameters(List<PsiMethod> methods) {
        boolean hasEmpty = methods.isEmpty();
        boolean hasNonEmpty = false;
        for (PsiMethod method : methods) {
            if (!method.getParameterList().isEmpty()) {
                hasNonEmpty = true;
                continue;
            }
            hasEmpty = true;
        }
        ThreeState threeState = hasNonEmpty && hasEmpty ? ThreeState.UNSURE : (hasNonEmpty ? ThreeState.YES : ThreeState.NO);
        if (threeState == null) {
            MethodParenthesesHandler.$$$reportNull$$$0(0);
        }
        return threeState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/util/MethodParenthesesHandler", "hasParameters"));
    }
}

