/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm.actions;

import com.intellij.lang.jvm.JvmAnnotation;
import com.intellij.lang.jvm.JvmEnumField;
import com.intellij.lang.jvm.JvmField;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationAttributeValueRequest;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.annotation.JvmAnnotationArrayValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttribute;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttributeValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationClassValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationConstantValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationEnumFieldValue;
import com.intellij.lang.jvm.annotation.JvmNestedAnnotationValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameValuePair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f\u001a\u001c\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u001a\u0016\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003\u001a\u0016\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0016\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003\u001a\u0016\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0016\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u001a\u001a\u0016\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003\u00a8\u0006\u001c"}, d2={"arrayAttribute", "Lcom/intellij/lang/jvm/actions/AnnotationAttributeRequest;", "name", "", "members", "", "Lcom/intellij/lang/jvm/actions/AnnotationAttributeValueRequest;", "attributeRequest", "attribute", "Lcom/intellij/lang/jvm/annotation/JvmAnnotationAttribute;", "attributeRequests", "annotation", "Lcom/intellij/lang/jvm/JvmAnnotation;", "attributeValueRequest", "attribValue", "Lcom/intellij/lang/jvm/annotation/JvmAnnotationAttributeValue;", "classAttribute", "classFqn", "constantAttribute", "reference", "Lcom/intellij/lang/jvm/JvmField;", "refText", "intAttribute", "value", "", "nestedAttribute", "Lcom/intellij/lang/jvm/actions/AnnotationRequest;", "stringAttribute", "intellij.java.analysis"})
public final class AnnotationAttributeValueRequestKt {
    @NotNull
    public static final AnnotationAttributeRequest stringAttribute(@NotNull String name, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return new AnnotationAttributeRequest(name, new AnnotationAttributeValueRequest.StringValue(value2));
    }

    @NotNull
    public static final AnnotationAttributeRequest intAttribute(@NotNull String name, int value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new AnnotationAttributeRequest(name, new AnnotationAttributeValueRequest.PrimitiveValue(value2));
    }

    @NotNull
    public static final AnnotationAttributeRequest classAttribute(@NotNull String name, @NotNull String classFqn) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)classFqn, (String)"classFqn");
        return new AnnotationAttributeRequest(name, new AnnotationAttributeValueRequest.ClassValue(classFqn));
    }

    @NotNull
    public static final AnnotationAttributeRequest constantAttribute(@NotNull String name, @NotNull JvmField reference) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        String string = ((PsiElement)reference).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(reference as PsiElement).text");
        return new AnnotationAttributeRequest(name, new AnnotationAttributeValueRequest.ConstantValue(reference, string));
    }

    @NotNull
    public static final AnnotationAttributeRequest constantAttribute(@NotNull String name, @NotNull String refText) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)refText, (String)"refText");
        return new AnnotationAttributeRequest(name, new AnnotationAttributeValueRequest.ConstantValue(null, refText));
    }

    @NotNull
    public static final AnnotationAttributeRequest nestedAttribute(@NotNull String name, @NotNull AnnotationRequest annotation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        return new AnnotationAttributeRequest(name, new AnnotationAttributeValueRequest.NestedAnnotation(annotation));
    }

    @NotNull
    public static final AnnotationAttributeRequest arrayAttribute(@NotNull String name, @NotNull List<? extends AnnotationAttributeValueRequest> members) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        return new AnnotationAttributeRequest(name, new AnnotationAttributeValueRequest.ArrayValue(members));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final AnnotationAttributeValueRequest attributeValueRequest(@NotNull JvmAnnotationAttributeValue attribValue, @Nullable JvmAnnotationAttribute attribute) {
        AnnotationAttributeValueRequest annotationAttributeValueRequest;
        Intrinsics.checkNotNullParameter((Object)attribValue, (String)"attribValue");
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue = attribValue;
        if (jvmAnnotationAttributeValue instanceof JvmAnnotationArrayValue) {
            List list;
            void $this$mapNotNullTo$iv$iv;
            List<JvmAnnotationAttributeValue> list2 = ((JvmAnnotationArrayValue)attribValue).getValues();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"attribValue.values");
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                AnnotationAttributeValueRequest annotationAttributeValueRequest2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                JvmAnnotationAttributeValue it = (JvmAnnotationAttributeValue)element$iv$iv;
                boolean bl2 = false;
                JvmAnnotationAttributeValue jvmAnnotationAttributeValue2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)jvmAnnotationAttributeValue2, (String)"it");
                if (AnnotationAttributeValueRequestKt.attributeValueRequest(jvmAnnotationAttributeValue2, attribute) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                AnnotationAttributeValueRequest it$iv$iv = annotationAttributeValueRequest2;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list3 = list = (List)destination$iv$iv;
            annotationAttributeValueRequest = new AnnotationAttributeValueRequest.ArrayValue(list3);
        } else if (jvmAnnotationAttributeValue instanceof JvmAnnotationClassValue) {
            AnnotationAttributeValueRequest.ClassValue classValue;
            Object object = ((JvmAnnotationClassValue)attribValue).getClazz();
            if (object != null && (object = object.getQualifiedName()) != null) {
                Object $this$mapNotNull$iv = object;
                boolean bl = false;
                boolean bl6 = false;
                Object p1 = $this$mapNotNull$iv;
                boolean bl7 = false;
                classValue = new AnnotationAttributeValueRequest.ClassValue((String)p1);
            } else {
                classValue = null;
            }
            annotationAttributeValueRequest = classValue;
        } else if (jvmAnnotationAttributeValue instanceof JvmAnnotationConstantValue) {
            Object constantVal = ((JvmAnnotationConstantValue)attribValue).getConstantValue();
            annotationAttributeValueRequest = constantVal instanceof String ? (AnnotationAttributeValueRequest)new AnnotationAttributeValueRequest.StringValue((String)constantVal) : (constantVal instanceof Object ? (AnnotationAttributeValueRequest)new AnnotationAttributeValueRequest.PrimitiveValue(constantVal) : null);
        } else if (jvmAnnotationAttributeValue instanceof JvmAnnotationEnumFieldValue) {
            AnnotationAttributeValueRequest.ConstantValue constantValue;
            Object referenceText;
            Object object;
            JvmAnnotationAttribute jvmAnnotationAttribute = attribute;
            if (!(jvmAnnotationAttribute instanceof PsiNameValuePair)) {
                jvmAnnotationAttribute = null;
            }
            if ((object = (PsiNameValuePair)jvmAnnotationAttribute) == null || (object = object.getValue()) == null || (object = object.getText()) == null) {
                JvmEnumField jvmEnumField = ((JvmAnnotationEnumFieldValue)attribValue).getField();
                if (!(jvmEnumField instanceof PsiElement)) {
                    jvmEnumField = null;
                }
                PsiElement psiElement = (PsiElement)jvmEnumField;
                object = psiElement != null ? psiElement.getText() : null;
            }
            Object object2 = referenceText = object;
            if (object2 != null) {
                Object object3 = object2;
                boolean bl = false;
                boolean p1 = false;
                Object it = object3;
                boolean bl8 = false;
                constantValue = new AnnotationAttributeValueRequest.ConstantValue(((JvmAnnotationEnumFieldValue)attribValue).getField(), (String)it);
            } else {
                constantValue = null;
            }
            annotationAttributeValueRequest = constantValue;
        } else if (jvmAnnotationAttributeValue instanceof JvmNestedAnnotationValue) {
            AnnotationAttributeValueRequest.NestedAnnotation nestedAnnotation;
            JvmAnnotation jvmAnnotation = ((JvmNestedAnnotationValue)attribValue).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)jvmAnnotation, (String)"attribValue.value");
            AnnotationRequest annotationRequest = AnnotationRequestsKt.annotationRequest(jvmAnnotation);
            if (annotationRequest != null) {
                AnnotationRequest annotationRequest2 = annotationRequest;
                boolean bl = false;
                boolean bl9 = false;
                AnnotationRequest p1 = annotationRequest2;
                boolean bl10 = false;
                nestedAnnotation = new AnnotationAttributeValueRequest.NestedAnnotation(p1);
            } else {
                nestedAnnotation = null;
            }
            annotationAttributeValueRequest = nestedAnnotation;
        } else {
            annotationAttributeValueRequest = null;
        }
        return annotationAttributeValueRequest;
    }

    public static /* synthetic */ AnnotationAttributeValueRequest attributeValueRequest$default(JvmAnnotationAttributeValue jvmAnnotationAttributeValue, JvmAnnotationAttribute jvmAnnotationAttribute, int n, Object object) {
        if ((n & 2) != 0) {
            jvmAnnotationAttribute = null;
        }
        return AnnotationAttributeValueRequestKt.attributeValueRequest(jvmAnnotationAttributeValue, jvmAnnotationAttribute);
    }

    @Nullable
    public static final AnnotationAttributeRequest attributeRequest(@NotNull JvmAnnotationAttribute attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue = attribute.getAttributeValue();
        if (jvmAnnotationAttributeValue == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)jvmAnnotationAttributeValue, (String)"attribute.attributeValue ?: return null");
        JvmAnnotationAttributeValue attribValue = jvmAnnotationAttributeValue;
        AnnotationAttributeValueRequest annotationAttributeValueRequest = AnnotationAttributeValueRequestKt.attributeValueRequest(attribValue, attribute);
        if (annotationAttributeValueRequest == null) {
            return null;
        }
        AnnotationAttributeValueRequest valueRequest = annotationAttributeValueRequest;
        String string = attribute.getAttributeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attribute.attributeName");
        return new AnnotationAttributeRequest(string, valueRequest);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<AnnotationAttributeRequest> attributeRequests(@NotNull JvmAnnotation annotation) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        List<JvmAnnotationAttribute> list = annotation.getAttributes();
        Intrinsics.checkNotNullExpressionValue(list, (String)"annotation.attributes");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AnnotationAttributeRequest annotationAttributeRequest;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JvmAnnotationAttribute p1 = (JvmAnnotationAttribute)element$iv$iv;
            boolean bl2 = false;
            if (AnnotationAttributeValueRequestKt.attributeRequest(p1) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            AnnotationAttributeRequest it$iv$iv = annotationAttributeRequest;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

