/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.LabelNormalizationMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.utils.SmartIdentityTable;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FrameNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/LabelNormalizationMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "TransformerForMethod", "backend"})
public final class LabelNormalizationMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        new TransformerForMethod(methodNode).transform();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020!H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00152\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020!H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u00152\u0006\u0010#\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020!H\u0002J\u0006\u0010)\u001a\u00020!J\f\u0010*\u001a\u00020\u0015*\u00020\u0017H\u0002J\f\u0010*\u001a\u00020\u0015*\u00020\u001aH\u0002J\f\u0010*\u001a\u00020\u0015*\u00020\u001fH\u0002J\f\u0010*\u001a\u00020\u0015*\u00020$H\u0002J\f\u0010*\u001a\u00020\u0015*\u00020'H\u0002R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/LabelNormalizationMethodTransformer$TransformerForMethod;", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "instructions", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "kotlin.jvm.PlatformType", "getInstructions", "()Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "newLabelNodes", "Lorg/jetbrains/kotlin/utils/SmartIdentityTable;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "getNewLabelNodes", "()Lorg/jetbrains/kotlin/utils/SmartIdentityTable;", "getNew", "oldLabelNode", "getNewOrOld", "rewriteFrameNode", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "oldFrameNode", "Lorg/jetbrains/org/objectweb/asm/tree/FrameNode;", "rewriteJumpInsn", "oldJumpNode", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "rewriteLabelInstructions", "", "rewriteLineNumberNode", "oldLineNode", "Lorg/jetbrains/org/objectweb/asm/tree/LineNumberNode;", "rewriteLocalVars", "", "rewriteLookupSwitchInsn", "oldSwitchNode", "Lorg/jetbrains/org/objectweb/asm/tree/LookupSwitchInsnNode;", "rewriteNonLabelInstructions", "rewriteTableSwitchInsn", "Lorg/jetbrains/org/objectweb/asm/tree/TableSwitchInsnNode;", "rewriteTryCatchBlocks", "transform", "rewriteLabels", "backend"})
    private static final class TransformerForMethod {
        @NotNull
        private final MethodNode methodNode;
        private final InsnList instructions;
        @NotNull
        private final SmartIdentityTable<LabelNode, LabelNode> newLabelNodes;

        public TransformerForMethod(@NotNull MethodNode methodNode) {
            Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
            this.methodNode = methodNode;
            this.instructions = this.methodNode.instructions;
            this.newLabelNodes = new SmartIdentityTable();
        }

        @NotNull
        public final MethodNode getMethodNode() {
            return this.methodNode;
        }

        public final InsnList getInstructions() {
            return this.instructions;
        }

        @NotNull
        public final SmartIdentityTable<LabelNode, LabelNode> getNewLabelNodes() {
            return this.newLabelNodes;
        }

        public final void transform() {
            if (this.rewriteLabelInstructions()) {
                this.rewriteNonLabelInstructions();
                this.rewriteTryCatchBlocks();
                this.rewriteLocalVars();
                UtilKt.removeEmptyCatchBlocks(this.methodNode);
            }
        }

        private final boolean rewriteLabelInstructions() {
            boolean removedAnyLabels = false;
            AbstractInsnNode thisNode = this.instructions.getFirst();
            while (thisNode != null) {
                if (thisNode instanceof LabelNode) {
                    AbstractInsnNode abstractInsnNode;
                    AbstractInsnNode prevNode = ((LabelNode)thisNode).getPrevious();
                    if (prevNode instanceof LabelNode) {
                        abstractInsnNode = thisNode;
                        this.newLabelNodes.set((LabelNode)abstractInsnNode, (LabelNode)prevNode);
                        removedAnyLabels = true;
                        abstractInsnNode = this.instructions;
                        Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"instructions");
                        AbstractInsnNode abstractInsnNode2 = abstractInsnNode;
                        abstractInsnNode = thisNode;
                        thisNode = LabelNormalizationMethodTransformerKt.removeNodeGetNext((InsnList)abstractInsnNode2, abstractInsnNode);
                        continue;
                    }
                    AbstractInsnNode abstractInsnNode3 = abstractInsnNode = thisNode;
                    abstractInsnNode = thisNode;
                    this.newLabelNodes.set((LabelNode)abstractInsnNode3, (LabelNode)abstractInsnNode);
                    thisNode = ((LabelNode)thisNode).getNext();
                    continue;
                }
                thisNode = thisNode.getNext();
            }
            return removedAnyLabels;
        }

        private final void rewriteNonLabelInstructions() {
            AbstractInsnNode thisNode = this.instructions.getFirst();
            while (thisNode != null) {
                AbstractInsnNode abstractInsnNode;
                AbstractInsnNode abstractInsnNode2 = thisNode;
                AbstractInsnNode abstractInsnNode3 = abstractInsnNode2;
                if (abstractInsnNode3 instanceof JumpInsnNode) {
                    abstractInsnNode2 = thisNode;
                    abstractInsnNode = this.rewriteJumpInsn((JumpInsnNode)abstractInsnNode2);
                } else if (abstractInsnNode3 instanceof LineNumberNode) {
                    abstractInsnNode2 = thisNode;
                    abstractInsnNode = this.rewriteLineNumberNode((LineNumberNode)abstractInsnNode2);
                } else if (abstractInsnNode3 instanceof LookupSwitchInsnNode) {
                    abstractInsnNode2 = thisNode;
                    abstractInsnNode = this.rewriteLookupSwitchInsn((LookupSwitchInsnNode)abstractInsnNode2);
                } else if (abstractInsnNode3 instanceof TableSwitchInsnNode) {
                    abstractInsnNode2 = thisNode;
                    abstractInsnNode = this.rewriteTableSwitchInsn((TableSwitchInsnNode)abstractInsnNode2);
                } else if (abstractInsnNode3 instanceof FrameNode) {
                    abstractInsnNode2 = thisNode;
                    abstractInsnNode = this.rewriteFrameNode((FrameNode)abstractInsnNode2);
                } else {
                    abstractInsnNode = thisNode.getNext();
                }
                thisNode = abstractInsnNode;
            }
        }

        private final AbstractInsnNode rewriteLineNumberNode(LineNumberNode oldLineNode) {
            InsnList insnList = this.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(insnList, (AbstractInsnNode)oldLineNode, this.rewriteLabels(oldLineNode));
        }

        private final AbstractInsnNode rewriteJumpInsn(JumpInsnNode oldJumpNode) {
            InsnList insnList = this.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(insnList, (AbstractInsnNode)oldJumpNode, this.rewriteLabels(oldJumpNode));
        }

        private final AbstractInsnNode rewriteLookupSwitchInsn(LookupSwitchInsnNode oldSwitchNode) {
            InsnList insnList = this.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(insnList, (AbstractInsnNode)oldSwitchNode, this.rewriteLabels(oldSwitchNode));
        }

        private final AbstractInsnNode rewriteTableSwitchInsn(TableSwitchInsnNode oldSwitchNode) {
            InsnList insnList = this.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(insnList, (AbstractInsnNode)oldSwitchNode, this.rewriteLabels(oldSwitchNode));
        }

        private final AbstractInsnNode rewriteFrameNode(FrameNode oldFrameNode) {
            InsnList insnList = this.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
            return LabelNormalizationMethodTransformerKt.replaceNodeGetNext(insnList, (AbstractInsnNode)oldFrameNode, this.rewriteLabels(oldFrameNode));
        }

        /*
         * WARNING - void declaration
         */
        private final void rewriteTryCatchBlocks() {
            Collection<TryCatchBlockNode> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.methodNode.tryCatchBlocks;
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"methodNode.tryCatchBlocks");
            iterable = iterable;
            MethodNode methodNode = this.methodNode;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void oldTcb;
                TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                LabelNode labelNode = oldTcb.start;
                Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"oldTcb.start");
                LabelNode labelNode2 = this.getNew(labelNode);
                labelNode = oldTcb.end;
                Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"oldTcb.end");
                LabelNode labelNode3 = this.getNew(labelNode);
                labelNode = oldTcb.handler;
                Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"oldTcb.handler");
                TryCatchBlockNode newTcb = new TryCatchBlockNode(labelNode2, labelNode3, this.getNew(labelNode), oldTcb.type);
                newTcb.visibleTypeAnnotations = oldTcb.visibleTypeAnnotations;
                newTcb.invisibleTypeAnnotations = oldTcb.invisibleTypeAnnotations;
                TryCatchBlockNode tryCatchBlockNode2 = newTcb;
                collection.add(tryCatchBlockNode2);
            }
            collection = (List)destination$iv$iv;
            methodNode.tryCatchBlocks = collection;
        }

        /*
         * WARNING - void declaration
         */
        private final void rewriteLocalVars() {
            Collection<LocalVariableNode> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.methodNode.localVariables;
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"methodNode.localVariables");
            iterable = iterable;
            MethodNode methodNode = this.methodNode;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void oldVar;
                LocalVariableNode localVariableNode = (LocalVariableNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string2 = oldVar.name;
                String string3 = oldVar.desc;
                String string4 = oldVar.signature;
                LabelNode labelNode = oldVar.start;
                Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"oldVar.start");
                LabelNode labelNode2 = this.getNew(labelNode);
                labelNode = oldVar.end;
                Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"oldVar.end");
                LocalVariableNode localVariableNode2 = new LocalVariableNode(string2, string3, string4, labelNode2, this.getNew(labelNode), oldVar.index);
                collection.add(localVariableNode2);
            }
            collection = (List)destination$iv$iv;
            methodNode.localVariables = collection;
        }

        private final AbstractInsnNode rewriteLabels(LineNumberNode $this$rewriteLabels) {
            int n = $this$rewriteLabels.line;
            LabelNode labelNode = $this$rewriteLabels.start;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"start");
            return (AbstractInsnNode)new LineNumberNode(n, this.getNewOrOld(labelNode));
        }

        private final AbstractInsnNode rewriteLabels(JumpInsnNode $this$rewriteLabels) {
            int n = $this$rewriteLabels.getOpcode();
            LabelNode labelNode = $this$rewriteLabels.label;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"label");
            return (AbstractInsnNode)new JumpInsnNode(n, this.getNew(labelNode));
        }

        /*
         * WARNING - void declaration
         */
        private final AbstractInsnNode rewriteLabels(LookupSwitchInsnNode $this$rewriteLabels) {
            Collection<LabelNode> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object = $this$rewriteLabels.dflt;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dflt");
            LabelNode labelNode = this.getNew((LabelNode)object);
            object = $this$rewriteLabels.keys;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"keys");
            LookupSwitchInsnNode switchNode = new LookupSwitchInsnNode(labelNode, CollectionsKt.toIntArray((Collection)((Collection)object)), new LabelNode[0]);
            object = $this$rewriteLabels.labels;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"labels");
            object = (Iterable)object;
            LookupSwitchInsnNode lookupSwitchInsnNode = switchNode;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LabelNode labelNode2 = (LabelNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                LabelNode labelNode3 = this.getNew((LabelNode)it);
                collection.add(labelNode3);
            }
            collection = (List)destination$iv$iv;
            lookupSwitchInsnNode.labels = collection;
            return (AbstractInsnNode)switchNode;
        }

        /*
         * WARNING - void declaration
         */
        private final AbstractInsnNode rewriteLabels(TableSwitchInsnNode $this$rewriteLabels) {
            Collection<LabelNode> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int n = $this$rewriteLabels.min;
            int n2 = $this$rewriteLabels.max;
            Object object = $this$rewriteLabels.dflt;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dflt");
            TableSwitchInsnNode switchNode = new TableSwitchInsnNode(n, n2, this.getNew((LabelNode)object), new LabelNode[0]);
            object = $this$rewriteLabels.labels;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"labels");
            object = (Iterable)object;
            TableSwitchInsnNode tableSwitchInsnNode = switchNode;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LabelNode labelNode = (LabelNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                LabelNode labelNode2 = this.getNew((LabelNode)it);
                collection.add(labelNode2);
            }
            collection = (List)destination$iv$iv;
            tableSwitchInsnNode.labels = collection;
            return (AbstractInsnNode)switchNode;
        }

        private final AbstractInsnNode rewriteLabels(FrameNode $this$rewriteLabels) {
            Object object;
            Object it;
            Collection collection;
            Object item$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            FrameNode frameNode = new FrameNode($this$rewriteLabels.type, 0, new Object[0], 0, new Object[0]);
            Iterable iterable = $this$rewriteLabels.local;
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"local");
            iterable = iterable;
            FrameNode frameNode2 = frameNode;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator<Object> iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object t = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl = false;
                object = it instanceof LabelNode ? this.getNewOrOld((LabelNode)it) : it;
                collection.add(object);
            }
            collection = (List)destination$iv$iv;
            frameNode2.local = collection;
            $this$map$iv = $this$rewriteLabels.stack;
            Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"stack");
            $this$map$iv = $this$map$iv;
            frameNode2 = frameNode;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                it = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl = false;
                object = it instanceof LabelNode ? this.getNewOrOld((LabelNode)it) : it;
                collection.add(object);
            }
            collection = (List)destination$iv$iv;
            frameNode2.stack = collection;
            return (AbstractInsnNode)frameNode;
        }

        private final LabelNode getNew(LabelNode oldLabelNode) {
            LabelNode labelNode = this.newLabelNodes.get(oldLabelNode);
            if (labelNode == null) {
                throw new IllegalStateException("Label wasn't found during iterating through instructions");
            }
            return labelNode;
        }

        private final LabelNode getNewOrOld(LabelNode oldLabelNode) {
            LabelNode labelNode = this.newLabelNodes.get(oldLabelNode);
            return labelNode == null ? oldLabelNode : labelNode;
        }
    }
}

