/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.IntCollectionExternalizer;
import org.jetbrains.kotlin.incremental.storage.LookupSymbolKey;
import org.jetbrains.kotlin.incremental.storage.LookupSymbolKeyDescriptor;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\"\n\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0004J\u001c\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0002H\u0014J\u0016\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0019\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u0002H\u0086\u0002J\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0002J\u001f\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u001bH\u0086\u0002R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/LookupMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMap;", "Lorg/jetbrains/kotlin/incremental/storage/LookupSymbolKey;", "", "", "storage", "Ljava/io/File;", "(Ljava/io/File;)V", "keys", "getKeys", "()Ljava/util/Collection;", "add", "", "name", "", "scope", "fileId", "append", "lookup", "fileIds", "dumpKey", "key", "dumpValue", "value", "get", "remove", "set", "", "kotlin-build-common"})
public final class LookupMap
extends BasicMap<LookupSymbolKey, Collection<? extends Integer>> {
    public LookupMap(@NotNull File storage2) {
        Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
        super(storage2, LookupSymbolKeyDescriptor.INSTANCE, IntCollectionExternalizer.INSTANCE);
    }

    @Override
    @NotNull
    protected String dumpKey(@NotNull LookupSymbolKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return key.toString();
    }

    @Override
    @NotNull
    protected String dumpValue(@NotNull Collection<Integer> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return value2.toString();
    }

    public final void add(@NotNull String name, @NotNull String scope2, int fileId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.getStorage().append(new LookupSymbolKey(name, scope2), CollectionsKt.listOf((Object)fileId));
    }

    public final void append(@NotNull LookupSymbolKey lookup, @NotNull Collection<Integer> fileIds) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter(fileIds, (String)"fileIds");
        this.getStorage().append(lookup, fileIds);
    }

    @Nullable
    public final Collection<Integer> get(@NotNull LookupSymbolKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (Collection)this.getStorage().get(key);
    }

    public final void set(@NotNull LookupSymbolKey key, @NotNull Set<Integer> fileIds) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(fileIds, (String)"fileIds");
        this.getStorage().set(key, fileIds);
    }

    public final void remove(@NotNull LookupSymbolKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.getStorage().remove(key);
    }

    @NotNull
    public final Collection<LookupSymbolKey> getKeys() {
        return this.getStorage().getKeys();
    }
}

