/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentPassedTwice;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCall;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.MixingNamedAndPositionArguments;
import org.jetbrains.kotlin.resolve.calls.model.NameForAmbiguousParameter;
import org.jetbrains.kotlin.resolve.calls.model.NameNotFound;
import org.jetbrains.kotlin.resolve.calls.model.NamedArgumentNotAllowed;
import org.jetbrains.kotlin.resolve.calls.model.NamedArgumentReference;
import org.jetbrains.kotlin.resolve.calls.model.NoValueForParameter;
import org.jetbrains.kotlin.resolve.calls.model.NonVarargSpread;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.TooManyArguments;
import org.jetbrains.kotlin.resolve.calls.model.VarargArgumentOutsideParentheses;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u000b\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper;", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "EmptyArgumentMapping", "Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$ArgumentMapping;", "getEmptyArgumentMapping", "()Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$ArgumentMapping;", "allowMixedNamedAndPositionArguments", "", "mapArguments", "argumentsInParenthesis", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "externalArgument", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "call", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCall;", "ArgumentMapping", "CallArgumentProcessor", "resolution"})
public final class ArgumentsToParametersMapper {
    private final boolean allowMixedNamedAndPositionArguments;
    @NotNull
    private final ArgumentMapping EmptyArgumentMapping;

    public ArgumentsToParametersMapper(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.allowMixedNamedAndPositionArguments = languageVersionSettings.supportsFeature(LanguageFeature.MixedNamedArgumentsInTheirOwnPosition);
        this.EmptyArgumentMapping = new ArgumentMapping(MapsKt.emptyMap(), CollectionsKt.emptyList());
    }

    @NotNull
    public final ArgumentMapping getEmptyArgumentMapping() {
        return this.EmptyArgumentMapping;
    }

    @NotNull
    public final ArgumentMapping mapArguments(@NotNull KotlinCall call2, @NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return this.mapArguments(call2.getArgumentsInParenthesis(), call2.getExternalArgument(), descriptor2);
    }

    @NotNull
    public final ArgumentMapping mapArguments(@NotNull List<? extends KotlinCallArgument> argumentsInParenthesis, @Nullable KotlinCallArgument externalArgument, @NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(argumentsInParenthesis, (String)"argumentsInParenthesis");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (argumentsInParenthesis.isEmpty() && externalArgument == null && descriptor2.getValueParameters().isEmpty()) {
            return this.EmptyArgumentMapping;
        }
        CallArgumentProcessor processor2 = new CallArgumentProcessor(descriptor2, this.allowMixedNamedAndPositionArguments);
        processor2.processArgumentsInParenthesis(argumentsInParenthesis);
        if (externalArgument != null) {
            processor2.processExternalArgument(externalArgument);
        }
        processor2.processDefaultsAndRunChecks();
        return new ArgumentMapping(processor2.getResult(), processor2.getDiagnostics());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J/\u0010\u0010\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$ArgumentMapping;", "", "parameterToCallArgumentMap", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallArgument;", "diagnostics", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "(Ljava/util/Map;Ljava/util/List;)V", "getDiagnostics", "()Ljava/util/List;", "getParameterToCallArgumentMap", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "resolution"})
    public static final class ArgumentMapping {
        @NotNull
        private final Map<ValueParameterDescriptor, ResolvedCallArgument> parameterToCallArgumentMap;
        @NotNull
        private final List<KotlinCallDiagnostic> diagnostics;

        public ArgumentMapping(@NotNull Map<ValueParameterDescriptor, ? extends ResolvedCallArgument> parameterToCallArgumentMap, @NotNull List<? extends KotlinCallDiagnostic> diagnostics2) {
            Intrinsics.checkNotNullParameter(parameterToCallArgumentMap, (String)"parameterToCallArgumentMap");
            Intrinsics.checkNotNullParameter(diagnostics2, (String)"diagnostics");
            this.parameterToCallArgumentMap = parameterToCallArgumentMap;
            this.diagnostics = diagnostics2;
        }

        @NotNull
        public final Map<ValueParameterDescriptor, ResolvedCallArgument> getParameterToCallArgumentMap() {
            return this.parameterToCallArgumentMap;
        }

        @NotNull
        public final List<KotlinCallDiagnostic> getDiagnostics() {
            return this.diagnostics;
        }

        @NotNull
        public final Map<ValueParameterDescriptor, ResolvedCallArgument> component1() {
            return this.parameterToCallArgumentMap;
        }

        @NotNull
        public final List<KotlinCallDiagnostic> component2() {
            return this.diagnostics;
        }

        @NotNull
        public final ArgumentMapping copy(@NotNull Map<ValueParameterDescriptor, ? extends ResolvedCallArgument> parameterToCallArgumentMap, @NotNull List<? extends KotlinCallDiagnostic> diagnostics2) {
            Intrinsics.checkNotNullParameter(parameterToCallArgumentMap, (String)"parameterToCallArgumentMap");
            Intrinsics.checkNotNullParameter(diagnostics2, (String)"diagnostics");
            return new ArgumentMapping(parameterToCallArgumentMap, diagnostics2);
        }

        public static /* synthetic */ ArgumentMapping copy$default(ArgumentMapping argumentMapping, Map map, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                map = argumentMapping.parameterToCallArgumentMap;
            }
            if ((n & 2) != 0) {
                list2 = argumentMapping.diagnostics;
            }
            return argumentMapping.copy(map, list2);
        }

        @NotNull
        public String toString() {
            return "ArgumentMapping(parameterToCallArgumentMap=" + this.parameterToCallArgumentMap + ", diagnostics=" + this.diagnostics + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.parameterToCallArgumentMap).hashCode();
            result2 = result2 * 31 + ((Object)this.diagnostics).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArgumentMapping)) {
                return false;
            }
            ArgumentMapping argumentMapping = (ArgumentMapping)other;
            if (!Intrinsics.areEqual(this.parameterToCallArgumentMap, argumentMapping.parameterToCallArgumentMap)) {
                return false;
            }
            return Intrinsics.areEqual(this.diagnostics, argumentMapping.diagnostics);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0012\b\u0002\u0018\u00002\u00020\u0001:\u00013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\rH\u0002J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020 H\u0002J\b\u0010&\u001a\u00020\"H\u0002J\u001a\u0010'\u001a\u0004\u0018\u00010\u00132\u0006\u0010%\u001a\u00020 2\u0006\u0010(\u001a\u00020\u0012H\u0002J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0\u0015J\u0012\u0010*\u001a\u0004\u0018\u00010\u00132\u0006\u0010(\u001a\u00020\u0012H\u0002J\u0014\u0010+\u001a\u00020\"2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020 0\u0015J\u0006\u0010-\u001a\u00020\"J\u000e\u0010.\u001a\u00020\"2\u0006\u0010/\u001a\u00020 J\u0018\u00100\u001a\u00020\"2\u0006\u0010%\u001a\u00020 2\u0006\u0010(\u001a\u00020\u0012H\u0002J\u0010\u00101\u001a\u00020\u00052\u0006\u0010%\u001a\u00020 H\u0002J\u000e\u00102\u001a\u0004\u0018\u00010\u0013*\u00020\u0013H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$CallArgumentProcessor;", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "languageSettingsAllowMixedNamedAndPositionArguments", "", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Z)V", "currentPositionedParameterIndex", "", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "diagnostics", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "getLanguageSettingsAllowMixedNamedAndPositionArguments", "()Z", "nameToParameter", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameters", "", "getParameters", "()Ljava/util/List;", "result", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallArgument;", "getResult", "()Ljava/util/Map;", "state", "Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$CallArgumentProcessor$State;", "varargArguments", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "addDiagnostic", "", "diagnostic", "addVarargArgument", "argument", "completeVarargPositionArguments", "findParameterByName", "name", "getDiagnostics", "getParameterByName", "processArgumentsInParenthesis", "arguments", "processDefaultsAndRunChecks", "processExternalArgument", "externalArgument", "processNamedArgument", "processPositionArgument", "getOverriddenParameterWithOtherName", "State", "resolution"})
    private static final class CallArgumentProcessor {
        @NotNull
        private final CallableDescriptor descriptor;
        private final boolean languageSettingsAllowMixedNamedAndPositionArguments;
        @NotNull
        private final Map<ValueParameterDescriptor, ResolvedCallArgument> result;
        @NotNull
        private State state;
        @Nullable
        private List<KotlinCallDiagnostic> diagnostics;
        @Nullable
        private Map<Name, ? extends ValueParameterDescriptor> nameToParameter;
        @Nullable
        private List<KotlinCallArgument> varargArguments;
        private int currentPositionedParameterIndex;

        public CallArgumentProcessor(@NotNull CallableDescriptor descriptor2, boolean languageSettingsAllowMixedNamedAndPositionArguments) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            this.descriptor = descriptor2;
            this.languageSettingsAllowMixedNamedAndPositionArguments = languageSettingsAllowMixedNamedAndPositionArguments;
            this.result = new LinkedHashMap();
            this.state = State.POSITION_ARGUMENTS;
        }

        @NotNull
        public final CallableDescriptor getDescriptor() {
            return this.descriptor;
        }

        public final boolean getLanguageSettingsAllowMixedNamedAndPositionArguments() {
            return this.languageSettingsAllowMixedNamedAndPositionArguments;
        }

        @NotNull
        public final Map<ValueParameterDescriptor, ResolvedCallArgument> getResult() {
            return this.result;
        }

        private final List<ValueParameterDescriptor> getParameters() {
            List<ValueParameterDescriptor> list2 = this.descriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.valueParameters");
            return list2;
        }

        private final void addDiagnostic(KotlinCallDiagnostic diagnostic) {
            if (this.diagnostics == null) {
                this.diagnostics = new ArrayList();
            }
            List<KotlinCallDiagnostic> list2 = this.diagnostics;
            Intrinsics.checkNotNull(list2);
            list2.add(diagnostic);
        }

        @NotNull
        public final List<KotlinCallDiagnostic> getDiagnostics() {
            List<KotlinCallDiagnostic> list2 = this.diagnostics;
            return list2 == null ? CollectionsKt.emptyList() : list2;
        }

        /*
         * WARNING - void declaration
         */
        private final ValueParameterDescriptor getParameterByName(Name name) {
            Object object;
            if (this.nameToParameter == null) {
                Map map;
                void $this$associateByTo$iv$iv;
                void $this$associateBy$iv;
                object = this.getParameters();
                CallArgumentProcessor callArgumentProcessor = this;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                void var5_6 = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)element$iv$iv;
                    map = destination$iv$iv;
                    boolean bl = false;
                    Name name2 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"it.name");
                    Name name3 = name2;
                    map.put(name3, element$iv$iv);
                }
                callArgumentProcessor.nameToParameter = map = destination$iv$iv;
            }
            object = this.nameToParameter;
            Intrinsics.checkNotNull(object);
            return (ValueParameterDescriptor)object.get(name);
        }

        private final void addVarargArgument(KotlinCallArgument argument2) {
            if (this.varargArguments == null) {
                this.varargArguments = new ArrayList();
            }
            List<KotlinCallArgument> list2 = this.varargArguments;
            Intrinsics.checkNotNull(list2);
            list2.add(argument2);
        }

        private final void completeVarargPositionArguments() {
            boolean bl = this.state == State.VARARG_POSITION;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = Intrinsics.stringPlus((String)"Incorrect state: ", (Object)((Object)this.state));
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            ValueParameterDescriptor parameter = this.getParameters().get(this.currentPositionedParameterIndex);
            ValueParameterDescriptor valueParameterDescriptor = parameter.getOriginal();
            List<KotlinCallArgument> list2 = this.varargArguments;
            Intrinsics.checkNotNull(list2);
            this.result.put(valueParameterDescriptor, new ResolvedCallArgument.VarargArgument(list2));
        }

        private final boolean processPositionArgument(KotlinCallArgument argument2) {
            if (this.state == State.NAMED_ONLY_ARGUMENTS) {
                this.addDiagnostic(new MixingNamedAndPositionArguments(argument2));
                return false;
            }
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)CollectionsKt.getOrNull(this.getParameters(), (int)this.currentPositionedParameterIndex);
            if (parameter == null) {
                this.addDiagnostic(new TooManyArguments(argument2, this.descriptor));
                return false;
            }
            if (!ArgumentsUtilsKt.isVararg(parameter)) {
                CallArgumentProcessor callArgumentProcessor = this;
                int n = callArgumentProcessor.currentPositionedParameterIndex;
                callArgumentProcessor.currentPositionedParameterIndex = n + 1;
                this.result.put(parameter.getOriginal(), new ResolvedCallArgument.SimpleArgument(argument2));
                return false;
            }
            this.addVarargArgument(argument2);
            return true;
        }

        private final void processNamedArgument(KotlinCallArgument argument2, Name name) {
            if (!this.descriptor.hasStableParameterNames()) {
                this.addDiagnostic(new NamedArgumentNotAllowed(argument2, this.descriptor));
            }
            boolean stateAllowsMixedNamedAndPositionArguments = this.state != State.NAMED_ONLY_ARGUMENTS;
            this.state = State.NAMED_ONLY_ARGUMENTS;
            Object object = this.findParameterByName(argument2, name);
            if (object == null) {
                return;
            }
            ValueParameterDescriptor parameter = object;
            this.addDiagnostic(new NamedArgumentReference(argument2, parameter));
            object = this.result.get(parameter.getOriginal());
            if (object != null) {
                Map<ValueParameterDescriptor, ResolvedCallArgument> map = object;
                boolean bl = false;
                boolean bl2 = false;
                Map<ValueParameterDescriptor, ResolvedCallArgument> it = map;
                boolean bl3 = false;
                this.addDiagnostic(new ArgumentPassedTwice(argument2, parameter, (ResolvedCallArgument)((Object)it)));
                return;
            }
            object = this.result;
            ValueParameterDescriptor valueParameterDescriptor = parameter.getOriginal();
            ResolvedCallArgument.SimpleArgument simpleArgument = new ResolvedCallArgument.SimpleArgument(argument2);
            boolean bl = false;
            object.put((ValueParameterDescriptor)valueParameterDescriptor, (ResolvedCallArgument)simpleArgument);
            if (stateAllowsMixedNamedAndPositionArguments && this.languageSettingsAllowMixedNamedAndPositionArguments && Intrinsics.areEqual((Object)((object = (ValueParameterDescriptor)CollectionsKt.getOrNull(this.getParameters(), (int)this.currentPositionedParameterIndex)) == null ? null : object.getOriginal()), (Object)parameter.getOriginal())) {
                this.state = State.POSITION_ARGUMENTS;
                object = this;
                int n = ((CallArgumentProcessor)object).currentPositionedParameterIndex;
                ((CallArgumentProcessor)object).currentPositionedParameterIndex = n + 1;
            }
        }

        private final ValueParameterDescriptor getOverriddenParameterWithOtherName(ValueParameterDescriptor $this$getOverriddenParameterWithOtherName) {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = $this$getOverriddenParameterWithOtherName.getOverriddenDescriptors();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl = false;
                    if (!(it.getContainingDeclaration().hasStableParameterNames() && !Intrinsics.areEqual((Object)it.getName(), (Object)$this$getOverriddenParameterWithOtherName.getName()))) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private final ValueParameterDescriptor findParameterByName(KotlinCallArgument argument2, Name name) {
            ValueParameterDescriptor parameter = this.getParameterByName(name);
            if (this.descriptor instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)this.descriptor).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                if (parameter == null) {
                    for (ValueParameterDescriptor valueParameter2 : ((CallableMemberDescriptor)this.descriptor).getValueParameters()) {
                        ValueParameterDescriptor matchedParameter;
                        Object v0;
                        block7: {
                            Iterable $this$firstOrNull$iv = valueParameter2.getOverriddenDescriptors();
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                                boolean bl = false;
                                if (!(it.getContainingDeclaration().hasStableParameterNames() && Intrinsics.areEqual((Object)it.getName(), (Object)name))) continue;
                                v0 = element$iv;
                                break block7;
                            }
                            v0 = null;
                        }
                        if ((matchedParameter = (ValueParameterDescriptor)v0) == null) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)valueParameter2, (String)"valueParameter");
                        this.addDiagnostic(new NamedArgumentReference(argument2, valueParameter2));
                        this.addDiagnostic(new NameForAmbiguousParameter(argument2, valueParameter2, matchedParameter));
                        return valueParameter2;
                    }
                } else {
                    ValueParameterDescriptor valueParameterDescriptor = this.getOverriddenParameterWithOtherName(parameter);
                    if (valueParameterDescriptor != null) {
                        ValueParameterDescriptor valueParameterDescriptor2 = valueParameterDescriptor;
                        boolean bl = false;
                        boolean bl2 = false;
                        ValueParameterDescriptor it = valueParameterDescriptor2;
                        boolean bl3 = false;
                        this.addDiagnostic(new NameForAmbiguousParameter(argument2, parameter, it));
                    }
                }
            }
            if (parameter == null) {
                this.addDiagnostic(new NameNotFound(argument2, this.descriptor));
            }
            return parameter;
        }

        public final void processArgumentsInParenthesis(@NotNull List<? extends KotlinCallArgument> arguments2) {
            Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
            for (KotlinCallArgument kotlinCallArgument : arguments2) {
                Name argumentName = kotlinCallArgument.getArgumentName();
                if (argumentName == null) {
                    if (!this.processPositionArgument(kotlinCallArgument)) continue;
                    this.state = State.VARARG_POSITION;
                    continue;
                }
                if (this.state == State.VARARG_POSITION) {
                    this.completeVarargPositionArguments();
                }
                this.processNamedArgument(kotlinCallArgument, argumentName);
            }
            if (this.state == State.VARARG_POSITION) {
                this.completeVarargPositionArguments();
            }
        }

        public final void processExternalArgument(@NotNull KotlinCallArgument externalArgument) {
            Intrinsics.checkNotNullParameter((Object)externalArgument, (String)"externalArgument");
            ValueParameterDescriptor lastParameter = (ValueParameterDescriptor)CollectionsKt.lastOrNull(this.getParameters());
            if (lastParameter == null) {
                this.addDiagnostic(new TooManyArguments(externalArgument, this.descriptor));
                return;
            }
            if (ArgumentsUtilsKt.isVararg(lastParameter)) {
                this.addDiagnostic(new VarargArgumentOutsideParentheses(externalArgument, lastParameter));
                return;
            }
            ResolvedCallArgument previousOccurrence = this.result.get(lastParameter.getOriginal());
            if (previousOccurrence != null) {
                this.addDiagnostic(new TooManyArguments(externalArgument, this.descriptor));
                return;
            }
            Map<ValueParameterDescriptor, ResolvedCallArgument> map = this.result;
            ValueParameterDescriptor valueParameterDescriptor = lastParameter.getOriginal();
            ResolvedCallArgument.SimpleArgument simpleArgument = new ResolvedCallArgument.SimpleArgument(externalArgument);
            boolean bl = false;
            map.put(valueParameterDescriptor, simpleArgument);
        }

        public final void processDefaultsAndRunChecks() {
            boolean bl;
            Object object;
            Object object2;
            Object object3 = this.result;
            boolean bl2 = false;
            Iterator<Object> iterator2 = object3.entrySet().iterator();
            while (iterator2.hasNext()) {
                object2 = object3 = iterator2.next();
                boolean bl3 = false;
                ValueParameterDescriptor parameter = (ValueParameterDescriptor)object2.getKey();
                object = object3;
                bl = false;
                ResolvedCallArgument resolvedArgument = (ResolvedCallArgument)object.getValue();
                if (ArgumentsUtilsKt.isVararg(parameter)) continue;
                if (!(resolvedArgument instanceof ResolvedCallArgument.SimpleArgument)) {
                    object = "Incorrect resolved argument for parameter " + parameter + " :" + resolvedArgument;
                    bl = false;
                    throw (Throwable)new IllegalStateException(object.toString());
                }
                if (!((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument().isSpread()) continue;
                this.addDiagnostic(new NonVarargSpread(((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument()));
            }
            for (ValueParameterDescriptor parameter : this.getParameters()) {
                if (this.result.containsKey(parameter.getOriginal())) continue;
                if (ArgumentsUtilsKt.hasDefaultValue(parameter)) {
                    Map<ValueParameterDescriptor, ResolvedCallArgument> map = this.result;
                    object2 = parameter.getOriginal();
                    object = ResolvedCallArgument.DefaultArgument.INSTANCE;
                    bl = false;
                    map.put((ValueParameterDescriptor)object2, (ResolvedCallArgument)object);
                    continue;
                }
                if (ArgumentsUtilsKt.isVararg(parameter)) {
                    Map<ValueParameterDescriptor, ResolvedCallArgument> map = this.result;
                    object2 = parameter.getOriginal();
                    object = new ResolvedCallArgument.VarargArgument(CollectionsKt.emptyList());
                    bl = false;
                    map.put((ValueParameterDescriptor)object2, (ResolvedCallArgument)object);
                    continue;
                }
                this.addDiagnostic(new NoValueForParameter(parameter, this.descriptor));
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$CallArgumentProcessor$State;", "", "(Ljava/lang/String;I)V", "POSITION_ARGUMENTS", "VARARG_POSITION", "NAMED_ONLY_ARGUMENTS", "resolution"})
        private static final class State
        extends Enum<State> {
            public static final /* enum */ State POSITION_ARGUMENTS = new State();
            public static final /* enum */ State VARARG_POSITION = new State();
            public static final /* enum */ State NAMED_ONLY_ARGUMENTS = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                State[] stateArray = $VALUES;
                State[] stateArray2 = new State[stateArray.length];
                System.arraycopy(stateArray, 0, stateArray2, 0, stateArray.length);
                return stateArray2;
            }

            public static State valueOf(String value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                return Enum.valueOf(State.class, value2);
            }

            static {
                $VALUES = stateArray = new State[]{State.POSITION_ARGUMENTS, State.VARARG_POSITION, State.NAMED_ONLY_ARGUMENTS};
            }
        }
    }
}

