/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DataClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.LocalVariableResolver;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.checkers.TrailingCommaChecker;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.FakeCallKind;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J4\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J2\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eJ8\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/types/expressions/DestructuringDeclarationResolver;", "", "fakeCallResolver", "Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;", "localVariableResolver", "Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "(Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;Lorg/jetbrains/kotlin/resolve/TypeResolver;)V", "defineLocalVariablesFromDestructuringDeclaration", "", "writableScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "destructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "initializer", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "getExpectedTypeForComponent", "Lorg/jetbrains/kotlin/types/KotlinType;", "entry", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "resolveComponentFunctionAndGetType", "componentName", "Lorg/jetbrains/kotlin/name/Name;", "resolveInitializer", "componentIndex", "", "resolveLocalVariablesFromDestructuringDeclaration", "", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "frontend"})
public final class DestructuringDeclarationResolver {
    @NotNull
    private final FakeCallResolver fakeCallResolver;
    @NotNull
    private final LocalVariableResolver localVariableResolver;
    @NotNull
    private final TypeResolver typeResolver;

    public DestructuringDeclarationResolver(@NotNull FakeCallResolver fakeCallResolver, @NotNull LocalVariableResolver localVariableResolver, @NotNull TypeResolver typeResolver) {
        Intrinsics.checkNotNullParameter((Object)fakeCallResolver, (String)"fakeCallResolver");
        Intrinsics.checkNotNullParameter((Object)localVariableResolver, (String)"localVariableResolver");
        Intrinsics.checkNotNullParameter((Object)typeResolver, (String)"typeResolver");
        this.fakeCallResolver = fakeCallResolver;
        this.localVariableResolver = localVariableResolver;
        this.typeResolver = typeResolver;
    }

    @NotNull
    public final List<VariableDescriptor> resolveLocalVariablesFromDestructuringDeclaration(@NotNull LexicalScope scope2, @NotNull KtDestructuringDeclaration destructuringDeclaration, @Nullable ReceiverValue receiver, @Nullable KtExpression initializer2, @NotNull ExpressionTypingContext context2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        boolean bl = false;
        ArrayList<LocalVariableDescriptor> result2 = new ArrayList<LocalVariableDescriptor>();
        Object object = destructuringDeclaration.getEntries().iterator();
        int n = 0;
        while (object.hasNext()) {
            int componentIndex = n++;
            KtDestructuringDeclarationEntry entry = (KtDestructuringDeclarationEntry)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
            KotlinType componentType = this.resolveInitializer(entry, receiver, initializer2, context2, componentIndex);
            KtVariableDeclaration ktVariableDeclaration = entry;
            BindingTrace bindingTrace = context2.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
            LocalVariableDescriptor variableDescriptor = this.localVariableResolver.resolveLocalVariableDescriptorWithType$frontend(scope2, ktVariableDeclaration, componentType, bindingTrace);
            result2.add(variableDescriptor);
        }
        PsiElement psiElement = destructuringDeclaration.getTrailingComma();
        object = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.trace");
        Object object2 = object;
        object = context2.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.languageVersionSettings");
        TrailingCommaChecker.INSTANCE.check(psiElement, (BindingTrace)object2, (LanguageVersionSettings)object);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public final void defineLocalVariablesFromDestructuringDeclaration(@NotNull LexicalWritableScope writableScope, @NotNull KtDestructuringDeclaration destructuringDeclaration, @Nullable ReceiverValue receiver, @Nullable KtExpression initializer2, @NotNull ExpressionTypingContext context2) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)writableScope, (String)"writableScope");
        Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Iterable iterable = this.resolveLocalVariablesFromDestructuringDeclaration(writableScope, destructuringDeclaration, receiver, initializer2, context2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VariableDescriptor it = (VariableDescriptor)element$iv;
            boolean bl = false;
            ExpressionTypingUtils.checkVariableShadowing(writableScope, context2.trace, it);
            writableScope.addVariableDescriptor(it);
        }
    }

    @NotNull
    public final KotlinType resolveInitializer(@NotNull KtDestructuringDeclarationEntry entry, @Nullable ReceiverValue receiver, @Nullable KtExpression initializer2, @NotNull ExpressionTypingContext context2, int componentIndex) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Name componentName = DataClassDescriptorResolver.INSTANCE.createComponentName(componentIndex + 1);
        return this.resolveComponentFunctionAndGetType(componentName, context2, entry, receiver, initializer2);
    }

    private final KotlinType resolveComponentFunctionAndGetType(Name componentName, ExpressionTypingContext context2, KtDestructuringDeclarationEntry entry, ReceiverValue receiver, KtExpression initializer2) {
        Object object;
        if (receiver == null) {
            return DestructuringDeclarationResolver.resolveComponentFunctionAndGetType$errorType(componentName);
        }
        KotlinType expectedType2 = this.getExpectedTypeForComponent(context2, entry);
        Object Context2 = ((ExpressionTypingContext)context2.replaceExpectedType(expectedType2)).replaceContextDependency(ContextDependency.INDEPENDENT);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"context.replaceExpectedType(expectedType).replaceContextDependency(ContextDependency.INDEPENDENT)");
        ExpressionTypingContext newContext = (ExpressionTypingContext)Context2;
        KtExpression ktExpression = initializer2;
        OverloadResolutionResults<FunctionDescriptor> results = this.fakeCallResolver.resolveFakeCall(newContext, receiver, componentName, entry, ktExpression == null ? (KtExpression)entry : ktExpression, FakeCallKind.COMPONENT, CollectionsKt.emptyList());
        if (!results.isSuccess()) {
            return DestructuringDeclarationResolver.resolveComponentFunctionAndGetType$errorType(componentName);
        }
        context2.trace.record(BindingContext.COMPONENT_RESOLVED_CALL, entry, results.getResultingCall());
        KotlinType functionReturnType = results.getResultingDescriptor().getReturnType();
        if (functionReturnType != null && !TypeUtils.noExpectedType(expectedType2) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(functionReturnType, expectedType2)) {
            object = initializer2;
            context2.trace.report(Errors.COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)(object == null ? (KtExpression)entry : object)), componentName, functionReturnType, expectedType2));
        }
        return (object = functionReturnType) == null ? (KotlinType)DestructuringDeclarationResolver.resolveComponentFunctionAndGetType$errorType(componentName) : object;
    }

    private final KotlinType getExpectedTypeForComponent(ExpressionTypingContext context2, KtDestructuringDeclarationEntry entry) {
        KtTypeReference ktTypeReference = entry.getTypeReference();
        if (ktTypeReference == null) {
            SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"NO_EXPECTED_TYPE");
            return simpleType2;
        }
        Object object = ktTypeReference;
        KtTypeReference entryTypeRef = object;
        object = context2.scope;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.scope");
        Object object2 = object;
        object = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.trace");
        return this.typeResolver.resolveType((LexicalScope)object2, entryTypeRef, (BindingTrace)object, true);
    }

    private static final SimpleType resolveComponentFunctionAndGetType$errorType(Name $componentName) {
        SimpleType simpleType2 = ErrorUtils.createErrorType($componentName + "() return type");
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"createErrorType(\"$componentName() return type\")");
        return simpleType2;
    }
}

