/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.auth;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.ui.AppUIUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0003\u001a\n\u0010\u0005\u001a\u0004\u0018\u00010\u0001H\u0003\u00a8\u0006\u0006"}, d2={"createAuthPage", "", "server", "loadAuthResourceFileContent", "fileName", "loadProductSvg", "intellij.space"})
public final class AuthPageKt {
    @NotNull
    public static final String createAuthPage(@NotNull String server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        HtmlChunk.Element element = HtmlChunk.html().child((HtmlChunk)HtmlChunk.head().child((HtmlChunk)HtmlChunk.styleTag((String)AuthPageKt.loadAuthResourceFileContent("spaceAuthPage.css"))));
        HtmlChunk.Element element2 = HtmlChunk.body();
        HtmlChunk.Element element3 = HtmlChunk.div().attr("class", "central-div").child((HtmlChunk)HtmlChunk.div().attr("class", "central-div-header").child((HtmlChunk)HtmlChunk.div().attr("class", "central-div-header-icon").addRaw(AuthPageKt.loadAuthResourceFileContent("spaceAuthIcon.svg"))).child((HtmlChunk)HtmlChunk.div().attr("class", "central-div-header-text").addText(SpaceBundle.message("auth.page.jetbrains.space.header.text", new Object[0]))));
        HtmlChunk.Element element4 = HtmlChunk.div().attr("class", "central-div-content");
        HtmlChunk.Element element5 = HtmlChunk.div().attr("class", "central-div-content-icon");
        String string = AuthPageKt.loadProductSvg();
        if (string == null) {
            string = "";
        }
        String string2 = element.child((HtmlChunk)element2.child((HtmlChunk)element3.child((HtmlChunk)element4.child((HtmlChunk)element5.addRaw(string)).child((HtmlChunk)HtmlChunk.div().attr("class", "central-div-content-text").addText(SpaceBundle.message("auth.page.content.text", new Object[0])))).child((HtmlChunk)HtmlChunk.link((String)server, (String)SpaceBundle.message("auth.page.go.to.space.link", new Object[0])).attr("class", "central-div-content-link")))).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"html()\n  .child(\n    hea\u2026)\n    )\n  )\n  .toString()");
        return string2;
    }

    @NlsSafe
    private static final String loadAuthResourceFileContent(String fileName) {
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"com.jetbrains.space"));
        if (ideaPluginDescriptor == null) {
            throw (Throwable)new IllegalStateException("Couldn't find space plugin descriptor");
        }
        Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor, (String)"PluginManagerCore.getPlu\u2026space plugin descriptor\")");
        IdeaPluginDescriptor plugin = ideaPluginDescriptor;
        InputStream inputStream = plugin.getClassLoader().getResourceAsStream("auth/" + fileName);
        Intrinsics.checkNotNull((Object)inputStream);
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Closeable closeable = inputStream2;
        int n = 0;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        n = 8192;
        boolean bl2 = false;
        return TextStreamsKt.readText((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
    }

    @NlsSafe
    private static final String loadProductSvg() {
        String string = AppUIUtil.findIcon();
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        String string2 = it;
        String string3 = (string2 != null ? StringsKt.endsWith$default((String)string2, (String)".svg", (boolean)false, (int)2, null) : false) ? string : null;
        if (string3 != null) {
            string = string3;
            bl = false;
            bl2 = false;
            String iconPath = string;
            boolean bl4 = false;
            File iconFile = new File(iconPath);
            if (iconFile.exists() && iconFile.isFile()) {
                return FilesKt.readText((File)iconFile, (Charset)Charsets.UTF_8);
            }
        }
        return null;
    }
}

